/* Copyright (C) 1999-2004  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

/*******************************************************************/
/*                                                                 */
/*                DECLARATIONS of PUBLIC FUNCTIONS                 */
/*                                                                 */
/*******************************************************************/
#include "parinf.h"

/* black box groups */
struct bb_group
{
  GEN   (*mul)(void *E, GEN, GEN);
  GEN   (*pow)(void *E, GEN, GEN);
  GEN   (*rand)(void *E);
  ulong (*hash)(GEN);
  int   (*equal)(GEN,GEN);
  int   (*equal1)(GEN);
  GEN   (*easylog)(void *E, GEN, GEN, GEN);
};

/* black box fields */
struct bb_field
{
  GEN (*red)(void *E ,GEN);
  GEN (*add)(void *E ,GEN, GEN);
  GEN (*mul)(void *E ,GEN, GEN);
  GEN (*neg)(void *E ,GEN);
  GEN (*inv)(void *E ,GEN);
  int (*equal0)(GEN);
  GEN (*s)(void *E, long);
};

/* black box algebra */
struct bb_algebra
{
  GEN (*red)(void *E, GEN x);
  GEN (*add)(void *E, GEN x, GEN y);
  GEN (*sub)(void *E, GEN x, GEN y);
  GEN (*mul)(void *E, GEN x, GEN y);
  GEN (*sqr)(void *E, GEN x);
  GEN (*one)(void *E);
  GEN (*zero)(void *E);
};

/* black box ring */
struct bb_ring
{
  GEN (*add)(void *E, GEN x, GEN y);
  GEN (*mul)(void *E, GEN x, GEN y);
  GEN (*sqr)(void *E, GEN x);
};

/* OBSOLETE */
GEN     buchimag(GEN D, GEN c1, GEN c2, GEN gCO);
GEN     buchreal(GEN D, GEN gsens, GEN c1, GEN c2, GEN gRELSUP, long prec);
GEN     zidealstar(GEN nf, GEN x);
GEN     zidealstarinit(GEN nf, GEN x);
GEN     zidealstarinitgen(GEN nf, GEN x);
GEN     factmod(GEN f, GEN p);
void    mpbern(long n, long prec);
GEN     simplefactmod(GEN f, GEN p);
GEN     isprincipalforce(GEN bnf,GEN x);
GEN     isprincipalgen(GEN bnf, GEN x);
GEN     isprincipalgenforce(GEN bnf,GEN x);

/* F2v.c */

GEN     F2Ms_ker(GEN M, long nrows);
GEN     F2Ms_to_F2m(GEN M, long nrows);
GEN     F2c_to_ZC(GEN x);
GEN     F2c_to_mod(GEN x);
GEN     F2m_F2c_gauss(GEN a, GEN b);
GEN     F2m_F2c_invimage(GEN A, GEN y);
GEN     F2m_F2c_mul(GEN x, GEN y);
GEN     F2m_deplin(GEN x);
ulong   F2m_det(GEN x);
ulong   F2m_det_sp(GEN x);
GEN     F2m_gauss(GEN a, GEN b);
GEN     F2m_inv(GEN x);
GEN     F2m_invimage(GEN A, GEN B);
GEN     F2m_ker(GEN x);
GEN     F2m_ker_sp(GEN x, long deplin);
GEN     F2m_mul(GEN x, GEN y);
GEN     F2m_powu(GEN x, ulong n);
long    F2m_rank(GEN x);
GEN     F2m_row(GEN x, long j);
GEN     F2m_rowslice(GEN x, long a, long b);
GEN     F2m_to_F2Ms(GEN M);
GEN     F2m_to_Flm(GEN z);
GEN     F2m_to_ZM(GEN z);
GEN     F2m_to_mod(GEN z);
GEN     F2m_transpose(GEN x);
void    F2v_add_inplace(GEN x, GEN y);
void    F2v_and_inplace(GEN x, GEN y);
ulong   F2v_dotproduct(GEN x, GEN y);
int     F2v_equal0(GEN a);
ulong   F2v_hamming(GEN H);
void    F2v_negimply_inplace(GEN x, GEN y);
void    F2v_or_inplace(GEN x, GEN y);
GEN     F2v_slice(GEN x, long a, long b);
int     F2v_subset(GEN x, GEN y);
GEN     F2v_to_Flv(GEN x);
GEN     RgV_F2v_extract_shallow(GEN V, GEN x);
GEN     matid_F2m(long n);

/* F2x.c */

GEN     F2x_F2xq_eval(GEN Q, GEN x, GEN T);
GEN     F2x_F2xqV_eval(GEN P, GEN V, GEN T);
GEN     F2x_Frobenius(GEN T);
GEN     F2x_1_add(GEN y);
GEN     F2x_add(GEN x, GEN y);
GEN     F2x_deflate(GEN x0, long d);
GEN     F2x_degfact(GEN f);
long    F2x_degree(GEN x);
GEN     F2x_deriv(GEN x);
GEN     F2x_divrem(GEN x, GEN y, GEN *pr);
ulong   F2x_eval(GEN P, ulong x);
void    F2x_even_odd(GEN p, GEN *pe, GEN *po);
GEN     F2x_extgcd(GEN a, GEN b, GEN *ptu, GEN *ptv);
GEN     F2x_gcd(GEN a, GEN b);
GEN     F2x_get_red(GEN T);
GEN     F2x_halfgcd(GEN a, GEN b);
int     F2x_issquare(GEN a);
GEN     F2x_matFrobenius(GEN T);
GEN     F2x_mul(GEN x, GEN y);
GEN     F2x_recip(GEN T);
GEN     F2x_rem(GEN x, GEN y);
GEN     F2x_shift(GEN y, long d);
GEN     F2x_sqr(GEN x);
GEN     F2x_sqrt(GEN x);
GEN     F2x_to_F2v(GEN x, long n);
GEN     F2x_to_F2xX(GEN z, long sv);
GEN     F2x_to_Flx(GEN x);
GEN     F2x_to_ZX(GEN x);
long    F2x_valrem(GEN x, GEN *Z);
GEN     F2xC_to_FlxC(GEN v);
GEN     F2xC_to_ZXC(GEN x);
GEN     F2xV_to_F2m(GEN v, long n);
void    F2xV_to_FlxV_inplace(GEN v);
void    F2xV_to_ZXV_inplace(GEN v);
GEN     F2xX_F2x_add(GEN x, GEN y);
GEN     F2xX_F2x_mul(GEN P, GEN U);
GEN     F2xX_add(GEN x, GEN y);
GEN     F2xX_deriv(GEN z);
GEN     F2xX_renormalize(GEN /*in place*/ x, long lx);
GEN     F2xX_to_Kronecker(GEN P, long d);
GEN     F2xX_to_FlxX(GEN B);
GEN     F2xX_to_ZXX(GEN B);
GEN     F2xX_to_F2xC(GEN x, long N, long sv);
GEN     F2xXV_to_F2xM(GEN v, long n, long sv);
GEN     F2xXC_to_ZXXC(GEN B);
GEN     F2xY_F2xq_evalx(GEN P, GEN x, GEN T);
GEN     F2xY_F2xqV_evalx(GEN P, GEN x, GEN T);
long    F2xY_degreex(GEN b);
GEN     F2xn_div(GEN g, GEN f, long e);
GEN     F2xn_inv(GEN f, long e);
GEN     F2xn_red(GEN a, long n);
GEN     F2xq_Artin_Schreier(GEN a, GEN T);
GEN     F2xq_autpow(GEN x, long n, GEN T);
GEN     F2xq_conjvec(GEN x, GEN T);
GEN     F2xq_div(GEN x,GEN y,GEN T);
GEN     F2xq_inv(GEN x, GEN T);
GEN     F2xq_invsafe(GEN x, GEN T);
GEN     F2xq_log(GEN a, GEN g, GEN ord, GEN T);
GEN     F2xq_matrix_pow(GEN y, long n, long m, GEN P);
GEN     F2xq_mul(GEN x, GEN y, GEN pol);
GEN     F2xq_order(GEN a, GEN ord, GEN T);
GEN     F2xq_pow(GEN x, GEN n, GEN pol);
GEN     F2xq_pow_init(GEN x, GEN n, long k,  GEN T);
GEN     F2xq_pow_table(GEN R, GEN n, GEN T);
GEN     F2xq_powu(GEN x, ulong n, GEN pol);
GEN     F2xq_powers(GEN x, long l, GEN T);
GEN     F2xq_sqr(GEN x,GEN pol);
GEN     F2xq_sqrt(GEN a, GEN T);
GEN     F2xq_sqrt_fast(GEN c, GEN sqx, GEN T);
GEN     F2xq_sqrtn(GEN a, GEN n, GEN T, GEN *zeta);
ulong   F2xq_trace(GEN x, GEN T);
GEN     F2xqV_roots_to_pol(GEN V, GEN T, long v);
GEN     F2xqX_F2xq_mul(GEN P, GEN U, GEN T);
GEN     F2xqX_F2xq_mul_to_monic(GEN P, GEN U, GEN T);
GEN     F2xqX_F2xqXQ_eval(GEN Q, GEN x, GEN S, GEN T);
GEN     F2xqX_F2xqXQV_eval(GEN P, GEN V, GEN S, GEN T);
GEN     F2xqX_disc(GEN x, GEN T);
GEN     F2xqX_divrem(GEN x, GEN y, GEN T, GEN *pr);
GEN     F2xqX_extgcd(GEN x, GEN y, GEN T,  GEN *ptu, GEN *ptv);
GEN     F2xqX_gcd(GEN a, GEN b, GEN T);
GEN     F2xqX_get_red(GEN S, GEN T);
GEN     F2xqX_halfgcd(GEN x, GEN y, GEN T);
GEN     F2xqX_halfgcd_all(GEN x, GEN y, GEN T, GEN *a, GEN *b);
GEN     F2xqX_invBarrett(GEN T, GEN Q);
long    F2xqX_ispower(GEN f, long k, GEN T, GEN *pt_r);
GEN     F2xqX_mul(GEN x, GEN y, GEN T);
long    F2xqX_nbroots(GEN f, GEN T);
GEN     F2xqX_normalize(GEN z, GEN T);
GEN     F2xqX_powu(GEN x, ulong n, GEN T);
GEN     F2xqX_red(GEN z, GEN T);
GEN     F2xqX_rem(GEN x, GEN S, GEN T);
GEN     F2xqX_resultant(GEN x, GEN y, GEN T);
GEN     F2xqX_sqr(GEN x, GEN T);
GEN     F2xqXQ_inv(GEN x, GEN S, GEN T);
GEN     F2xqXQ_invsafe(GEN x, GEN S, GEN T);
GEN     F2xqXQ_mul(GEN x, GEN y, GEN S, GEN T);
GEN     F2xqXQ_sqr(GEN x, GEN S, GEN T);
GEN     F2xqXQ_pow(GEN x, GEN n, GEN S, GEN T);
GEN     F2xqXQ_powers(GEN x, long l, GEN S, GEN T);
GEN     F2xqXQ_autpow(GEN aut, long n, GEN S, GEN T);
GEN     F2xqXQ_auttrace(GEN aut, long n, GEN S, GEN T);
GEN     F2xqXQV_red(GEN z, GEN S, GEN T);
GEN     F2xqXV_prod(GEN V, GEN T);
GEN     Flm_to_F2m(GEN x);
GEN     Flv_to_F2v(GEN x);
GEN     Flx_to_F2x(GEN x);
GEN     FlxC_to_F2xC(GEN x);
GEN     FlxX_to_F2xX(GEN B);
GEN     FlxXC_to_F2xXC(GEN B);
GEN     Kronecker_to_F2xqX(GEN z, GEN T);
GEN     Rg_to_F2xq(GEN x, GEN T);
GEN     RgM_to_F2m(GEN x);
GEN     RgV_to_F2v(GEN x);
GEN     RgX_to_F2x(GEN x);
GEN     Z_to_F2x(GEN x, long v);
GEN     ZM_to_F2m(GEN x);
GEN     ZV_to_F2v(GEN x);
GEN     ZX_to_F2x(GEN x);
GEN     ZXX_to_F2xX(GEN B, long v);
GEN     const_F2v(long m);
GEN     gener_F2xq(GEN T, GEN *po);
const struct bb_field *get_F2xq_field(void **E, GEN T);
GEN     monomial_F2x(long d, long vs);
GEN     pol1_F2xX(long v, long sv);
GEN     polx_F2xX(long v, long sv);
GEN     random_F2xqX(long d1, long v, GEN T);

/* F2xqE.c */

GEN     F2x_Teichmuller(GEN P, long n);
GEN     F2xq_ellcard(GEN a2, GEN a6, GEN T);
GEN     F2xq_ellgens(GEN a2, GEN a6, GEN ch, GEN D, GEN m, GEN T);
GEN     F2xq_ellgroup(GEN a2, GEN a6, GEN N, GEN T, GEN *pt_m);
void    F2xq_elltwist(GEN a, GEN a6, GEN T, GEN *pt_a, GEN *pt_a6);
GEN     F2xqE_add(GEN P, GEN Q, GEN a2, GEN T);
GEN     F2xqE_changepoint(GEN x, GEN ch, GEN T);
GEN     F2xqE_changepointinv(GEN x, GEN ch, GEN T);
GEN     F2xqE_dbl(GEN P, GEN a2, GEN T);
GEN     F2xqE_log(GEN a, GEN b, GEN o, GEN a2, GEN T);
GEN     F2xqE_mul(GEN P, GEN n, GEN a2, GEN T);
GEN     F2xqE_neg(GEN P, GEN a2, GEN T);
GEN     F2xqE_order(GEN z, GEN o, GEN a2, GEN T);
GEN     F2xqE_sub(GEN P, GEN Q, GEN a2, GEN T);
GEN     F2xqE_tatepairing(GEN t, GEN s, GEN m, GEN a2, GEN T);
GEN     F2xqE_weilpairing(GEN t, GEN s, GEN m, GEN a2, GEN T);
const struct bb_group * get_F2xqE_group(void **E, GEN a2, GEN a6, GEN T);
GEN     RgE_to_F2xqE(GEN x, GEN T);
GEN     random_F2xqE(GEN a2, GEN a6, GEN T);

/* F3v.c */

GEN     F3c_to_mod(GEN x);
GEN     F3c_to_ZC(GEN x);
GEN     F3m_ker(GEN x);
GEN     F3m_ker_sp(GEN x, long deplin);
GEN     F3m_mul(GEN x, GEN y);
GEN     F3m_row(GEN x, long j);
GEN     F3m_to_Flm(GEN z);
GEN     F3m_to_ZM(GEN z);
GEN     F3m_to_mod(GEN x);
GEN     F3m_transpose(GEN x);
GEN     F3v_to_Flv(GEN x);
ulong   F3v_coeff(GEN x,long v);
void    F3v_clear(GEN x, long v);
void    F3v_set(GEN x, long v, ulong n);
GEN     Flm_to_F3m(GEN x);
GEN     Flv_to_F3v(GEN x);
GEN     RgM_to_F3m(GEN x);
GEN     RgV_to_F3v(GEN x);
GEN     ZM_to_F3m(GEN x);
GEN     ZV_to_F3v(GEN x);
GEN     zero_F3m_copy(long m, long n);
GEN     zero_F3v(long m);

/* Fle.c */

ulong   Fl_elldisc(ulong a4, ulong a6, ulong p);
ulong   Fl_elldisc_pre(ulong a4, ulong a6, ulong p, ulong pi);
ulong   Fl_ellj(ulong a4, ulong a6, ulong p);
void    Fl_ellj_to_a4a6(ulong j, ulong p, ulong *pt_a4, ulong *pt_a6);
GEN     Fl_ellptors(ulong l, ulong N, ulong a4, ulong a6, ulong p);
void    Fl_elltwist(ulong a4, ulong a6, ulong p, ulong *pt_a4, ulong *pt_a6);
void    Fl_elltwist_disc(ulong a4, ulong a6, ulong D, ulong p, ulong *pt_a4, ulong *pt_a6);
GEN     Fle_add(GEN P, GEN Q, ulong a4, ulong p);
GEN     Fle_dbl(GEN P, ulong a4, ulong p);
GEN     Fle_changepoint(GEN x, GEN ch, ulong p);
GEN     Fle_changepointinv(GEN x, GEN ch, ulong p);
GEN     Fle_log(GEN a, GEN b, GEN o, ulong a4, ulong p);
GEN     Fle_mul(GEN P, GEN n, ulong a4, ulong p);
GEN     Fle_mulu(GEN P, ulong n, ulong a4, ulong p);
GEN     Fle_order(GEN z, GEN o, ulong a4, ulong p);
GEN     Fle_sub(GEN P, GEN Q, ulong a4, ulong p);
ulong   Fle_tatepairing(GEN P, GEN Q, ulong m, ulong a4, ulong p);
GEN     Fle_to_Flj(GEN P);
ulong   Fle_weilpairing(GEN P, GEN Q, ulong m, ulong a4, ulong p);
GEN     Flj_add_pre(GEN P, GEN Q, ulong a4, ulong p, ulong pi);
GEN     Flj_changepointinv_pre(GEN P, GEN ch, ulong p, ulong pi);
GEN     Flj_dbl_pre(GEN P, ulong a4, ulong p, ulong pi);
GEN     Flj_mulu_pre(GEN P, ulong n, ulong a4, ulong p, ulong pi);
GEN     Flj_neg(GEN Q, ulong p);
GEN     Flj_to_Fle(GEN P, ulong p);
GEN     Flj_to_Fle_pre(GEN P, ulong p, ulong pi);
GEN     FljV_factorback_pre(GEN P, GEN L, ulong a4, ulong p, ulong pi);
GEN     random_Fle(ulong a4, ulong a6, ulong p);
GEN     random_Fle_pre(ulong a4, ulong a6, ulong p, ulong pi);
GEN     random_Flj_pre(ulong a4, ulong a6, ulong p, ulong pi);

/* Flv.c */

GEN     Flc_to_ZC(GEN z);
GEN     Flc_to_ZC_inplace(GEN z);
GEN     Flm_Flc_gauss(GEN a, GEN b, ulong p);
GEN     Flm_Flc_invimage(GEN mat, GEN y, ulong p);
GEN     Flm_adjoint(GEN A, ulong p);
GEN     Flm_deplin(GEN x, ulong p);
ulong   Flm_det(GEN x, ulong p);
ulong   Flm_det_sp(GEN x, ulong p);
GEN     Flm_gauss(GEN a, GEN b, ulong p);
GEN     Flm_intersect(GEN x, GEN y, ulong p);
GEN     Flm_intersect_i(GEN x, GEN y, ulong p);
GEN     Flm_inv(GEN x, ulong p);
GEN     Flm_invimage(GEN m, GEN v, ulong p);
GEN     Flm_ker(GEN x, ulong p);
GEN     Flm_ker_sp(GEN x, ulong p, long deplin);
long    Flm_rank(GEN x, ulong p);
GEN     Flm_to_ZM(GEN z);
GEN     Flm_to_ZM_inplace(GEN z);
GEN     Flv_to_ZV(GEN z);

/* Flx.c */

GEN     Fl_to_Flx(ulong x, long sv);
int     Fl2_equal1(GEN x);
GEN     Fl2_inv_pre(GEN x, ulong D, ulong p, ulong pi);
GEN     Fl2_mul_pre(GEN x, GEN y, ulong D, ulong p, ulong pi);
ulong   Fl2_norm_pre(GEN x, ulong D, ulong p, ulong pi);
GEN     Fl2_pow_pre(GEN x, GEN n, ulong D, ulong p, ulong pi);
GEN     Fl2_sqr_pre(GEN x, ulong D, ulong p, ulong pi);
GEN     Fl2_sqrt_pre(GEN z, ulong D, ulong p, ulong pi);
GEN     Fl2_sqrtn_pre(GEN a, GEN n, ulong D, ulong p, ulong pi, GEN *zeta);
GEN     Flm_to_FlxV(GEN x, long sv);
GEN     Flm_to_FlxX(GEN x, long v,long w);
GEN     Flv_Flm_polint(GEN xa, GEN ya, ulong p, long vs);
GEN     Flv_inv(GEN x, ulong p);
void    Flv_inv_inplace(GEN x, ulong p);
void    Flv_inv_pre_inplace(GEN x, ulong p, ulong pi);
GEN     Flv_inv_pre(GEN x, ulong p, ulong pi);
GEN     Flv_invVandermonde(GEN L, ulong den, ulong p);
GEN     Flv_polint(GEN xa, GEN ya, ulong p, long vs);
ulong   Flv_prod(GEN v, ulong p);
ulong   Flv_prod_pre(GEN x, ulong p, ulong pi);
GEN     Flv_roots_to_pol(GEN a, ulong p, long vs);
GEN     Flv_to_Flx(GEN x, long vs);
GEN     Flx_Fl_add(GEN y, ulong x, ulong p);
GEN     Flx_Fl_mul(GEN y, ulong x, ulong p);
GEN     Flx_Fl_mul_pre(GEN y, ulong x, ulong p, ulong pi);
GEN     Flx_Fl_mul_to_monic(GEN y, ulong x, ulong p);
GEN     Flx_Fl_sub(GEN y, ulong x, ulong p);
GEN     Flx_Fl2_eval_pre(GEN x, GEN y, ulong D, ulong p, ulong pi);
GEN     Flx_Flv_multieval(GEN P, GEN v, ulong p);
GEN     Flx_Flxq_eval(GEN f,GEN x,GEN T,ulong p);
GEN     Flx_Flxq_eval_pre(GEN f,GEN x,GEN T,ulong p,ulong pi);
GEN     Flx_FlxqV_eval(GEN f,GEN x,GEN T,ulong p);
GEN     Flx_FlxqV_eval_pre(GEN f,GEN x,GEN T,ulong p,ulong pi);
GEN     Flx_Frobenius(GEN T, ulong p);
GEN     Flx_Frobenius_pre(GEN T, ulong p, ulong pi);
GEN     Flx_Laplace(GEN x, ulong p);
GEN     Flx_Newton(GEN P, long n, ulong p);
GEN     Flx_add(GEN x, GEN y, ulong p);
GEN     Flx_blocks(GEN P, long n, long m);
GEN     Flx_composedprod(GEN P, GEN Q, ulong p);
GEN     Flx_composedsum(GEN P, GEN Q, ulong p);
GEN     Flx_convol(GEN x, GEN y, ulong p);
GEN     Flx_deflate(GEN x0, long d);
GEN     Flx_deriv(GEN z, ulong p);
GEN     Flx_diff1(GEN P, ulong p);
GEN     Flx_digits(GEN x, GEN T, ulong p);
GEN     Flx_div_by_X_x(GEN a, ulong x, ulong p, ulong *rem);
GEN     Flx_divrem(GEN x, GEN y, ulong p, GEN *pr);
GEN     Flx_divrem_pre(GEN x, GEN T, ulong p, ulong pi, GEN *pr);
GEN     Flx_double(GEN y, ulong p);
int     Flx_equal(GEN V, GEN W);
ulong   Flx_eval(GEN x, ulong y, ulong p);
ulong   Flx_eval_powers_pre(GEN x, GEN y, ulong p, ulong pi);
ulong   Flx_eval_pre(GEN x, ulong y, ulong p, ulong pi);
GEN     Flx_extgcd(GEN a, GEN b, ulong p, GEN *ptu, GEN *ptv);
GEN     Flx_extgcd_pre(GEN x, GEN y, ulong p, ulong pi, GEN *ptu, GEN *ptv);
ulong   Flx_extresultant(GEN a, GEN b, ulong p, GEN *ptU, GEN *ptV);
ulong   Flx_extresultant_pre(GEN a, GEN b, ulong p, ulong pi, GEN *ptU, GEN *ptV);
GEN     Flx_fromNewton(GEN P, ulong p);
GEN     Flx_gcd(GEN a, GEN b, ulong p);
GEN     Flx_gcd_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flx_get_red(GEN T, ulong p);
GEN     Flx_get_red_pre(GEN T, ulong p, ulong pi);
GEN     Flx_halfgcd(GEN a, GEN b, ulong p);
GEN     Flx_halfgcd_all(GEN a, GEN b, ulong p, GEN *pU, GEN *pV);
GEN     Flx_halfgcd_all_pre(GEN a, GEN b, ulong p, ulong pi, GEN *pU, GEN *pV);
GEN     Flx_halfgcd_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flx_halve(GEN y, ulong p);
GEN     Flx_inflate(GEN x0, long d);
GEN     Flx_integ(GEN z, ulong p);
GEN     Flx_invBarrett(GEN T, ulong p);
GEN     Flx_invLaplace(GEN x, ulong p);
int     Flx_is_squarefree(GEN z, ulong p);
int     Flx_is_smooth(GEN g, long r, ulong p);
int     Flx_is_smooth_pre(GEN g, long r, ulong p, ulong pi);
GEN     Flx_matFrobenius(GEN T, ulong p);
GEN     Flx_matFrobenius_pre(GEN T, ulong p, ulong pi);
GEN     Flx_mod_Xn1(GEN T, ulong n, ulong p);
GEN     Flx_mod_Xnm1(GEN T, ulong n, ulong p);
GEN     Flx_mul(GEN x, GEN y, ulong p);
GEN     Flx_mul_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flx_neg(GEN x, ulong p);
GEN     Flx_neg_inplace(GEN x, ulong p);
GEN     Flx_normalize(GEN z, ulong p);
GEN     Flx_powu(GEN x, ulong n, ulong p);
GEN     Flx_powu_pre(GEN x, ulong n, ulong p, ulong pi);
GEN     Flx_recip(GEN x);
GEN     Flx_red(GEN z, ulong p);
GEN     Flx_rem(GEN x, GEN y, ulong p);
GEN     Flx_rem_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     Flx_renormalize(GEN x, long l);
GEN     Flx_rescale(GEN P, ulong h, ulong p);
ulong   Flx_resultant(GEN a, GEN b, ulong p);
ulong   Flx_resultant_pre(GEN a, GEN b, ulong p, ulong pi);
GEN     Flx_shift(GEN a, long n);
GEN     Flx_splitting(GEN p, long k);
GEN     Flx_sqr(GEN x, ulong p);
GEN     Flx_sqr_pre(GEN x, ulong p, ulong pi);
GEN     Flx_sub(GEN x, GEN y, ulong p);
GEN     Flx_Fl_translate(GEN P, ulong c, ulong p);
GEN     Flx_translate1(GEN P, ulong p);
GEN     Flx_translate1_basecase(GEN P, ulong p);
GEN     Flx_to_Flv(GEN x, long N);
GEN     Flx_to_FlxX(GEN z, long v);
GEN     Flx_to_ZX(GEN z);
GEN     Flx_to_ZX_inplace(GEN z);
GEN     Flx_triple(GEN y, ulong p);
GEN     Flx_unscale(GEN P, ulong h, ulong p);
long    Flx_val(GEN x);
long    Flx_valrem(GEN x, GEN *Z);
GEN     FlxC_FlxqV_eval(GEN x, GEN v, GEN T, ulong p);
GEN     FlxC_FlxqV_eval_pre(GEN x, GEN v, GEN T, ulong p, ulong pi);
GEN     FlxC_Flxq_eval(GEN x, GEN F, GEN T, ulong p);
GEN     FlxC_Flxq_eval_pre(GEN x, GEN F, GEN T, ulong p, ulong pi);
GEN     FlxC_eval_powers_pre(GEN z, GEN x, ulong p, ulong pi);
GEN     FlxC_neg(GEN x, ulong p);
GEN     FlxC_sub(GEN x, GEN y, ulong p);
GEN     FlxC_to_ZXC(GEN x);
GEN     FlxC_Fl_translate(GEN x, ulong c, ulong p);
GEN     FlxM_Flx_add_shallow(GEN x, GEN y, ulong p);
GEN     FlxM_eval_powers_pre(GEN z, GEN x, ulong p, ulong pi);
GEN     FlxM_mul(GEN x, GEN y, ulong p);
GEN     FlxM_neg(GEN x, ulong p);
GEN     FlxM_sub(GEN x, GEN y, ulong p);
GEN     FlxM_to_FlxXV(GEN x, long v);
GEN     FlxM_to_ZXM(GEN z);
GEN     FlxM_Fl_translate(GEN x, ulong c, ulong p);
GEN     FlxT_red(GEN z, ulong p);
GEN     FlxV_Flc_mul(GEN V, GEN W, ulong p);
GEN     FlxV_Flv_multieval(GEN P, GEN v, ulong p);
GEN     FlxV_Flx_fromdigits(GEN x, GEN T, ulong p);
GEN     FlxV_composedsum(GEN V, ulong p);
GEN     FlxV_prod(GEN V, ulong p);
GEN     FlxV_factorback(GEN F, GEN E, ulong p, long v);
GEN     FlxV_red(GEN z, ulong p);
GEN     FlxV_to_Flm(GEN v, long n);
GEN     FlxV_to_FlxX(GEN x, long v);
GEN     FlxV_to_ZXV(GEN x);
void    FlxV_to_ZXV_inplace(GEN v);
GEN     Flxn_div(GEN g, GEN f, long e, ulong p);
GEN     Flxn_div_pre(GEN g, GEN f, long e, ulong p, ulong pi);
GEN     Flxn_exp(GEN h, long e, ulong p);
GEN     Flxn_expint(GEN h, long e, ulong p);
GEN     Flxn_inv(GEN f, long e, ulong p);
GEN     Flxn_mul(GEN a, GEN b, long n, ulong p);
GEN     Flxn_mul_pre(GEN a, GEN b, long n, ulong p, ulong pi);
GEN     Flxn_sqr(GEN a, long n, ulong p);
GEN     Flxn_sqr_pre(GEN a, long n, ulong p, ulong pi);
GEN     Flxn_red(GEN a, long n);
GEN     Flxq_autpow(GEN x, ulong n, GEN T, ulong p);
GEN     Flxq_autpow_pre(GEN x, ulong n, GEN T, ulong p, ulong pi);
GEN     Flxq_autpowers(GEN x, ulong n, GEN T, ulong p);
GEN     Flxq_autsum(GEN x, ulong n, GEN T, ulong p);
GEN     Flxq_auttrace(GEN x, ulong n, GEN T, ulong p);
GEN     Flxq_auttrace_pre(GEN x, ulong n, GEN T, ulong p, ulong pi);
GEN     Flxq_charpoly(GEN x, GEN T, ulong p);
GEN     Flxq_conjvec(GEN x, GEN T, ulong p);
GEN     Flxq_div(GEN x, GEN y, GEN T, ulong p);
GEN     Flxq_div_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
GEN     Flxq_inv(GEN x,GEN T,ulong p);
GEN     Flxq_inv_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     Flxq_invsafe(GEN x, GEN T, ulong p);
GEN     Flxq_invsafe_pre(GEN x, GEN T, ulong p, ulong pi);
int     Flxq_issquare(GEN x, GEN T, ulong p);
int     Flxq_is2npower(GEN x, long n, GEN T, ulong p);
GEN     Flxq_log(GEN a, GEN g, GEN ord, GEN T, ulong p);
GEN     Flxq_lroot(GEN a, GEN T, long p);
GEN     Flxq_lroot_pre(GEN a, GEN T, long p, ulong pi);
GEN     Flxq_lroot_fast(GEN a, GEN sqx, GEN T, long p);
GEN     Flxq_lroot_fast_pre(GEN a, GEN sqx, GEN T, long p, ulong pi);
GEN     Flxq_matrix_pow(GEN y, long n, long m, GEN P, ulong l);
GEN     Flxq_matrix_pow_pre(GEN y, long n, long m, GEN P, ulong l, ulong li);
GEN     Flxq_minpoly(GEN x, GEN T, ulong p);
GEN     Flxq_minpoly_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     Flxq_mul(GEN x, GEN y, GEN T, ulong p);
GEN     Flxq_mul_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
ulong   Flxq_norm(GEN x, GEN T, ulong p);
GEN     Flxq_order(GEN a, GEN ord, GEN T, ulong p);
GEN     Flxq_pow(GEN x, GEN n, GEN T, ulong p);
GEN     Flxq_pow_pre(GEN x, GEN n, GEN T, ulong p, ulong pi);
GEN     Flxq_pow_init(GEN x, GEN n, long k,  GEN T, ulong p);
GEN     Flxq_pow_init_pre(GEN x, GEN n, long k, GEN T, ulong p, ulong pi);
GEN     Flxq_pow_table_pre(GEN R, GEN n, GEN T, ulong p, ulong pi);
GEN     Flxq_pow_table(GEN R, GEN n, GEN T, ulong p);
GEN     Flxq_powu(GEN x, ulong n, GEN T, ulong p);
GEN     Flxq_powu_pre(GEN x, ulong n, GEN T, ulong p, ulong pi);
GEN     Flxq_powers(GEN x, long l, GEN T, ulong p);
GEN     Flxq_powers_pre(GEN x, long l, GEN T, ulong p, ulong pi);
GEN     Flxq_sqr(GEN y,GEN T,ulong p);
GEN     Flxq_sqr_pre(GEN y,GEN T,ulong p,ulong pi);
GEN     Flxq_sqrt(GEN a, GEN T, ulong p);
GEN     Flxq_sqrt_pre(GEN z, GEN T, ulong p, ulong pi);
GEN     Flxq_sqrtn(GEN a, GEN n, GEN T, ulong p, GEN *zetan);
ulong   Flxq_trace(GEN x, GEN T, ulong p);
GEN     FlxqC_Flxq_mul(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqC_red_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     FlxqM_Flxq_mul(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqM_red_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     FlxqV_dotproduct(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqV_dotproduct_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
ulong   Rg_to_F2(GEN x);
ulong   Rg_to_Fl(GEN x, ulong p);
GEN     Rg_to_Flxq(GEN x, GEN T, ulong p);
GEN     RgX_to_Flx(GEN x, ulong p);
GEN     RgXV_to_FlxV(GEN x, ulong p);
GEN     Z_to_Flx(GEN x, ulong p, long sv);
GEN     ZX_to_Flx(GEN x, ulong p);
GEN     ZXV_to_FlxV(GEN v, ulong p);
GEN     ZXT_to_FlxT(GEN z, ulong p);
GEN     gener_Flxq(GEN T, ulong p, GEN *o);
const struct bb_field *get_Flxq_field(void **E, GEN T, ulong p);
const struct bb_group *get_Flxq_star(void **E, GEN T, ulong p);
GEN     monomial_Flx(ulong a, long d, long vs);
GEN     random_Flx(long d1, long v, ulong p);
GEN     zero_FlxC(long n, long sv);
GEN     zero_FlxM(long r, long c, long sv);
GEN     zero_FlxM_copy(long r, long c, long sv);
GEN     zlx_translate1(GEN P, ulong p, long e);
GEN     zx_to_Flx(GEN x, ulong p);

/* FlxX.c */

GEN     FlxX_Fl_mul(GEN x, ulong y, ulong p);
GEN     FlxY_Flx_add(GEN y, GEN x, ulong p);
GEN     FlxY_Flx_div(GEN x, GEN y, ulong p);
GEN     FlxY_Flx_div_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     FlxY_Flx_mul(GEN x, GEN y, ulong p);
GEN     FlxY_Flx_mul_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     FlxY_Flx_sub(GEN y, GEN x, ulong p);
GEN     FlxX_Laplace(GEN x, ulong p);
GEN     FlxX_add(GEN P, GEN Q, ulong p);
GEN     FlxX_blocks(GEN P, long n, long m, long vs);
GEN     FlxX_deriv(GEN z, ulong p);
GEN     FlxX_double(GEN x, ulong p);
GEN     FlxX_invLaplace(GEN x, ulong p);
GEN     FlxX_neg(GEN x, ulong p);
GEN     FlxX_renormalize(GEN x, long lx);
GEN     FlxX_shift(GEN a, long n, long vs);
GEN     FlxX_sub(GEN P, GEN Q, ulong p);
GEN     FlxX_swap(GEN x, long n, long ws);
GEN     FlxX_to_Flm(GEN v, long n);
GEN     FlxX_to_Flx(GEN f);
GEN     FlxX_to_FlxC(GEN x, long N, long sv);
GEN     FlxX_to_ZXX(GEN B);
GEN     FlxX_translate1(GEN P, long p, long n);
GEN     FlxX_triple(GEN x, ulong p);
GEN     FlxXC_sub(GEN x, GEN y, ulong p);
GEN     FlxXC_to_ZXXC(GEN B);
GEN     FlxXM_to_ZXXM(GEN B);
GEN     FlxXV_to_FlxM(GEN v, long n, long sv);
GEN     FlxXn_red(GEN a, long n);
GEN     FlxY_Flx_translate(GEN P, GEN c, ulong p);
GEN     FlxY_FlxqV_evalx(GEN P, GEN x, GEN T, ulong p);
GEN     FlxY_FlxqV_evalx_pre(GEN P, GEN x, GEN T, ulong p, ulong pi);
GEN     FlxY_Flxq_evalx(GEN P, GEN x, GEN T, ulong p);
GEN     FlxY_Flxq_evalx_pre(GEN P, GEN x, GEN T, ulong p, ulong pi);
GEN     FlxY_evalx(GEN Q, ulong x, ulong p);
GEN     FlxY_evalx_powers_pre(GEN pol, GEN ypowers, ulong p, ulong pi);
GEN     FlxY_evalx_pre(GEN Q, ulong x, ulong p, ulong pi);
GEN     FlxYqq_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     FlxqV_roots_to_pol(GEN V, GEN T, ulong p, long v);
GEN     FlxqXC_FlxqXQV_eval(GEN x, GEN v, GEN S, GEN T, ulong p);
GEN     FlxqXC_FlxqXQV_eval_pre(GEN x, GEN v, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXC_FlxqXQ_eval(GEN x, GEN F, GEN S, GEN T, ulong p);
GEN     FlxqXQ_autpow(GEN x, long n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_autpow_pre(GEN aut, long n, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_autsum(GEN aut, long n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_autsum_pre(GEN aut, long n, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_auttrace(GEN x, ulong n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_auttrace_pre(GEN x, ulong n, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_div(GEN x, GEN y, GEN S, GEN T, ulong p);
GEN     FlxqXQ_div_pre(GEN x, GEN y, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_inv(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_inv_pre(GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_invsafe(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_invsafe_pre(GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_matrix_pow(GEN x, long n, long m, GEN S, GEN T, ulong p);
GEN     FlxqXQ_minpoly(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_minpoly_pre(GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_mul(GEN x, GEN y, GEN S, GEN T, ulong p);
GEN     FlxqXQ_mul_pre(GEN x, GEN y, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_pow_pre(GEN x, GEN n, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_powers(GEN x, long n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_powers_pre(GEN x, long l, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_powu(GEN x, ulong n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_powu_pre(GEN x, ulong n, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXQ_sqr(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_sqr_pre(GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqXV_prod(GEN V, GEN T, ulong p);
GEN     FlxqX_FlxqXQV_eval(GEN P, GEN V, GEN S, GEN T, ulong p);
GEN     FlxqX_FlxqXQV_eval_pre(GEN Q, GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqX_FlxqXQ_eval(GEN Q, GEN x, GEN S, GEN T, ulong p);
GEN     FlxqX_FlxqXQ_eval_pre(GEN Q, GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqX_Flxq_mul(GEN P, GEN U, GEN T, ulong p);
GEN     FlxqX_Flxq_mul_pre(GEN P, GEN U, GEN T, ulong p, ulong pi);
GEN     FlxqX_Flxq_mul_to_monic(GEN P, GEN U, GEN T, ulong p);
GEN     FlxqX_Flxq_mul_to_monic_pre(GEN P, GEN U, GEN T, ulong p, ulong pi);
GEN     FlxqX_Newton(GEN P, long n, GEN T, ulong p);
GEN     FlxqX_Newton_pre(GEN P, long n, GEN T, ulong p, ulong pi);
GEN     FlxqX_composedsum(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_disc(GEN x, GEN T, ulong p);
GEN     FlxqX_div_by_X_x(GEN a, GEN x, GEN T, ulong p, GEN *r);
GEN     FlxqX_div_by_X_x_pre(GEN a, GEN x, GEN T, ulong p, ulong pi, GEN *r);
GEN     FlxqX_divrem(GEN x, GEN y, GEN T, ulong p, GEN *pr);
GEN     FlxqX_divrem_pre(GEN x, GEN S, GEN T, ulong p, long pi, GEN *pr);
GEN     FlxqX_dotproduct(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_eval(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_extgcd(GEN a, GEN b, GEN T, ulong p, GEN *ptu, GEN *ptv);
GEN     FlxqX_extgcd_pre(GEN x, GEN y, GEN T, ulong p, ulong pi, GEN *ptu, GEN *ptv);
GEN     FlxqX_fromNewton(GEN P, GEN T, ulong p);
GEN     FlxqX_fromNewton_pre(GEN P, GEN T, ulong p, ulong pi);
GEN     FlxqX_gcd(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_gcd_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
GEN     FlxqX_get_red(GEN S, GEN T, ulong p);
GEN     FlxqX_get_red_pre(GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqX_halfgcd(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_halfgcd_all(GEN x, GEN y, GEN T, ulong p, GEN *a, GEN *b);
GEN     FlxqX_halfgcd_all_pre(GEN x, GEN y, GEN T, ulong p, ulong pi, GEN *a, GEN *b);
GEN     FlxqX_halfgcd_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
GEN     FlxqX_invBarrett(GEN T, GEN Q, ulong p);
GEN     FlxqX_invBarrett_pre(GEN T, GEN Q, ulong p, ulong pi);
GEN     FlxqX_mul(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_mul_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
GEN     FlxqX_normalize(GEN z, GEN T, ulong p);
GEN     FlxqX_normalize_pre(GEN z, GEN T, ulong p, ulong pi);
GEN     FlxqX_powu(GEN V, ulong n, GEN T, ulong p);
GEN     FlxqX_powu_pre(GEN V, ulong n, GEN T, ulong p, ulong pi);
GEN     FlxqX_red(GEN z, GEN T, ulong p);
GEN     FlxqX_red_pre(GEN z, GEN T, ulong p, ulong pi);
GEN     FlxqX_rem(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_rem_pre(GEN x, GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqX_resultant(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_resultant_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
GEN     FlxqX_safegcd(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_saferesultant(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqX_sqr(GEN x, GEN T, ulong p);
GEN     FlxqX_sqr_pre(GEN x, GEN T, ulong p, ulong pi);
GEN     FlxqXn_expint(GEN h, long e, GEN T, ulong p);
GEN     FlxqXn_expint_pre(GEN h, long e, GEN T, ulong p, ulong pi);
GEN     FlxqXn_inv(GEN f, long e, GEN T, ulong p);
GEN     FlxqXn_inv_pre(GEN f, long e, GEN T, ulong p, ulong pi);
GEN     FlxqXn_mul(GEN a, GEN b, long n, GEN T, ulong p);
GEN     FlxqXn_mul_pre(GEN a, GEN b, long n, GEN T, ulong p, ulong pi);
GEN     FlxqXn_sqr(GEN a, long n, GEN T, ulong p);
GEN     FlxqXn_sqr_pre(GEN a, long n, GEN T, ulong p, ulong pi);
long    FlxY_degreex(GEN b);
ulong   FlxY_eval_powers_pre(GEN pol, GEN yp, GEN xp, ulong p,ulong pi);
GEN     Fly_to_FlxY(GEN B, long v);
GEN     Kronecker_to_FlxqX(GEN z, GEN T, ulong p);
GEN     Kronecker_to_FlxqX_pre(GEN z, GEN T, ulong p, ulong pi);
GEN     RgX_to_FlxqX(GEN x, GEN T, ulong p);
const struct bb_algebra * get_FlxqX_algebra(void **E, GEN T, ulong p, long v);
const struct bb_algebra * get_FlxqXQ_algebra(void **E, GEN S, GEN T, ulong p);
GEN     pol1_FlxX(long v, long sv);
GEN     polx_FlxX(long v, long sv);
GEN     random_FlxqX(long d1, long v, GEN T, ulong p);
GEN     zlxX_translate1(GEN P, long p, long e, long n);
GEN     zxX_to_FlxX(GEN B, ulong p);
GEN     zxX_to_Kronecker(GEN P, GEN Q);

/* FlxqE.c */

GEN     Flxq_ellcard(GEN a4, GEN a6, GEN T, ulong p);
GEN     Flxq_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN T, ulong p);
GEN     Flxq_ellgroup(GEN a4, GEN a6, GEN N, GEN T, ulong p, GEN *pt_m);
void    Flxq_elltwist(GEN a, GEN a6, GEN T, ulong p, GEN *pt_a, GEN *pt_a6);
GEN     Flxq_ellj(GEN a4, GEN a6, GEN T, ulong p);
void    Flxq_ellj_to_a4a6(GEN j, GEN T, ulong p, GEN *pt_a4, GEN *pt_a6);
GEN     FlxqE_add(GEN P, GEN Q, GEN a4, GEN T, ulong p);
GEN     FlxqE_changepoint(GEN x, GEN ch, GEN T, ulong p);
GEN     FlxqE_changepointinv(GEN x, GEN ch, GEN T, ulong p);
GEN     FlxqE_dbl(GEN P, GEN a4, GEN T, ulong p);
GEN     FlxqE_log(GEN a, GEN b, GEN o, GEN a4, GEN T, ulong p);
GEN     FlxqE_mul(GEN P, GEN n, GEN a4, GEN T, ulong p);
GEN     FlxqE_neg(GEN P, GEN T, ulong p);
GEN     FlxqE_order(GEN z, GEN o, GEN a4, GEN T, ulong p);
GEN     FlxqE_sub(GEN P, GEN Q, GEN a4, GEN T, ulong p);
GEN     FlxqE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN T, ulong p);
GEN     FlxqE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN T, ulong p);
GEN     FlxqE_weilpairing_pre(GEN P, GEN Q, GEN m, GEN a4, GEN T, ulong p, ulong pi);
GEN     ZXX_to_FlxX(GEN B, ulong p, long v);
GEN     ZXXT_to_FlxXT(GEN z, ulong p, long v);
GEN     ZXXV_to_FlxXV(GEN V, ulong p, long v);
const struct bb_group * get_FlxqE_group(void **E, GEN a4, GEN a6, GEN T, ulong p);
GEN     RgE_to_FlxqE(GEN x, GEN T, ulong p);
GEN     random_FlxqE(GEN a4, GEN a6, GEN T, ulong p);
long    polisclass(GEN H);

/* FpE.c */

long    Fl_elltrace(ulong a4, ulong a6, ulong p);
long    Fl_elltrace_CM(long CM, ulong a4, ulong a6, ulong p);
GEN     Fp_ellcard(GEN a4, GEN a6, GEN p);
GEN     Fp_elldivpol(GEN a4, GEN a6, long n, GEN p);
GEN     Fp_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN p);
GEN     Fp_ellgroup(GEN a4, GEN a6, GEN N, GEN p, GEN *pt_m);
GEN     Fp_ellj(GEN a4, GEN a6, GEN p);
void    Fp_ellj_to_a4a6(GEN j, GEN p, GEN *pt_a4, GEN *pt_a6);
int     Fp_elljissupersingular(GEN j, GEN p);
void    Fp_elltwist(GEN a4, GEN a6, GEN p, GEN *pt_a4, GEN *pt_a6);
GEN     Fp_ffellcard(GEN a4, GEN a6, GEN q, long n, GEN p);
GEN     FpE_add(GEN P, GEN Q, GEN a4, GEN p);
GEN     FpE_changepoint(GEN x, GEN ch, GEN p);
GEN     FpE_changepointinv(GEN x, GEN ch, GEN p);
GEN     FpE_dbl(GEN P, GEN a4, GEN p);
GEN     FpE_log(GEN a, GEN b, GEN o, GEN a4, GEN p);
GEN     FpE_mul(GEN P, GEN n, GEN a4, GEN p);
GEN     FpE_neg(GEN P, GEN p);
GEN     FpE_order(GEN z, GEN o, GEN a4, GEN p);
GEN     FpE_sub(GEN P, GEN Q, GEN a4, GEN p);
GEN     FpE_to_FpJ(GEN P);
GEN     FpE_to_mod(GEN P, GEN p);
GEN     FpE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN p);
GEN     FpE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN p);
GEN     FpJ_add(GEN P, GEN Q, GEN a4, GEN p);
GEN     FpJ_dbl(GEN P, GEN a4, GEN p);
GEN     FpJ_mul(GEN P, GEN n, GEN a4, GEN p);
GEN     FpJ_neg(GEN Q, GEN p);
GEN     FpJ_to_FpE(GEN P, GEN p);
GEN     FpXQ_ellcard(GEN a4, GEN a6, GEN T, GEN p);
GEN     FpXQ_ellcard_supersingular(GEN a4, GEN a6, GEN T, GEN p);
GEN     FpXQ_elldivpol(GEN a4, GEN a6, long n, GEN T, GEN p);
GEN     FpXQ_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN T, GEN p);
GEN     FpXQ_ellgroup(GEN a4, GEN a6, GEN N, GEN T, GEN p, GEN *pt_m);
GEN     FpXQ_ellj(GEN a4, GEN a6, GEN T, GEN p);
int     FpXQ_elljissupersingular(GEN j, GEN T, GEN p);
void    FpXQ_elltwist(GEN a4, GEN a6, GEN T, GEN p, GEN *pt_a4, GEN *pt_a6);
GEN     FpXQE_add(GEN P, GEN Q, GEN a4, GEN T, GEN p);
GEN     FpXQE_changepoint(GEN x, GEN ch, GEN T, GEN p);
GEN     FpXQE_changepointinv(GEN x, GEN ch, GEN T, GEN p);
GEN     FpXQE_dbl(GEN P, GEN a4, GEN T, GEN p);
GEN     FpXQE_log(GEN a, GEN b, GEN o, GEN a4, GEN T, GEN p);
GEN     FpXQE_mul(GEN P, GEN n, GEN a4, GEN T, GEN p);
GEN     FpXQE_neg(GEN P, GEN T, GEN p);
GEN     FpXQE_order(GEN z, GEN o, GEN a4, GEN T, GEN p);
GEN     FpXQE_sub(GEN P, GEN Q, GEN a4, GEN T, GEN p);
GEN     FpXQE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN T, GEN p);
GEN     FpXQE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN T, GEN p);
int     Fq_elljissupersingular(GEN j, GEN T, GEN p);
GEN     Fq_ellcard_supersingular(GEN a4, GEN a6, GEN T, GEN p);
GEN     RgE_to_FpE(GEN x, GEN p);
GEN     RgE_to_FpXQE(GEN x, GEN T, GEN p);
const struct bb_group * get_FpE_group(void **E, GEN a4, GEN a6, GEN p);
const struct bb_group * get_FpXQE_group(void **E, GEN a4, GEN a6, GEN T, GEN p);
GEN     ellsupersingularj_FpXQ(GEN T, GEN p);
GEN     elltrace_extension(GEN t, long n, GEN p);
GEN     random_FpE(GEN a4, GEN a6, GEN p);
GEN     random_FpXQE(GEN a4, GEN a6, GEN T, GEN p);

/* FpX.c */

int     Fp_issquare(GEN x, GEN p);
GEN     Fp_FpX_sub(GEN x, GEN y, GEN p);
GEN     Fp_FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p);
GEN     FpV_FpM_polint(GEN xa, GEN ya, GEN p, long vs);
GEN     FpV_inv(GEN x, GEN p);
GEN     FpV_invVandermonde(GEN L, GEN den, GEN p);
GEN     FpV_polint(GEN xa, GEN ya, GEN p, long v);
GEN     FpV_roots_to_pol(GEN V, GEN p, long v);
GEN     FpX_Fp_add(GEN x, GEN y, GEN p);
GEN     FpX_Fp_add_shallow(GEN y,GEN x,GEN p);
GEN     FpX_Fp_div(GEN x, GEN y, GEN p);
GEN     FpX_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpX_Fp_mul_to_monic(GEN y,GEN x,GEN p);
GEN     FpX_Fp_mulspec(GEN y,GEN x,GEN p,long ly);
GEN     FpX_Fp_sub(GEN x, GEN y, GEN p);
GEN     FpX_Fp_sub_shallow(GEN y,GEN x,GEN p);
GEN     FpX_FpV_multieval(GEN P, GEN xa, GEN p);
GEN     FpX_FpXQ_eval(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_FpXQV_eval(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_FpXV_multirem(GEN P, GEN xa, GEN p);
GEN     FpX_Frobenius(GEN T, GEN p);
GEN     FpX_Laplace(GEN x, GEN p);
GEN     FpX_Newton(GEN P, long n, GEN p);
GEN     FpX_add(GEN x, GEN y, GEN p);
GEN     FpX_center(GEN x, GEN p, GEN pov2);
GEN     FpX_center_i(GEN T, GEN p, GEN pov2);
GEN     FpX_chinese_coprime(GEN x,GEN y,GEN Tx,GEN Ty,GEN Tz,GEN p);
GEN     FpX_composedprod(GEN P, GEN Q, GEN p);
GEN     FpX_composedsum(GEN P, GEN Q, GEN p);
GEN     FpX_convol(GEN x, GEN y, GEN p);
GEN     FpX_deriv(GEN x, GEN p);
GEN     FpX_digits(GEN x, GEN y, GEN p);
GEN     FpX_disc(GEN x, GEN p);
GEN     FpX_div_by_X_x(GEN a, GEN x, GEN p, GEN *r);
GEN     FpX_divrem(GEN x, GEN y, GEN p, GEN *pr);
GEN     FpX_divu(GEN x, ulong y, GEN p);
GEN     FpX_dotproduct(GEN x, GEN y, GEN p);
GEN     FpX_eval(GEN x,GEN y,GEN p);
GEN     FpX_extgcd(GEN x, GEN y, GEN p, GEN *ptu, GEN *ptv);
GEN     FpX_extresultant(GEN a, GEN b, GEN p, GEN *ptU, GEN *ptV);
GEN     FpX_fromNewton(GEN P, GEN p);
GEN     FpX_gcd(GEN x, GEN y, GEN p);
GEN     FpX_gcd_check(GEN x, GEN y, GEN p);
GEN     FpX_get_red(GEN T, GEN p);
GEN     FpX_halve(GEN y, GEN p);
GEN     FpX_halfgcd(GEN x, GEN y, GEN p);
GEN     FpX_halfgcd_all(GEN x, GEN y, GEN p, GEN *ptU, GEN *ptV);
GEN     FpX_integ(GEN x, GEN p);
GEN     FpX_invBarrett(GEN T, GEN p);
GEN     FpX_invLaplace(GEN x, GEN p);
int     FpX_is_squarefree(GEN f, GEN p);
GEN     FpX_matFrobenius(GEN T, GEN p);
GEN     FpX_mul(GEN x, GEN y, GEN p);
GEN     FpX_mulspec(GEN a, GEN b, GEN p, long na, long nb);
GEN     FpX_mulu(GEN x, ulong y, GEN p);
GEN     FpX_neg(GEN x, GEN p);
GEN     FpX_normalize(GEN z, GEN p);
GEN     FpX_powu(GEN x, ulong n, GEN p);
GEN     FpX_red(GEN z, GEN p);
GEN     FpX_rem(GEN x, GEN y, GEN p);
GEN     FpX_rescale(GEN P, GEN h, GEN p);
GEN     FpX_resultant(GEN a, GEN b, GEN p);
GEN     FpX_sqr(GEN x, GEN p);
GEN     FpX_sub(GEN x, GEN y, GEN p);
long    FpX_valrem(GEN x0, GEN t, GEN p, GEN *py);
GEN     FpXC_FpXQ_eval(GEN Q, GEN x, GEN T, GEN p);
GEN     FpXC_FpXQV_eval(GEN Q, GEN x, GEN T, GEN p);
GEN     FpXM_FpXQV_eval(GEN Q, GEN x, GEN T, GEN p);
GEN     FpXQ_autpow(GEN x, ulong n, GEN T, GEN p);
GEN     FpXQ_autpowers(GEN aut, long f, GEN T, GEN p);
GEN     FpXQ_autsum(GEN x, ulong n, GEN T, GEN p);
GEN     FpXQ_auttrace(GEN x, ulong n, GEN T, GEN p);
GEN     FpXQ_charpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_conjvec(GEN x, GEN T, GEN p);
GEN     FpXQ_div(GEN x,GEN y,GEN T,GEN p);
GEN     FpXQ_inv(GEN x,GEN T,GEN p);
GEN     FpXQ_invsafe(GEN x, GEN T, GEN p);
int     FpXQ_issquare(GEN x, GEN T, GEN p);
GEN     FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p);
GEN     FpXQ_matrix_pow(GEN y, long n, long m, GEN P, GEN l);
GEN     FpXQ_minpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_mul(GEN y,GEN x,GEN T,GEN p);
GEN     FpXQ_norm(GEN x, GEN T, GEN p);
GEN     FpXQ_order(GEN a, GEN ord, GEN T, GEN p);
GEN     FpXQ_pow(GEN x, GEN n, GEN T, GEN p);
GEN     FpXQ_powu(GEN x, ulong n, GEN T, GEN p);
GEN     FpXQ_powers(GEN x, long l, GEN T, GEN p);
GEN     FpXQ_red(GEN x, GEN T, GEN p);
GEN     FpXQ_sqr(GEN y, GEN T, GEN p);
GEN     FpXQ_sqrt(GEN a, GEN T, GEN p);
GEN     FpXQ_sqrtn(GEN a, GEN n, GEN T, GEN p, GEN *zetan);
GEN     FpXQ_trace(GEN x, GEN T, GEN p);
GEN     FpXQC_to_mod(GEN z, GEN T, GEN p);
GEN     FpXQM_autsum(GEN x, ulong n, GEN T, GEN p);
GEN     FpXT_red(GEN z, GEN p);
GEN     FpXV_FpX_fromdigits(GEN x, GEN T, GEN p);
GEN     FpXV_chinese(GEN A, GEN P, GEN p, GEN *pt_mod);
GEN     FpXV_composedsum(GEN V, GEN p);
GEN     FpXV_factorback(GEN fa, GEN e, GEN p, long v);
GEN     FpXV_prod(GEN V, GEN p);
GEN     FpXV_red(GEN z, GEN p);
GEN     FpXk_gcd(GEN x, GEN y, GEN p);
GEN     FpXk_red(GEN z, GEN p);
GEN     FpXn_div(GEN g, GEN f, long n, GEN p);
GEN     FpXn_exp(GEN x, long n, GEN p);
GEN     FpXn_expint(GEN x, long n, GEN p);
GEN     FpXn_inv(GEN x, long n, GEN p);
GEN     FpXn_mul(GEN a, GEN b, long n, GEN p);
GEN     FpXn_sqr(GEN a, long n, GEN p);
int     Fq_issquare(GEN x, GEN T, GEN p);
long    Fq_ispower(GEN x, GEN K, GEN T, GEN p);
GEN     Fq_log(GEN a, GEN g, GEN ord, GEN T, GEN p);
GEN     FqC_to_mod(GEN z, GEN T, GEN p);
GEN     FqM_to_mod(GEN z, GEN T, GEN p);
GEN     FqV_inv(GEN x, GEN T, GEN p);
int     Rg_is_FpXk(GEN x, GEN *p);
GEN     Rg_to_FpXk(GEN x, GEN p);
GEN     Z_to_FpX(GEN a, GEN p, long v);
GEN     gener_FpXQ(GEN T, GEN p, GEN *o);
GEN     gener_FpXQ_local(GEN T, GEN p, GEN L);
const struct bb_group * get_FpXQ_star(void **E, GEN T, GEN p);
const struct bb_algebra * get_FpX_algebra(void **E, GEN p, long v);
const struct bb_algebra * get_FpXQ_algebra(void **E, GEN T, GEN p);
GEN     random_FpX(long d, long v, GEN p);

/* FpX_factor.c */

GEN     F2x_ddf(GEN f);
GEN     F2x_factor(GEN f);
GEN     F2x_factor_squarefree(GEN f);
int     F2x_is_irred(GEN f);
GEN     Flx_ddf(GEN T, ulong p);
GEN     Flx_ddf_pre(GEN T, ulong p, ulong pi);
int     Flx_is_irred(GEN f, ulong p);
int     Flx_is_totally_split(GEN f, ulong p);
long    Flx_ispower(GEN f, ulong k, ulong p, GEN *pt_r);
GEN     Flx_degfact(GEN f, ulong p);
GEN     Flx_factor(GEN f, ulong p);
GEN     Flx_factor_squarefree(GEN f, ulong p);
GEN     Flx_factor_squarefree_pre(GEN f, ulong p, ulong pi);
long    Flx_nbfact(GEN z, ulong p);
long    Flx_nbfact_pre(GEN z, ulong p, ulong pi);
long    Flx_nbfact_Frobenius(GEN T, GEN XP, ulong p);
long    Flx_nbfact_Frobenius_pre(GEN T, GEN XP, ulong p, ulong pi);
GEN     Flx_nbfact_by_degree(GEN z, long *nb, ulong p);
long    Flx_nbroots(GEN f, ulong p);
ulong   Flx_oneroot(GEN f, ulong p);
ulong   Flx_oneroot_split(GEN f, ulong p);
ulong   Flx_oneroot_pre(GEN f, ulong p, ulong pi);
ulong   Flx_oneroot_split_pre(GEN f, ulong p, ulong pi);
GEN     Flx_roots(GEN f, ulong p);
GEN     Flx_roots_pre(GEN f, ulong p, ulong pi);
GEN     Flx_rootsff(GEN P, GEN T, ulong p);
GEN     FpX_ddf(GEN f, GEN p);
long    FpX_ddf_degree(GEN T, GEN XP, GEN p);
GEN     FpX_degfact(GEN f, GEN p);
GEN     FpX_factor(GEN f, GEN p);
GEN     FpX_factor_squarefree(GEN T, GEN p);
int     FpX_is_irred(GEN f, GEN p);
int     FpX_is_totally_split(GEN f, GEN p);
long    FpX_ispower(GEN f, ulong k, GEN p, GEN *pt_r);
long    FpX_nbfact(GEN f, GEN p);
long    FpX_nbfact_Frobenius(GEN T, GEN XP, GEN p);
long    FpX_nbroots(GEN f, GEN p);
GEN     FpX_oneroot(GEN f, GEN p);
GEN     FpX_oneroot_split(GEN fact, GEN p);
GEN     FpX_roots(GEN f, GEN p);
GEN     FpX_roots_mult(GEN T, long n, GEN p);
GEN     FpX_rootsff(GEN P, GEN T, GEN p);
GEN     FpX_split_part(GEN f, GEN p);

/* FpXQX_factor.c */

GEN     F2xqX_Frobenius(GEN S, GEN T);
GEN     F2xqX_ddf(GEN S, GEN T);
GEN     F2xqX_degfact(GEN S, GEN T);
GEN     F2xqX_factor(GEN x, GEN T);
GEN     F2xqX_factor_squarefree(GEN x, GEN T);
GEN     F2xqX_roots(GEN x, GEN T);
GEN     Flx_factorff_irred(GEN P, GEN Q, ulong p);
void    Flx_ffintersect(GEN P,GEN Q,long n,ulong l,GEN *SP,GEN *SQ,GEN MA,GEN MB);
GEN     Flx_ffisom(GEN P,GEN Q,ulong l);
GEN     Flxq_ffisom_inv(GEN S,GEN Tp, ulong p);
GEN     FlxqX_Frobenius(GEN S, GEN T, ulong p);
GEN     FlxqX_Frobenius_pre(GEN S, GEN T, ulong p, ulong pi);
GEN     FlxqX_ddf(GEN S, GEN T, ulong p);
long    FlxqX_ddf_degree(GEN S, GEN XP, GEN T, ulong p);
GEN     FlxqX_degfact(GEN S, GEN T, ulong p);
GEN     FlxqX_factor(GEN x, GEN T, ulong p);
GEN     FlxqX_factor_squarefree(GEN x, GEN T, ulong p);
GEN     FlxqX_factor_squarefree_pre(GEN f, GEN T, ulong p, ulong pi);
long    FlxqX_ispower(GEN f, ulong k, GEN T, ulong p, GEN *pt_r);
long    FlxqX_is_squarefree(GEN P, GEN T, ulong p);
long    FlxqX_nbfact(GEN S, GEN T, ulong p);
long    FlxqX_nbfact_Frobenius(GEN S, GEN Xq, GEN T, ulong p);
GEN     FlxqX_nbfact_by_degree(GEN f, long *nb, GEN T, ulong p);
long    FlxqX_nbroots(GEN f, GEN T, ulong p);
GEN     FlxqX_roots(GEN S, GEN T, ulong p);
GEN     FlxqXQ_halfFrobenius(GEN a, GEN S, GEN T, ulong p);
GEN     FpX_factorff(GEN P, GEN T, GEN p);
GEN     FpX_factorff_irred(GEN P, GEN Q, GEN p);
void    FpX_ffintersect(GEN P,GEN Q,long n,GEN l,GEN *SP,GEN *SQ,GEN MA,GEN MB);
GEN     FpX_ffisom(GEN P,GEN Q,GEN l);
GEN     FpXQ_ffisom_inv(GEN S,GEN Tp, GEN p);
GEN     FpXQX_Frobenius(GEN S, GEN T, GEN p);
GEN     FpXQX_ddf(GEN S, GEN T, GEN p);
long    FpXQX_ddf_degree(GEN S, GEN XP, GEN T, GEN p);
GEN     FpXQX_degfact(GEN S, GEN T, GEN p);
GEN     FpXQX_factor(GEN x, GEN T, GEN p);
GEN     FpXQX_factor_squarefree(GEN x, GEN T, GEN p);
long    FpXQX_is_squarefree(GEN P, GEN T, GEN p);
long    FpXQX_ispower(GEN f, ulong k, GEN T, GEN p, GEN *pt);
long    FpXQX_nbfact(GEN u, GEN T, GEN p);
long    FpXQX_nbfact_Frobenius(GEN S, GEN Xq, GEN T, GEN p);
long    FpXQX_nbroots(GEN f, GEN T, GEN p);
GEN     FpXQX_roots(GEN f, GEN T, GEN p);
GEN     FpXQX_roots_mult(GEN f, long n, GEN T, GEN p);
GEN     FpXQX_split_part(GEN f, GEN T, GEN p);
GEN     FpXQXQ_halfFrobenius(GEN a, GEN S, GEN T, GEN p);
long    FqX_ispower(GEN f, ulong k, GEN T, GEN p, GEN *pt);
long    FqX_nbfact(GEN u, GEN T, GEN p);
long    FqX_nbroots(GEN f, GEN T, GEN p);
GEN     factorff(GEN f, GEN p, GEN a);
GEN     factormod0(GEN f, GEN p,long flag);
GEN     factormodDDF(GEN f, GEN D);
GEN     factormodSQF(GEN f, GEN D);
int     ff_parse_Tp(GEN Tp, GEN *T, GEN *p, long red);
GEN     polrootsff(GEN f, GEN p, GEN T);
GEN     polrootsmod(GEN f, GEN p);
GEN     rootmod0(GEN f, GEN p,long flag);

/* FpXX.c */

GEN     FpXQX_FpXQ_mul(GEN P, GEN U, GEN T, GEN p);
GEN     FpXQX_FpXQXQV_eval(GEN P, GEN V, GEN S, GEN T, GEN p);
GEN     FpXQX_FpXQXQ_eval(GEN P, GEN x, GEN S, GEN T, GEN p);
GEN     FpXQX_digits(GEN x, GEN B, GEN T, GEN p);
GEN     FpXQX_disc(GEN x, GEN T, GEN p);
GEN     FpXQX_div_by_X_x(GEN a, GEN x, GEN T, GEN p, GEN *pr);
GEN     FpXQX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *pr);
GEN     FpXQX_dotproduct(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_extgcd(GEN x, GEN y, GEN T, GEN p, GEN *ptu, GEN *ptv);
GEN     FpXQX_gcd(GEN P, GEN Q, GEN T, GEN p);
GEN     FpXQX_get_red(GEN S, GEN T, GEN p);
GEN     FpXQX_halfgcd(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_halfgcd_all(GEN x, GEN y, GEN T, GEN p, GEN *a, GEN *b);
GEN     FpXQX_invBarrett(GEN S, GEN T, GEN p);
GEN     FpXQX_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_powu(GEN x, ulong n, GEN T, GEN p);
GEN     FpXQX_red(GEN z, GEN T, GEN p);
GEN     FpXQX_rem(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQX_resultant(GEN a, GEN b, GEN T, GEN p);
GEN     FpXQX_sqr(GEN x, GEN T, GEN p);
GEN     FpXQX_to_mod(GEN z, GEN T, GEN p);
GEN     FpXQXQ_div(GEN x,GEN y,GEN S, GEN T,GEN p);
GEN     FpXQXQ_inv(GEN x, GEN S, GEN T,GEN p);
GEN     FpXQXQ_invsafe(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQXQ_matrix_pow(GEN y, long n, long m, GEN S, GEN T, GEN p);
GEN     FpXQXQ_minpoly(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p);
GEN     FpXQXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
GEN     FpXQXQ_powers(GEN x, long n, GEN S, GEN T, GEN p);
GEN     FpXQXQ_sqr(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQXQ_autpow(GEN aut, long n, GEN S, GEN T, GEN p);
GEN     FpXQXQ_autsum(GEN aut, long n, GEN S, GEN T, GEN p);
GEN     FpXQXQ_auttrace(GEN aut, long n, GEN S, GEN T, GEN p);
GEN     FpXQXT_red(GEN x, GEN T, GEN p);
GEN     FpXQXV_FpXQX_fromdigits(GEN x, GEN B, GEN T, GEN p);
GEN     FpXQXV_prod(GEN V, GEN Tp, GEN p);
GEN     FpXQXV_red(GEN x, GEN T, GEN p);
GEN     FpXQXn_div(GEN g, GEN f, long n, GEN T, GEN p);
GEN     FpXQXn_exp(GEN x, long n, GEN T, GEN p);
GEN     FpXQXn_expint(GEN x, long n, GEN T, GEN p);
GEN     FpXQXn_inv(GEN x, long n, GEN T, GEN p);
GEN     FpXQXn_mul(GEN x, GEN y, long n, GEN T, GEN p);
GEN     FpXQXn_sqr(GEN x, long n, GEN T, GEN p);
GEN     FpXX_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpXX_FpX_mul(GEN x, GEN y, GEN p);
GEN     FpXX_add(GEN x, GEN y, GEN p);
GEN     FpXX_deriv(GEN P, GEN p);
GEN     FpXX_halve(GEN P, GEN p);
GEN     FpXX_integ(GEN P, GEN p);
GEN     FpXX_mulu(GEN P, ulong u, GEN p);
GEN     FpXX_neg(GEN x, GEN p);
GEN     FpXX_red(GEN z, GEN p);
GEN     FpXX_sub(GEN x, GEN y, GEN p);
GEN     FpXY_FpXQ_evalx(GEN P, GEN x, GEN T, GEN p);
GEN     FpXY_FpXQV_evalx(GEN P, GEN x, GEN T, GEN p);
GEN     FpXY_eval(GEN Q, GEN y, GEN x, GEN p);
GEN     FpXY_evalx(GEN Q, GEN x, GEN p);
GEN     FpXY_evaly(GEN Q, GEN y, GEN p, long vy);
GEN     FpXYQQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
GEN     FqXC_to_mod(GEN z, GEN T, GEN p);
GEN     FqXM_to_mod(GEN z, GEN T, GEN p);
GEN     Kronecker_to_FpXQX(GEN z, GEN pol, GEN p);
const struct bb_algebra * get_FpXQX_algebra(void **E, GEN T, GEN p, long v);
const struct bb_algebra * get_FpXQXQ_algebra(void **E, GEN S, GEN T, GEN p);
GEN     random_FpXQX(long d1, long v, GEN T, GEN p);

/* FpV.c */

GEN     Flc_Flv_mul(GEN x, GEN y, ulong p);
GEN     Flc_to_mod(GEN z, ulong p);
GEN     Flm_Fl_add(GEN x, ulong y, ulong p);
GEN     Flm_Fl_mul(GEN y, ulong x, ulong p);
void    Flm_Fl_mul_inplace(GEN y, ulong x, ulong p);
GEN     Flm_Fl_mul_pre(GEN y, ulong x, ulong p, ulong pi);
GEN     Flm_Fl_sub(GEN x, ulong y, ulong p);
GEN     Flm_Flc_mul(GEN x, GEN y, ulong p);
GEN     Flm_Flc_mul_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flm_Flc_mul_pre_Flx(GEN x, GEN y, ulong p, ulong pi, long sv);
GEN     Flm_add(GEN x, GEN y, ulong p);
GEN     Flm_center(GEN z, ulong p, ulong ps2);
GEN     Flm_mul(GEN x, GEN y, ulong p);
GEN     Flm_mul_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flm_neg(GEN y, ulong p);
GEN     Flm_powers(GEN x, ulong n, ulong p);
GEN     Flm_powu(GEN x, ulong n, ulong p);
GEN     Flm_sqr(GEN x, ulong p);
GEN     Flm_sub(GEN x, GEN y, ulong p);
GEN     Flm_to_mod(GEN z, ulong p);
GEN     Flm_transpose(GEN x);
GEN     Flv_Fl_div(GEN x, ulong y, ulong p);
void    Flv_Fl_div_inplace(GEN x, ulong y, ulong p);
GEN     Flv_Fl_mul(GEN x, ulong y, ulong p);
void    Flv_Fl_mul_inplace(GEN x, ulong y, ulong p);
void    Flv_Fl_mul_part_inplace(GEN x, ulong y, ulong p, long l);
GEN     Flv_add(GEN x, GEN y, ulong p);
void    Flv_add_inplace(GEN x, GEN y, ulong p);
GEN     Flv_center(GEN z, ulong p, ulong ps2);
ulong   Flv_dotproduct(GEN x, GEN y, ulong p);
ulong   Flv_dotproduct_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Flv_neg(GEN v, ulong p);
void    Flv_neg_inplace(GEN v, ulong p);
GEN     Flv_sub(GEN x, GEN y, ulong p);
void    Flv_sub_inplace(GEN x, GEN y, ulong p);
ulong   Flv_sum(GEN x, ulong p);
ulong   Flx_dotproduct(GEN x, GEN y, ulong p);
ulong   Flx_dotproduct_pre(GEN x, GEN y, ulong p, ulong pi);
GEN     Fp_to_mod(GEN z, GEN p);
GEN     FpC_FpV_mul(GEN x, GEN y, GEN p);
GEN     FpC_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpC_center(GEN z, GEN p, GEN pov2);
void    FpC_center_inplace(GEN z, GEN p, GEN pov2);
GEN     FpC_red(GEN z, GEN p);
GEN     FpC_to_mod(GEN z, GEN p);
GEN     FpM_add(GEN x, GEN y, GEN p);
GEN     FpM_Fp_mul(GEN X, GEN c, GEN p);
GEN     FpM_FpC_mul(GEN x, GEN y, GEN p);
GEN     FpM_FpC_mul_FpX(GEN x, GEN y, GEN p, long v);
GEN     FpM_center(GEN z, GEN p, GEN pov2);
void    FpM_center_inplace(GEN z, GEN p, GEN pov2);
GEN     FpM_mul(GEN x, GEN y, GEN p);
GEN     FpM_powu(GEN x, ulong n, GEN p);
GEN     FpM_red(GEN z, GEN p);
GEN     FpM_sub(GEN x, GEN y, GEN p);
GEN     FpM_to_mod(GEN z, GEN p);
GEN     FpMs_FpC_mul(GEN M, GEN B, GEN p);
GEN     FpMs_FpCs_solve(GEN M, GEN B, long nbrow, GEN p);
GEN     FpMs_FpCs_solve_safe(GEN M, GEN A, long nbrow, GEN p);
GEN     FpMs_leftkernel_elt(GEN M, long nbrow, GEN p);
GEN     FpC_add(GEN x, GEN y, GEN p);
GEN     FpC_sub(GEN x, GEN y, GEN p);
GEN     FpV_FpMs_mul(GEN B, GEN M, GEN p);
GEN     FpV_add(GEN x, GEN y, GEN p);
GEN     FpV_sub(GEN x, GEN y, GEN p);
GEN     FpV_dotproduct(GEN x, GEN y, GEN p);
GEN     FpV_dotsquare(GEN x, GEN p);
GEN     FpV_red(GEN z, GEN p);
GEN     FpV_to_mod(GEN z, GEN p);
GEN     FpVV_to_mod(GEN z, GEN p);
GEN     FpX_to_mod(GEN z, GEN p);
GEN     FpXC_to_mod(GEN x, GEN p);
GEN     FpXM_to_mod(GEN x, GEN p);
GEN     ZabM_ker(GEN M, GEN P, long n);
GEN     ZabM_indexrank(GEN M, GEN P, long n);
GEN     ZabM_inv(GEN M, GEN P, long n, GEN *pden);
GEN     ZabM_inv_ratlift(GEN M, GEN P, long n, GEN *pden);
GEN     ZabM_pseudoinv(GEN M, GEN P, long n, GEN *pv, GEN *den);
GEN     ZV_zMs_mul(GEN B, GEN M);
GEN     ZpMs_ZpCs_solve(GEN M, GEN B, long nbrow, GEN p, long e);
GEN     gen_FpM_Wiedemann(void *E, GEN (*f)(void*, GEN), GEN B, GEN p);
GEN     gen_ZpM_Dixon_Wiedemann(void *E, GEN (*f)(void*, GEN), GEN B, GEN p, long e);
GEN     gen_matid(long n, void *E, const struct bb_field *S);
GEN     matid_Flm(long n);
GEN     matid_F2xqM(long n, GEN T);
GEN     matid_FlxqM(long n, GEN T, ulong p);
GEN     random_Flv(long n, ulong p);
GEN     random_FpC(long d, GEN p);
GEN     random_FpV(long d, GEN p);
GEN     scalar_Flm(long s, long n);
GEN     zCs_to_ZC(GEN C, long nbrow);
GEN     zMs_ZC_mul(GEN M, GEN B);
GEN     zMs_compress(GEN M, long nbrow);
GEN     zMs_to_ZM(GEN M, long nbrow);
GEN     ZMV_to_FlmV(GEN z, ulong m);

/* Zp.c */

GEN     Flx_Teichmuller(GEN P, ulong p, long n);
GEN     Z2_sqrt(GEN x, long e);
GEN     Zp_div(GEN a, GEN b, GEN p, long e);
GEN     Zp_exp(GEN arg, GEN p, ulong e);
GEN     Zp_inv(GEN a, GEN p, long e);
GEN     Zp_invlift(GEN b, GEN a, GEN p, long e);
GEN     Zp_log(GEN arg, GEN p, ulong e);
GEN     Zp_sqrt(GEN x, GEN p, long e);
GEN     Zp_sqrtlift(GEN b, GEN a, GEN p, long e);
GEN     Zp_sqrtnlift(GEN b, GEN n, GEN a, GEN p, long e);
GEN     ZpM_ZpC_gauss(GEN M, GEN C, GEN q, GEN p, long n);
GEN     ZpM_invlift(GEN M, GEN C, GEN p, long n);
GEN     ZpX_Frobenius(GEN T, GEN p, long e);
GEN     ZpX_ZpXQ_liftroot(GEN P, GEN S, GEN T, GEN p, long e);
GEN     ZpX_ZpXQ_liftroot_ea(GEN P, GEN S, GEN T, GEN p, long n, void *E,
                     GEN early(void *E, GEN x, GEN q));
GEN     ZpX_liftfact(GEN pol, GEN Q, GEN pe, GEN p, long e);
GEN     ZpX_liftroot(GEN f, GEN a, GEN p, long e);
GEN     ZpX_liftroots(GEN f, GEN S, GEN p, long e);
GEN     ZpX_roots(GEN f, GEN p, long e);
GEN     ZpXQ_div(GEN a, GEN b, GEN T, GEN q, GEN p, long e);
GEN     ZpXQ_inv(GEN a, GEN T, GEN p, long e);
GEN     ZpXQ_invlift(GEN b, GEN a, GEN T, GEN p, long e);
GEN     ZpXQ_log(GEN a, GEN T, GEN p, long N);
GEN     ZpXQ_sqrt(GEN a, GEN T, GEN p, long e);
GEN     ZpXQ_sqrtnlift(GEN b, GEN n, GEN a, GEN T, GEN p, long e);
GEN     ZpXQM_prodFrobenius(GEN M, GEN T, GEN p, long e);
GEN     ZpXQX_digits(GEN x, GEN B, GEN T, GEN q, GEN p, long e);
GEN     ZpXQX_divrem(GEN x, GEN S, GEN T, GEN q, GEN p, long e, GEN *pr);
GEN     ZpXQX_liftfact(GEN pol, GEN Q, GEN T, GEN pe, GEN p, long e);
GEN     ZpXQX_liftroot(GEN f, GEN a, GEN T, GEN p, long e);
GEN     ZpXQX_liftroot_vald(GEN f, GEN a, long v, GEN T, GEN p, long e);
GEN     ZpXQX_liftroots(GEN f, GEN S, GEN T, GEN p, long e);
GEN     ZpXQX_roots(GEN F, GEN T, GEN p, long e);
GEN     ZpXQX_ZpXQXQ_liftroot(GEN P, GEN S, GEN Q, GEN T, GEN p, long e);
GEN     Zq_sqrtnlift(GEN a, GEN n, GEN x, GEN T, GEN p, long e);
GEN     ZqX_ZqXQ_liftroot(GEN f, GEN a, GEN S, GEN T, GEN p, long e);
GEN     ZqX_liftfact(GEN pol, GEN Q, GEN T, GEN pe, GEN p, long e);
GEN     ZqX_liftroot(GEN f, GEN a, GEN T, GEN p, long e);
GEN     ZqX_roots(GEN F, GEN T, GEN p, long e);
GEN     gen_ZpM_Dixon(GEN F, GEN V, GEN q, GEN p, long N, void *E,
                             GEN lin(void *E, GEN F, GEN d, GEN q),
                             GEN invl(void *E, GEN d));
GEN     gen_ZpM_Newton(GEN x, GEN p, long n, void *E,
                              GEN eval(void *E, GEN f, GEN q),
                              GEN invd(void *E, GEN V, GEN v, GEN q, long M));
GEN     gen_ZpX_Dixon(GEN F, GEN V, GEN q, GEN p, long N, void *E,
                             GEN lin(void *E, GEN F, GEN d, GEN q),
                             GEN invl(void *E, GEN d));
GEN     gen_ZpX_Newton(GEN x, GEN p, long n, void *E,
                              GEN eval(void *E, GEN f, GEN q),
                              GEN invd(void *E, GEN V, GEN v, GEN q, long M));
GEN     polteichmuller(GEN P, ulong p, long n);
GEN     polhensellift(GEN pol, GEN fct, GEN p, long exp);
ulong   quadratic_prec_mask(long n);

/* QX_factor.c */

GEN     QX_factor(GEN x);
GEN     QXk_gcd(GEN A, GEN B);
int     Rg_is_QXk(GEN z);
GEN     ZX_factor(GEN x);
GEN     ZX_gcd(GEN A, GEN B);
GEN     ZX_gcd_all(GEN A, GEN B, GEN *Anew);
long    ZX_is_irred(GEN x);
GEN     ZX_squff(GEN f, GEN *ex);
GEN     ZXk_divexact(GEN A, GEN B);
GEN     ZXk_divides(GEN A, GEN B);
GEN     ZXk_gcd(GEN A, GEN B);
GEN     polcyclofactors(GEN f);
long    poliscyclo(GEN f);
long    poliscycloprod(GEN f);


/* RgV.c */

GEN     Rg_RgC_sub(GEN a, GEN x);
GEN     RgC_Rg_add(GEN x, GEN y);
GEN     RgC_Rg_div(GEN x, GEN y);
GEN     RgC_Rg_mul(GEN x, GEN y);
GEN     RgC_Rg_sub(GEN x, GEN y);
GEN     RgC_RgM_mul(GEN x, GEN y);
GEN     RgC_RgV_mul(GEN x, GEN y);
GEN     RgC_add(GEN x, GEN y);
long    RgC_is_ei(GEN x);
GEN     RgC_neg(GEN x);
GEN     RgC_sub(GEN x, GEN y);
GEN     RgM_Rg_add(GEN x, GEN y);
GEN     RgM_Rg_add_shallow(GEN x, GEN y);
GEN     RgM_Rg_div(GEN x, GEN y);
GEN     RgM_Rg_mul(GEN x, GEN y);
GEN     RgM_Rg_sub(GEN x, GEN y);
GEN     RgM_Rg_sub_shallow(GEN x, GEN y);
GEN     RgM_RgC_mul(GEN x, GEN y);
GEN     RgM_RgV_mul(GEN x, GEN y);
GEN     RgM_ZM_mul(GEN x, GEN y);
GEN     RgM_add(GEN x, GEN y);
GEN     RgM_det_triangular(GEN x);
int     RgM_is_QM(GEN x);
int     RgM_is_ZM(GEN x);
int     RgM_isdiagonal(GEN x);
int     RgM_isidentity(GEN x);
int     RgM_isscalar(GEN x, GEN s);
GEN     RgM_mul(GEN x, GEN y);
GEN     RgM_multosym(GEN x, GEN y);
GEN     RgM_neg(GEN x);
GEN     RgM_powers(GEN x, long l);
GEN     RgM_sqr(GEN x);
GEN     RgM_sub(GEN x, GEN y);
GEN     RgM_sumcol(GEN A);
GEN     RgM_transmul(GEN x, GEN y);
GEN     RgM_transmultosym(GEN x, GEN y);
GEN     RgMrow_zc_mul(GEN x, GEN y, long i);
GEN     RgM_zc_mul(GEN x, GEN y);
GEN     RgM_zm_mul(GEN x, GEN y);
GEN     RgMrow_RgC_mul(GEN x, GEN y, long i);
GEN     RgV_RgM_mul(GEN x, GEN y);
GEN     RgV_RgC_mul(GEN x, GEN y);
GEN     RgV_Rg_mul(GEN x, GEN y);
GEN     RgV_add(GEN x, GEN y);
GEN     RgV_dotproduct(GEN x, GEN y);
GEN     RgV_dotsquare(GEN x);
int     RgV_is_ZMV(GEN V);
GEN     RgV_kill0(GEN v);
GEN     RgV_neg(GEN x);
GEN     RgV_prod(GEN v);
GEN     RgV_sub(GEN x, GEN y);
GEN     RgV_sum(GEN v);
GEN     RgV_sumpart(GEN v, long n);
GEN     RgV_sumpart2(GEN v, long m, long n);
GEN     RgV_zc_mul(GEN x, GEN y);
GEN     RgV_zm_mul(GEN x, GEN y);
GEN     RgX_RgM_eval(GEN x, GEN y);
GEN     RgX_RgMV_eval(GEN x, GEN y);
int     isdiagonal(GEN x);
GEN     matid(long n);
GEN     scalarcol(GEN x, long n);
GEN     scalarcol_shallow(GEN x, long n);
GEN     scalarmat(GEN x, long n);
GEN     scalarmat_shallow(GEN x, long n);
GEN     scalarmat_s(long x, long n);

/* RgX.c */

GEN     Kronecker_to_mod(GEN z, GEN pol);
GEN     QX_ZXQV_eval(GEN P, GEN V, GEN dV);
GEN     QXQ_charpoly(GEN A, GEN T, long v);
GEN     QXQ_powers(GEN a, long n, GEN T);
GEN     QXQ_to_mod_shallow(GEN x, GEN T);
GEN     QXQC_to_mod_shallow(GEN V, GEN T);
GEN     QXQM_to_mod_shallow(GEN V, GEN T);
GEN     QXQV_to_mod(GEN V, GEN T);
GEN     QXQX_homogenous_evalpow(GEN P, GEN A, GEN B, GEN T);
GEN     QXQX_to_mod_shallow(GEN z, GEN T);
GEN     QXQXV_to_mod(GEN V, GEN T);
GEN     QXV_QXQ_eval(GEN v, GEN a, GEN T);
GEN     QXY_QXQ_evalx(GEN v, GEN a, GEN T);
GEN     Rg_RgX_sub(GEN x, GEN y);
GEN     Rg_get_0(GEN x);
GEN     Rg_get_1(GEN x);
GEN     Rg_to_RgC(GEN x, long N);
GEN     RgM_to_RgXV(GEN x, long v);
GEN     RgM_to_RgXV_reverse(GEN x, long v);
GEN     RgM_to_RgXX(GEN x, long v,long w);
GEN     RgV_to_RgX(GEN x, long v);
GEN     RgV_to_RgM(GEN v, long n);
GEN     RgV_to_RgX_reverse(GEN x, long v);
GEN     RgX_RgXQ_eval(GEN f, GEN x, GEN T);
GEN     RgX_RgXQV_eval(GEN P, GEN V, GEN T);
GEN     RgX_RgXn_eval(GEN Q, GEN x, long n);
GEN     RgX_RgXnV_eval(GEN Q, GEN x, long n);
GEN     RgX_Rg_add(GEN y, GEN x);
GEN     RgX_Rg_add_shallow(GEN y, GEN x);
GEN     RgX_Rg_div(GEN y, GEN x);
GEN     RgX_Rg_divexact(GEN x, GEN y);
GEN     RgX_Rg_eval_bk(GEN Q, GEN x);
GEN     RgX_Rg_mul(GEN y, GEN x);
GEN     RgX_Rg_sub(GEN y, GEN x);
GEN     RgX_RgV_eval(GEN Q, GEN x);
GEN     RgX_add(GEN x, GEN y);
GEN     RgX_addmulXn_shallow(GEN x, GEN y, long d);
GEN     RgX_addmulXn(GEN x, GEN y, long d);
GEN     RgX_addspec(GEN x, GEN y, long nx, long ny);
GEN     RgX_addspec_shallow(GEN x, GEN y, long nx, long ny);
GEN     RgX_affine(GEN P, GEN a, GEN b);
GEN     RgX_blocks(GEN P, long n, long m);
GEN     RgX_deflate(GEN x0, long d);
GEN     RgX_deriv(GEN x);
GEN     RgX_digits(GEN A, GEN B);
GEN     RgX_div_by_X_x(GEN a, GEN x, GEN *r);
GEN     RgX_divrem(GEN x,GEN y,GEN *r);
GEN     RgX_divs(GEN y, long x);
long    RgX_equal(GEN x, GEN y);
void    RgX_even_odd(GEN p, GEN *pe, GEN *po);
GEN     RgX_homogenize(GEN P, long v);
GEN     RgX_homogenize_deg(GEN P, long d, long v);
GEN     RgX_homogenous_evalpow(GEN P, GEN A, GEN B);
GEN     RgX_inflate(GEN x0, long d);
GEN     RgX_mul(GEN x,GEN y);
GEN     RgX_mul_i(GEN x,GEN y);
GEN     RgX_mul_normalized(GEN A, long a, GEN B, long b);
GEN     RgX_mul2n(GEN y, long n);
GEN     RgX_mulXn(GEN x, long d);
GEN     RgX_mulhigh_i(GEN f, GEN g, long n);
GEN     RgX_muls(GEN y, long x);
GEN     RgX_mulspec(GEN a, GEN b, long na, long nb);
GEN     RgX_neg(GEN x);
GEN     RgX_normalize(GEN x);
GEN     RgX_pseudodivrem(GEN x, GEN y, GEN *ptr);
GEN     RgX_pseudorem(GEN x, GEN y);
GEN     RgX_recip(GEN x);
GEN     RgX_recip_i(GEN x);
GEN     RgX_recip_shallow(GEN x);
GEN     RgX_rem(GEN x, GEN y);
GEN     RgX_renormalize_lg(GEN x, long lx);
GEN     RgX_rescale(GEN P, GEN h);
GEN     RgX_rotate_shallow(GEN P, long k, long p);
GEN     RgX_shift(GEN a, long n);
GEN     RgX_shift_shallow(GEN x, long n);
GEN     RgX_splitting(GEN p, long k);
GEN     RgX_sqr(GEN x);
GEN     RgX_sqr_i(GEN x);
GEN     RgX_sqrhigh_i(GEN f, long n);
GEN     RgX_sqrspec(GEN a, long na);
GEN     RgX_sub(GEN x, GEN y);
GEN     RgX_to_RgC(GEN x, long N);
GEN     RgX_Rg_translate(GEN P, GEN c);
GEN     RgX_unscale(GEN P, GEN h);
GEN     RgXQ_matrix_pow(GEN y, long n, long m, GEN P);
GEN     RgXQ_norm(GEN x, GEN T);
GEN     RgXQ_pow(GEN x, GEN n, GEN T);
GEN     RgXQ_powers(GEN x, long l, GEN T);
GEN     RgXQ_powu(GEN x, ulong n, GEN T);
GEN     RgXQ_trace(GEN x, GEN T);
GEN     RgXQC_red(GEN P, GEN T);
GEN     RgXQM_mul(GEN P, GEN Q, GEN T);
GEN     RgXQM_red(GEN P, GEN T);
GEN     RgXQV_RgXQ_mul(GEN v, GEN x, GEN T);
GEN     RgXQV_factorback(GEN x, GEN n, GEN T);
GEN     RgXQV_red(GEN P, GEN T);
GEN     RgXQX_RgXQ_mul(GEN x, GEN y, GEN T);
GEN     RgXQX_divrem(GEN x,GEN y,GEN T,GEN *r);
GEN     RgXQX_mul(GEN x,GEN y,GEN T);
GEN     RgXQX_powers(GEN P, long n, GEN T);
GEN     RgXQX_pseudodivrem(GEN x, GEN y, GEN T, GEN *ptr);
GEN     RgXQX_pseudorem(GEN x, GEN y, GEN T);
GEN     RgXQX_red(GEN P, GEN T);
GEN     RgXQX_sqr(GEN x, GEN T);
GEN     RgXQX_RgXQ_translate(GEN P, GEN c, GEN T);
GEN     RgXV_RgV_eval(GEN Q, GEN x);
GEN     RgXV_prod(GEN V);
GEN     RgXV_rescale(GEN v, GEN h);
GEN     RgXV_to_RgM(GEN v, long n);
GEN     RgXV_unscale(GEN v, GEN h);
GEN     RgXX_to_RgM(GEN v, long n);
long    RgXY_degreex(GEN bpol);
GEN     RgXY_derivx(GEN x);
GEN     RgXY_swap(GEN x, long n, long w);
GEN     RgXY_swapspec(GEN x, long n, long w, long nx);
GEN     RgXn_div(GEN g, GEN f, long e);
GEN     RgXn_div_i(GEN g, GEN f, long e);
GEN     RgXn_eval(GEN Q, GEN x, long n);
GEN     RgXn_exp(GEN f, long e);
GEN     RgXn_expint(GEN f, long e);
GEN     RgXn_inv(GEN f, long e);
GEN     RgXn_inv_i(GEN f, long e);
GEN     RgXn_mul(GEN f, GEN g, long n);
GEN     RgXn_powers(GEN f, long m, long n);
GEN     RgXn_recip_shallow(GEN P, long n);
GEN     RgXn_red_shallow(GEN a, long n);
GEN     RgXn_reverse(GEN f, long e);
GEN     RgXn_sqr(GEN f, long n);
GEN     RgXn_sqrt(GEN f, long n);
GEN     RgXnV_red_shallow(GEN P, long n);
GEN     RgXn_powu(GEN x, ulong m, long n);
GEN     RgXn_powu_i(GEN x, ulong m, long n);
GEN     ZX_Z_translate(GEN P, GEN c);
GEN     ZX_unscale2n(GEN P, long n);
GEN     ZX_unscale(GEN P, GEN h);
GEN     ZX_unscale_div(GEN P, GEN h);
GEN     ZX_unscale_divpow(GEN P, GEN h, long k);
GEN     ZX_z_unscale(GEN P, long h);
GEN     ZXQ_powers(GEN x, long l, GEN T);
GEN     ZXQ_powu(GEN x, ulong n, GEN T);
int     ZXQX_dvd(GEN x, GEN y, GEN T);
long    brent_kung_optpow(long d, long n, long m);
GEN     gen_bkeval(GEN Q, long d, GEN x, int use_sqr, void *E,
          const struct bb_algebra *ff, GEN cmul(void *E, GEN P, long a, GEN x));
GEN     gen_bkeval_powers(GEN P, long d, GEN V, void *E,
          const struct bb_algebra *ff, GEN cmul(void *E, GEN P, long a, GEN x));
const struct bb_algebra * get_Rg_algebra(void);
long    rfrac_deflate_order(GEN F);
GEN     rfrac_deflate_max(GEN F, long *m);
GEN     rfrac_deflate(GEN F, long m);

/* ZG.c */
void    ZGC_G_mul_inplace(GEN v, GEN x);
GEN     ZGCs_add(GEN x, GEN y);
GEN     G_ZGC_mul(GEN x, GEN v);
GEN     G_ZG_mul(GEN x, GEN y);
GEN     ZGC_G_mul(GEN v, GEN x);
GEN     ZGC_Z_mul(GEN v, GEN x);
GEN     ZG_G_mul(GEN x, GEN y);
GEN     ZG_Z_mul(GEN x, GEN c);
GEN     ZG_add(GEN x, GEN y);
GEN     ZG_mul(GEN x, GEN y);
GEN     ZG_neg(GEN x);
GEN     ZG_normalize(GEN x);
GEN     ZG_sub(GEN x, GEN y);

/* ZV.c */

void    Flc_lincomb1_inplace(GEN X, GEN Y, ulong v, ulong q);
GEN     vecsmall_prod(GEN v);
GEN     QM_QC_mul(GEN x, GEN y);
GEN     QM_det(GEN x);
GEN     QM_ker(GEN M);
GEN     QM_mul(GEN x, GEN y);
GEN     QM_sqr(GEN x);
void    RgM_check_ZM(GEN A, const char *s);
void    RgV_check_ZV(GEN A, const char *s);
GEN     Z_ZC_sub(GEN a, GEN x);
GEN     ZV_zc_mul(GEN x, GEN y);
GEN     ZC_Q_mul(GEN A, GEN z);
GEN     ZC_Z_add(GEN x, GEN y);
GEN     ZC_Z_div(GEN x, GEN c);
GEN     ZC_Z_divexact(GEN X, GEN c);
GEN     ZC_Z_mul(GEN X, GEN c);
GEN     ZC_Z_sub(GEN x, GEN y);
GEN     ZC_ZV_mul(GEN x, GEN y);
GEN     ZC_divexactu(GEN x, ulong c);
GEN     ZC_add(GEN x, GEN y);
GEN     ZC_copy(GEN x);
GEN     ZC_hnfdivrem(GEN x, GEN y, GEN *Q);
long    ZC_is_ei(GEN x);
GEN     ZC_lincomb(GEN u, GEN v, GEN X, GEN Y);
void    ZC_lincomb1_inplace(GEN X, GEN Y, GEN v);
void    ZC_lincomb1_inplace_i(GEN X, GEN Y, GEN v, long n);
GEN     ZC_modhnf(GEN x, GEN y, GEN *Q);
GEN     ZC_neg(GEN M);
GEN     ZC_reducemodlll(GEN x,GEN y);
GEN     ZC_reducemodmatrix(GEN v, GEN y);
GEN     ZC_sub(GEN x, GEN y);
GEN     ZC_z_mul(GEN X, long c);
GEN     ZM_Q_mul(GEN A, GEN z);
GEN     ZM_ZC_mul(GEN x, GEN y);
GEN     ZM_Z_div(GEN X, GEN c);
GEN     ZM_Z_divexact(GEN X, GEN c);
GEN     ZM_Z_mul(GEN X, GEN c);
GEN     ZM_add(GEN x, GEN y);
GEN     ZM_copy(GEN x);
GEN     ZM_det_triangular(GEN mat);
GEN     ZM_diag_mul(GEN m, GEN d);
GEN     ZM_divexactu(GEN x, ulong c);
int     ZM_equal(GEN A, GEN B);
int     ZM_equal0(GEN A);
GEN     ZM_hnfdivrem(GEN x, GEN y, GEN *Q);
int     ZM_ishnf(GEN x);
int     ZM_isdiagonal(GEN x);
int     ZM_isidentity(GEN x);
int     ZM_isscalar(GEN x, GEN s);
long    ZM_max_expi(GEN x);
long    ZM_max_lg(GEN x);
GEN     ZM_modhnf(GEN x, GEN y, GEN *Q);
GEN     ZM_mul(GEN x, GEN y);
GEN     ZM_mul_diag(GEN m, GEN d);
GEN     ZM_multosym(GEN x, GEN y);
GEN     ZM_neg(GEN x);
GEN     ZM_nm_mul(GEN x, GEN y);
GEN     ZM_pow(GEN x, GEN n);
GEN     ZM_powu(GEN x, ulong n);
GEN     ZM_reducemodlll(GEN x,GEN y);
GEN     ZM_reducemodmatrix(GEN v, GEN y);
GEN     ZM_sqr(GEN x);
GEN     ZM_sub(GEN x, GEN y);
GEN     ZM_supnorm(GEN x);
GEN     ZM_to_Flm(GEN x, ulong p);
GEN     ZM_to_zm(GEN z);
GEN     ZM_transmul(GEN x, GEN y);
GEN     ZM_transmultosym(GEN x, GEN y);
GEN     ZMV_to_zmV(GEN z);
void    ZM_togglesign(GEN M);
GEN     ZM_zc_mul(GEN x, GEN y);
GEN     ZM_zm_mul(GEN x, GEN y);
GEN     ZMrow_ZC_mul(GEN x, GEN y, long i);
int     ZMrow_equal0(GEN V, long i);
GEN     ZV_ZM_mul(GEN x, GEN y);
int     ZV_abscmp(GEN x, GEN y);
int     ZV_cmp(GEN x, GEN y);
GEN     ZV_content(GEN x);
GEN     ZV_dotproduct(GEN x,GEN y);
GEN     ZV_dotsquare(GEN x);
int     ZV_equal(GEN V, GEN W);
int     ZV_equal0(GEN V);
long    ZV_max_expi(GEN x);
long    ZV_max_lg(GEN x);
void    ZV_neg_inplace(GEN M);
GEN     ZV_prod(GEN v);
GEN     ZV_sum(GEN v);
GEN     ZV_to_Flv(GEN x, ulong p);
GEN     ZV_to_nv(GEN z);
void    ZV_togglesign(GEN M);
GEN     ZVV_to_FlvV(GEN x, ulong p);
GEN     gram_matrix(GEN M);
GEN     matmodhnf(GEN x, GEN y, GEN *Q);
GEN     nm_Z_mul(GEN X, GEN c);
GEN     zm_mul(GEN x, GEN y);
GEN     zm_to_Flm(GEN z, ulong p);
GEN     zm_to_ZM(GEN z);
GEN     zm_zc_mul(GEN x, GEN y);
GEN     zmV_to_ZMV(GEN z);
GEN     zv_abs(GEN x);
int     zv_canon_inplace(GEN x);
long    zv_content(GEN x);
long    zv_dotproduct(GEN x, GEN y);
int     zv_equal(GEN V, GEN W);
int     zv_equal0(GEN V);
GEN     zv_neg(GEN x);
GEN     zv_neg_inplace(GEN M);
long    zv_prod(GEN v);
GEN     zv_prod_Z(GEN v);
long    zv_sum(GEN v);
long    zv_sumpart(GEN v, long n);
GEN     zv_to_Flv(GEN z, ulong p);
GEN     zv_z_mul(GEN v, long n);
GEN     zv_ZM_mul(GEN x, GEN y);
int     zvV_equal(GEN V, GEN W);

/* ZX.c */

GEN     Kronecker_to_ZXQX(GEN z, GEN T);
GEN     Kronecker_to_ZXX(GEN z, long N, long v);
GEN     QX_ZX_rem(GEN x, GEN y);
GEN     QX_mul(GEN x, GEN y);
GEN     QX_sqr(GEN x);
GEN     QXQM_mul(GEN x, GEN y, GEN T);
GEN     QXQM_sqr(GEN x, GEN T);
GEN     QXQX_QXQ_mul(GEN P, GEN U, GEN T);
GEN     QXQX_mul(GEN x, GEN y, GEN T);
GEN     QXQX_powers(GEN P, long n, GEN T);
GEN     QXQX_sqr(GEN x, GEN T);
void    RgX_check_QX(GEN x, const char *s);
void    RgX_check_ZX(GEN x, const char *s);
void    RgX_check_ZXX(GEN x, const char *s);
GEN     Z_ZX_sub(GEN x, GEN y);
GEN     ZX_Z_add(GEN y,GEN x);
GEN     ZX_Z_add_shallow(GEN y, GEN x);
GEN     ZX_Z_divexact(GEN y,GEN x);
GEN     ZX_Z_eval(GEN x, GEN y);
GEN     ZX_Z_mul(GEN y,GEN x);
GEN     ZX_Z_sub(GEN y, GEN x);
GEN     ZX_add(GEN x, GEN y);
GEN     ZX_affine(GEN P, GEN a, GEN b);
GEN     ZX_copy(GEN x);
GEN     ZX_deriv(GEN x);
GEN     ZX_digits(GEN x, GEN T);
GEN     ZXV_ZX_fromdigits(GEN x, GEN T);
GEN     ZX_div_by_X_1(GEN a, GEN *r);
GEN     ZX_divuexact(GEN y, ulong x);
int     ZX_equal(GEN V, GEN W);
GEN     ZX_eval1(GEN x);
long    ZX_max_lg(GEN x);
GEN     ZX_mod_Xnm1(GEN T, ulong n);
GEN     ZX_mul(GEN x, GEN y);
GEN     ZX_mulspec(GEN a, GEN b, long na, long nb);
GEN     ZX_mulu(GEN y, ulong x);
GEN     ZX_neg(GEN x);
GEN     ZX_rem(GEN x, GEN y);
GEN     ZX_remi2n(GEN y, long n);
GEN     ZX_rescale2n(GEN P, long n);
GEN     ZX_rescale(GEN P, GEN h);
GEN     ZX_rescale_lt(GEN P);
GEN     ZX_shifti(GEN x, long n);
GEN     ZX_sqr(GEN x);
GEN     ZX_sqrspec(GEN a, long na);
GEN     ZX_sub(GEN x, GEN y);
long    ZX_val(GEN x);
long    ZX_valrem(GEN x, GEN *Z);
GEN     ZXQM_mul(GEN x, GEN y, GEN T);
GEN     ZXQM_sqr(GEN x, GEN T);
GEN     ZXQX_ZXQ_mul(GEN P, GEN U, GEN T);
GEN     ZXQX_sqr(GEN x, GEN T);
GEN     ZXQX_mul(GEN x, GEN y, GEN T);
GEN     ZXT_remi2n(GEN z, long n);
GEN     ZXV_Z_mul(GEN y, GEN x);
GEN     ZXV_dotproduct(GEN V, GEN W);
int     ZXV_equal(GEN V, GEN W);
GEN     ZXV_remi2n(GEN x, long n);
GEN     ZXX_Z_divexact(GEN y, GEN x);
GEN     ZXX_Z_mul(GEN y, GEN x);
GEN     ZXX_Z_add_shallow(GEN x, GEN y);
GEN     ZXX_evalx0(GEN y);
long    ZXX_max_lg(GEN x);
GEN     ZXX_mul_Kronecker(GEN x, GEN y, long n);
GEN     ZXX_renormalize(GEN x, long lx);
GEN     ZXX_sqr_Kronecker(GEN x, long n);
GEN     RgXX_to_Kronecker(GEN P, long n);
GEN     RgXX_to_Kronecker_spec(GEN P, long lP, long n);
GEN     ZXn_mul(GEN x, GEN y, long n);
GEN     ZXn_sqr(GEN x, long n);
GEN     scalar_ZX(GEN x, long v);
GEN     scalar_ZX_shallow(GEN x, long v);
GEN     zx_to_ZX(GEN z);
GEN     zx_z_divexact(GEN y, long x);

/* algebras.c */

long    alg_get_absdim(GEN al);
GEN     alg_get_abssplitting(GEN al);
GEN     alg_get_aut(GEN al);
GEN     alg_get_auts(GEN al);
GEN     alg_get_basis(GEN al);
GEN     alg_get_b(GEN al);
GEN     alg_get_center(GEN al);
GEN     alg_get_char(GEN al);
long    alg_get_degree(GEN al);
long    alg_get_dim(GEN al);
GEN     alg_get_hasse_f(GEN al);
GEN     alg_get_hasse_i(GEN al);
GEN     alg_get_invbasis(GEN al);
GEN     alg_get_invol(GEN al);
GEN     alg_get_multable(GEN al);
GEN     alg_get_relmultable(GEN al);
GEN     alg_get_splitpol(GEN al);
GEN     alg_get_splittingbasis(GEN al);
GEN     alg_get_splittingbasisinv(GEN al);
GEN     alg_get_splittingdata(GEN al);
GEN     alg_get_splittingfield(GEN al);
GEN     alg_get_tracebasis(GEN al);
GEN     alg_centralproj(GEN al, GEN z, long maps);
GEN     alg_complete(GEN rnf, GEN aut, GEN hi, GEN hf, long flag);
GEN     alg_csa_table(GEN nf, GEN mt, long v, long flag);
GEN     alg_cyclic(GEN rnf, GEN aut, GEN b, long flag);
GEN     alg_hasse(GEN nf, long n, GEN hi, GEN hf, long var, long flag);
GEN     alg_hilbert(GEN nf, GEN a, GEN b, long v, long flag);
GEN     alg_matrix(GEN nf, long n, long v, long flag);
long    alg_model(GEN al, GEN x);
GEN     alg_quotient(GEN al, GEN id, long maps);
long    alg_type(GEN al);
GEN     algadd(GEN al, GEN x, GEN y);
GEN     algalgtobasis(GEN al, GEN x);
GEN     algaut(GEN al);
GEN     algbasis(GEN al);
GEN     algbasistoalg(GEN al, GEN x);
GEN     algbasistoquat(GEN al, GEN x);
GEN     algb(GEN al);
GEN     algcenter(GEN al);
GEN     algchar(GEN al);
GEN     algcharpoly(GEN al, GEN x, long v, long abs);
long    algdegree(GEN al);
long    algdim(GEN al, long abs);
GEN     algdisc(GEN al);
GEN     algdivl(GEN al, GEN x, GEN y);
GEN     algdivr(GEN al, GEN x, GEN y);
GEN     algeichlerbasis(GEN al, GEN N);
GEN     algeltfromnf(GEN al, GEN x);
GEN     alggroupcenter(GEN gal, GEN p, GEN* ptr_conjclasses);
GEN     alggroup(GEN gal, GEN p);
GEN     alghassef(GEN al);
GEN     alghasse(GEN al, GEN pl);
GEN     alghassei(GEN al);
long    algindex(GEN al, GEN pl);
GEN     alginit(GEN A, GEN B, long v, long flag);
GEN     alginvbasis(GEN al);
GEN     alginv(GEN al, GEN x);
GEN     alginvol(GEN al, GEN x);
int     algisassociative(GEN mt0, GEN p);
int     algiscommutative(GEN al);
int     algisdivision(GEN al, GEN pl);
int     algisdivl(GEN al, GEN x, GEN y, GEN* ptz);
int     algisinv(GEN al, GEN x, GEN* ptix);
int     algisisom(GEN al, GEN al2, GEN pl);
GEN     algisquatalg(GEN al);
int     algisramified(GEN al, GEN pl);
int     algissemisimple(GEN al);
int     algissimple(GEN al, long ss);
int     algissplit(GEN al, GEN pl);
GEN     alglat_get_primbasis(GEN lat);
GEN     alglat_get_scalar(GEN lat);
GEN     alglatadd(GEN al, GEN lat1, GEN lat2, GEN* ptinter);
int     alglatcontains(GEN al, GEN lat, GEN x, GEN* ptc);
GEN     alglatelement(GEN al, GEN lat, GEN c);
GEN     alglathnf(GEN al, GEN m, GEN d);
GEN     alglatindex(GEN al, GEN lat1, GEN lat2);
GEN     alglatinter(GEN al, GEN lat1, GEN lat2, GEN* ptsum);
GEN     alglatlefttransporter(GEN al, GEN lat1, GEN lat2);
GEN     alglatmul(GEN al, GEN lat1, GEN lat2);
GEN     alglatrighttransporter(GEN al, GEN lat1, GEN lat2);
int     alglatsubset(GEN al, GEN lat1, GEN lat2, GEN* ptindex);
GEN     algmakeintegral(GEN mt0, long maps);
GEN     algmodpr(GEN A, GEN x, GEN data);
GEN     algmodpr_get_ff(GEN data);
long    algmodpr_get_k(GEN data);
GEN     algmodpr_get_lift(GEN data);
long    algmodpr_get_m(GEN data);
GEN     algmodpr_get_p(GEN data);
GEN     algmodpr_get_pr(GEN data);
GEN     algmodpr_get_proj(GEN data);
GEN     algmodpr_get_tau(GEN data);
GEN     algmodpr_get_T(GEN data);
GEN     algmodprinit(GEN A, GEN pr, long v);
GEN     algmodprlift(GEN A, GEN x, GEN data);
GEN     algmul(GEN al, GEN x, GEN y);
GEN     algmultable(GEN al);
GEN     algneg(GEN al, GEN x);
GEN     algnewprec(GEN al, long prec);
GEN     algnewprec_shallow(GEN al, long prec);
GEN     algnorm(GEN al, GEN x, long abs);
GEN     algpoleval(GEN al, GEN pol, GEN x);
GEN     algpow(GEN al, GEN x, GEN n);
GEN     algprimesubalg(GEN al);
GEN     algquattobasis(GEN al, GEN x);
GEN     algradical(GEN al);
GEN     algramifiedplaces(GEN al);
GEN     algrandom(GEN al, GEN b);
GEN     algrelmultable(GEN al);
GEN     algsimpledec(GEN al, long maps);
GEN     algsimpledec_ss(GEN al, long maps);
GEN     algskolemnoether(GEN al, GEN a, GEN fa);
GEN     algsplit(GEN al, long v);
GEN     algsplittingdata(GEN al);
GEN     algsplittingfield(GEN al);
GEN     algsqr(GEN al, GEN x);
GEN     algsubalg(GEN al, GEN basis);
GEN     algsub(GEN al, GEN x, GEN y);
GEN     algtableinit(GEN mt, GEN p);
GEN     algtensor(GEN al1, GEN al2, long flag);
GEN     algtomatrix(GEN al, GEN x, long abs);
GEN     algtrace(GEN al, GEN x, long abs);
long    algtype(GEN al);
GEN     bnfgwgeneric(GEN bnf, GEN Lpr, GEN Ld, GEN pl, long var);
void    checkalg(GEN x);
void    checkhasse(GEN nf, GEN hi, GEN hf, long n);
void    checklat(GEN al, GEN lat);
GEN     conjclasses_algcenter(GEN cc, GEN p);
GEN     galoischardet(GEN gal, GEN ch, long o);
GEN     galoischarpoly(GEN gal, GEN ch, long o);
GEN     galoischartable(GEN gal);
GEN     nfgrunwaldwang(GEN nf0, GEN Lpr, GEN Ld, GEN pl, long var);
GEN     nfgwkummer(GEN nf, GEN Lpr, GEN Ld, GEN pl, long var);

/* alglin1.c */

GEN     F2Ms_colelim(GEN M, long nbrow);
GEN     F2m_image(GEN x);
GEN     F2m_indexrank(GEN x);
GEN     F2m_suppl(GEN x);
GEN     F2xqM_F2xqC_gauss(GEN a, GEN b, GEN T);
GEN     F2xqM_F2xqC_invimage(GEN a, GEN b, GEN T);
GEN     F2xqM_F2xqC_mul(GEN a, GEN b, GEN T);
GEN     F2xqM_deplin(GEN x, GEN T);
GEN     F2xqM_det(GEN a, GEN T);
GEN     F2xqM_gauss(GEN a, GEN b, GEN T);
GEN     F2xqM_ker(GEN x, GEN T);
GEN     F2xqM_image(GEN x, GEN T);
GEN     F2xqM_indexrank(GEN x, GEN T);
GEN     F2xqM_inv(GEN a, GEN T);
GEN     F2xqM_invimage(GEN a, GEN b, GEN T);
GEN     F2xqM_mul(GEN a, GEN b, GEN T);
long    F2xqM_rank(GEN x, GEN T);
GEN     F2xqM_suppl(GEN x, GEN T);
GEN     Flm_image(GEN x, ulong p);
GEN     Flm_indexrank(GEN x, ulong p);
GEN     Flm_suppl(GEN x, ulong p);
GEN     FlxqM_FlxqC_gauss(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqM_FlxqC_invimage(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqM_FlxqC_mul(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqM_deplin(GEN x, GEN T, ulong p);
GEN     FlxqM_det(GEN a, GEN T, ulong p);
GEN     FlxqM_gauss(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqM_ker(GEN x, GEN T, ulong p);
GEN     FlxqM_image(GEN x, GEN T, ulong p);
GEN     FlxqM_indexrank(GEN x, GEN T, ulong p);
GEN     FlxqM_inv(GEN x, GEN T, ulong p);
GEN     FlxqM_invimage(GEN a, GEN b, GEN T, ulong p);
GEN     FlxqM_mul(GEN a, GEN b, GEN T, ulong p);
long    FlxqM_rank(GEN x, GEN T, ulong p);
GEN     FlxqM_suppl(GEN x, GEN T, ulong p);
GEN     FpM_FpC_gauss(GEN a, GEN b, GEN p);
GEN     FpM_FpC_invimage(GEN m, GEN v, GEN p);
GEN     FpM_deplin(GEN x, GEN p);
GEN     FpM_det(GEN x, GEN p);
GEN     FpM_gauss(GEN a, GEN b, GEN p);
GEN     FpM_image(GEN x, GEN p);
GEN     FpM_indexrank(GEN x, GEN p);
GEN     FpM_intersect(GEN x, GEN y, GEN p);
GEN     FpM_intersect_i(GEN x, GEN y, GEN p);
GEN     FpM_inv(GEN x, GEN p);
GEN     FpM_invimage(GEN m, GEN v, GEN p);
GEN     FpM_ker(GEN x, GEN p);
long    FpM_rank(GEN x, GEN p);
GEN     FpM_suppl(GEN x, GEN p);
GEN     FqM_FqC_gauss(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_FqC_invimage(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_FqC_mul(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_deplin(GEN x, GEN T, GEN p);
GEN     FqM_det(GEN x, GEN T, GEN p);
GEN     FqM_gauss(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_ker(GEN x, GEN T, GEN p);
GEN     FqM_image(GEN x, GEN T, GEN p);
GEN     FqM_indexrank(GEN x, GEN T, GEN p);
GEN     FqM_inv(GEN x, GEN T, GEN p);
GEN     FqM_invimage(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_mul(GEN a, GEN b, GEN T, GEN p);
long    FqM_rank(GEN a, GEN T, GEN p);
GEN     FqM_suppl(GEN x, GEN T, GEN p);
GEN     QM_image_shallow(GEN A);
GEN     QM_image(GEN A);
GEN     QM_gauss(GEN a, GEN b);
GEN     QM_gauss_i(GEN M, GEN B, long flag);
GEN     QM_indexrank(GEN x);
GEN     QM_inv(GEN M);
long    QM_rank(GEN x);
GEN     RgM_Fp_init(GEN a, GEN p, ulong *pp);
GEN     RgM_Hadamard(GEN a);
GEN     RgM_RgC_invimage(GEN A, GEN B);
GEN     RgM_diagonal(GEN m);
GEN     RgM_diagonal_shallow(GEN m);
GEN     RgM_div(GEN a, GEN b);
GEN     RgM_inv(GEN a);
GEN     RgM_inv_upper(GEN a);
GEN     RgM_invimage(GEN A, GEN B);
GEN     RgM_solve(GEN a, GEN b);
GEN     RgM_solve_realimag(GEN x, GEN y);
void    RgMs_structelim(GEN M, long nbrow, GEN A, GEN *p_col, GEN *p_lin);
GEN     ZM_det(GEN a);
GEN     ZM_detmult(GEN A);
GEN     ZM_gauss(GEN a, GEN b);
GEN     ZM_ker(GEN M);
GEN     ZM_imagecompl(GEN x);
GEN     ZM_indeximage(GEN x);
GEN     ZM_indexrank(GEN x);
GEN     ZM_inv(GEN M, GEN *den);
GEN     ZM_inv_ratlift(GEN M, GEN *pden);
GEN     ZM_pseudoinv(GEN M, GEN *pv, GEN *den);
long    ZM_rank(GEN x);
GEN     ZlM_gauss(GEN a, GEN b, ulong p, long e, GEN C);
GEN     closemodinvertible(GEN x, GEN y);
GEN     deplin(GEN x);
GEN     det(GEN a);
GEN     det0(GEN a,long flag);
GEN     det2(GEN a);
GEN     detint(GEN x);
GEN     eigen(GEN x, long prec);
GEN     gauss(GEN a, GEN b);
GEN     gaussmodulo(GEN M, GEN D, GEN Y);
GEN     gaussmodulo2(GEN M, GEN D, GEN Y);
GEN     gen_Gauss(GEN a, GEN b, void *E, const struct bb_field *ff);
GEN     gen_Gauss_pivot(GEN x, long *rr, void *E, const struct bb_field *ff);
GEN     gen_det(GEN a, void *E, const struct bb_field *ff);
GEN     gen_ker(GEN x, long deplin, void *E, const struct bb_field *ff);
GEN     gen_matcolinvimage(GEN a, GEN b, void *E, const struct bb_field *ff);
GEN     gen_matcolmul(GEN a, GEN b, void *E, const struct bb_field *ff);
GEN     gen_matinvimage(GEN a, GEN b, void *E, const struct bb_field *ff);
GEN     gen_matmul(GEN a, GEN b, void *E, const struct bb_field *ff);
GEN     image(GEN x);
GEN     image2(GEN x);
GEN     imagecompl(GEN x);
GEN     indexrank(GEN x);
GEN     inverseimage(GEN mat, GEN y);
GEN     ker(GEN x);
GEN     mateigen(GEN x, long flag, long prec);
GEN     matimage0(GEN x,long flag);
GEN     matker0(GEN x, long flag);
long    rank(GEN x);
GEN     reducemodinvertible(GEN x, GEN y);
GEN     reducemodlll(GEN x,GEN y);
GEN     split_realimag(GEN x, long r1, long r2);
GEN     suppl(GEN x);

/* alglin2.c */

GEN     Flm_charpoly(GEN x, ulong p);
GEN     Flm_hess_pre(GEN x, ulong p, ulong pi);
GEN     Flm_hess(GEN x, ulong p);
ulong   Flm_trace(GEN x, ulong p);
GEN     FpM_charpoly(GEN x, GEN p);
GEN     FpM_hess(GEN x, GEN p);
GEN     FpM_trace(GEN x, GEN p);
GEN     Frobeniusform(GEN V, long n);
GEN     QM_minors_coprime(GEN x, GEN pp);
GEN     QM_ImZ(GEN x);
GEN     QM_ImZ_all(GEN x, GEN *U, long remove, long hnf);
GEN     QM_ImZ_hnf(GEN x);
GEN     QM_ImZ_hnfall(GEN x, GEN *U, long remove);
GEN     QM_ImQ(GEN x);
GEN     QM_ImQ_all(GEN x, GEN *U, long remove, long hnf);
GEN     QM_ImQ_hnf(GEN x);
GEN     QM_ImQ_hnfall(GEN x, GEN *U, long remove);
GEN     QM_charpoly_ZX(GEN M);
GEN     QM_charpoly_ZX_bound(GEN M, long bit);
GEN     RgM_Cholesky(GEN M, long prec);
GEN     ZM_charpoly(GEN x);
GEN     ZM_trace(GEN x);
GEN     adj(GEN x);
GEN     adjsafe(GEN x);
GEN     caract(GEN x, long v);
GEN     caradj(GEN x, long v, GEN *py);
GEN     carberkowitz(GEN x, long v);
GEN     carhess(GEN x, long v);
GEN     charpoly(GEN x, long v);
GEN     charpoly0(GEN x, long v,long flag);
GEN     gnorm(GEN x);
GEN     gnorml1(GEN x,long prec);
GEN     gnorml1_fake(GEN x);
GEN     gnormlp(GEN x, GEN p, long prec);
GEN     gnorml2(GEN x);
GEN     gsupnorm(GEN x, long prec);
void    gsupnorm_aux(GEN x, GEN *m, GEN *msq, long prec);
GEN     gtrace(GEN x);
GEN     hess(GEN x);
GEN     intersect(GEN x, GEN y);
GEN     jacobi(GEN a, long prec);
GEN     matadjoint0(GEN x, long flag);
GEN     matcompanion(GEN x);
GEN     matrixqz0(GEN x, GEN pp);
GEN     minpoly(GEN x, long v);
GEN     qfcholesky(GEN a, long prec);
GEN     qfgaussred(GEN a);
GEN     qfgaussred_positive(GEN a);
GEN     qfgaussred0(GEN a, long flag);
GEN     qfgaussred2(GEN a);
GEN     qfsign(GEN a);

/* alglin3.c */

GEN     apply0(GEN f, GEN A);
GEN     diagonal(GEN x);
GEN     diagonal_shallow(GEN x);
GEN     extract0(GEN x, GEN l1, GEN l2);
GEN     fold0(GEN f, GEN A);
GEN     gen_parapply(GEN worker, GEN D);
GEN     gen_parapply_percent(GEN worker, GEN D, long percent);
GEN     gen_parapply_slice(GEN worker, GEN D, long mmin);
GEN     gen_parapply_slice_zv(GEN worker, GEN D, long mmin);
GEN     genapply(void *E, GEN (*f)(void *E, GEN x), GEN A);
GEN     genfold(void *E, GEN (*f)(void *E, GEN x, GEN y), GEN A);
GEN     genindexselect(void *E, long (*f)(void *E, GEN x), GEN A);
GEN     genselect(void *E, long (*f)(void *E, GEN x), GEN A);
GEN     gtomat(GEN x);
GEN     gtrans(GEN x);
GEN     matmuldiagonal(GEN x, GEN d);
GEN     matmultodiagonal(GEN x, GEN y);
GEN     matslice0(GEN A, long x1, long x2, long y1, long y2);
GEN     parapply(GEN V, GEN C);
void    parfor(GEN a, GEN b, GEN code, void *E, long call(void*, GEN, GEN));
void    parfor_init(parfor_t *T, GEN a, GEN b, GEN code);
GEN     parfor_next(parfor_t *T);
void    parfor_stop(parfor_t *T);
void    parforeach(GEN x, GEN code, void *E, long call(void*, GEN, GEN));
void    parforeach_init(parforeach_t *T, GEN x, GEN code);
GEN     parforeach_next(parforeach_t *T);
void    parforeach_stop(parforeach_t *T);
void    parforprime(GEN a, GEN b, GEN code, void *E, long call(void*, GEN, GEN));
void    parforprime_init(parforprime_t *T, GEN a, GEN b, GEN code);
GEN     parforprime_next(parforprime_t *T);
void    parforprime_stop(parforprime_t *T);
void    parforprimestep(GEN a, GEN b, GEN q, GEN code, void *E, long call(void*, GEN, GEN));
void    parforprimestep_init(parforprime_t *T, GEN a, GEN b, GEN q, GEN code);
void    parforstep(GEN a, GEN b, GEN s, GEN code, void *E, long call(void*, GEN, GEN));
void    parforstep_init(parforstep_t *T, GEN a, GEN b, GEN s, GEN code);
GEN     parforstep_next(parforstep_t *T);
void    parforstep_stop(parforstep_t *T);
void    parforvec(GEN x, GEN code, long flag, void *E, long call(void*, GEN, GEN));
void    parforvec_init(parforvec_t *T, GEN x, GEN code, long flag);
GEN     parforvec_next(parforvec_t *T);
void    parforvec_stop(parforvec_t *T);
GEN     parselect(GEN C, GEN D, long flag);
GEN     select0(GEN A, GEN f, long flag);
GEN     shallowextract(GEN x, GEN L);
GEN     shallowmatextract(GEN x, GEN l1, GEN l2);
GEN     shallowtrans(GEN x);
GEN     vecapply(void *E, GEN (*f)(void* E, GEN x), GEN x);
GEN     veccatapply(void *E, GEN (*f)(void* E, GEN x), GEN x);
GEN     veccatselapply(void *Epred, long (*pred)(void* E, GEN x), void *Efun,
                            GEN (*fun)(void* E, GEN x), GEN A);
GEN     vecrange(GEN a, GEN b);
GEN     vecrangess(long a, long b);
GEN     vecselapply(void *Epred, long (*pred)(void* E, GEN x), void *Efun,
                            GEN (*fun)(void* E, GEN x), GEN A);
GEN     vecselect(void *E, long (*f)(void* E, GEN x), GEN A);
GEN     vecslice0(GEN A, long y1, long y2);
GEN     vecsum(GEN v);
GEN     zv_diagonal(GEN x);

/* anal.c */

void    addhelp(const char *e, const char *s);
GEN     arity0(GEN C);
void    alias0(const char *s, const char *old);
GEN     compile_str(const char *s);
long    delete_var(void);
long    fetch_user_var(const char *s);
long    fetch_var(void);
long    fetch_var_higher(void);
GEN     fetch_var_value(long vx, GEN t);
GEN     gp_read_str(const char *t);
GEN     gp_read_str_bitprec(const char *s, long bitprec);
GEN     gp_read_str_prec(const char *s, long prec);
GEN     ifpari(GEN g, GEN a, GEN b);
entree* install(void *f, const char *name, const char *code);
entree* is_entry(const char *s);
void    kill0(const char *e);
void    pari_var_close(void);
void    pari_var_init(void);
long    pari_var_next(void);
long    pari_var_next_temp(void);
long    pari_var_create(entree *ep);
void    name_var(long n, const char *s);
GEN     readseq(char *t);
GEN*    safegel(GEN x, long l);
long*   safeel(GEN x, long l);
GEN*    safelistel(GEN x, long l);
GEN*    safegcoeff(GEN x, long a, long b);
GEN     strtoi(const char *s);
GEN     strtor(const char *s, long prec);
GEN     varhigher(const char *s, long v);
GEN     varlower(const char *s, long v);

/* aprcl.c */

GEN     divisorslenstra(GEN N, GEN r, GEN s);
long    isprimeAPRCL(GEN N);

/* Qfb.c */

GEN     Qfb0(GEN x, GEN y, GEN z);
void    check_quaddisc(GEN x, long *s, long *r, const char *f);
void    check_quaddisc_imag(GEN x, long *r, const char *f);
void    check_quaddisc_real(GEN x, long *r, const char *f);
long    cornacchia(GEN d, GEN p, GEN *px, GEN *py);
long    cornacchia2(GEN d, GEN p, GEN *px, GEN *py);
long    cornacchia2_sqrt(GEN d, GEN p, GEN b, GEN *px, GEN *py);
GEN     nucomp(GEN x, GEN y, GEN L);
GEN     nudupl(GEN x, GEN L);
GEN     nupow(GEN x, GEN n, GEN L);
GEN     primeform(GEN x, GEN p);
GEN     primeform_u(GEN x, ulong p);
GEN     qfb_1(GEN x);
GEN     qfbcomp(GEN x, GEN y);
GEN     qfbcomp_i(GEN x, GEN y);
GEN     qfbcompraw(GEN x, GEN y);
GEN     qfbcompraw_i(GEN x, GEN y);
GEN     qfbcornacchia(GEN d, GEN p);
GEN     qfbpow(GEN x, GEN n);
GEN     qfbpow_i(GEN x, GEN n);
GEN     qfbpowraw(GEN x, long n);
GEN     qfbpows(GEN x, long n);
GEN     qfbred(GEN x);
GEN     qfbred_i(GEN x);
GEN     qfi_red(GEN q);
GEN     qfr_red(GEN q);
GEN     qfbred0(GEN x, long flag, GEN isqrtD, GEN sqrtD);
GEN     qfbredsl2(GEN q, GEN isD);
GEN     qfbsolve(GEN Q, GEN n, long flag);
GEN     qfbsqr(GEN x);
GEN     qfbsqr_i(GEN x);
GEN     qfisolvep(GEN Q, GEN p);
GEN     qfr3_comp(GEN x, GEN y, struct qfr_data *S);
GEN     qfr3_compraw(GEN x, GEN y);
GEN     qfr3_pow(GEN x, GEN n, struct qfr_data *S);
GEN     qfr3_red(GEN x, struct qfr_data *S);
GEN     qfr3_rho(GEN x, struct qfr_data *S);
GEN     qfr3_to_qfr(GEN x, GEN D);
GEN     qfr5_comp(GEN x, GEN y, struct qfr_data *S);
GEN     qfr5_compraw(GEN x, GEN y);
GEN     qfr5_dist(GEN e, GEN d, long prec);
GEN     qfr5_pow(GEN x, GEN n, struct qfr_data *S);
GEN     qfr5_red(GEN x, struct qfr_data *S);
GEN     qfr5_rho(GEN x, struct qfr_data *S);
GEN     qfr5_to_qfr(GEN x, GEN D, GEN d0);
void    qfr_data_init(GEN D, long prec, struct qfr_data *S);
GEN     qfr_to_qfr5(GEN x, long prec);
GEN     qfrsolvep(GEN Q, GEN p);
GEN     quadgen(GEN x);
GEN     quadgen0(GEN x, long v);
GEN     quadpoly(GEN x);
GEN     quadpoly_i(GEN D);
GEN     quadpoly0(GEN x, long v);

/* arith1.c */

ulong   Fl_2gener_pre(ulong p, ulong pi);
ulong   Fl_2gener_pre_i(ulong  ns, ulong p, ulong pi);
ulong   Fl_log(ulong a, ulong g, ulong ord, ulong p);
ulong   Fl_log_pre(ulong a, ulong g, ulong ord, ulong p, ulong pi);
ulong   Fl_order(ulong a, ulong o, ulong p);
GEN     Fl_powers(ulong x, long n, ulong p);
GEN     Fl_powers_pre(ulong x, long n, ulong p, ulong pi);
ulong   Fl_powu(ulong x, ulong n, ulong p);
ulong   Fl_powu_pre(ulong x, ulong n, ulong p, ulong pi);
ulong   Fl_sqrt(ulong a, ulong p);
ulong   Fl_sqrt_pre(ulong a, ulong p, ulong pi);
ulong   Fl_sqrt_pre_i(ulong a, ulong s2, ulong p, ulong pi);
ulong   Fl_sqrtl(ulong a, ulong l, ulong p);
ulong   Fl_sqrtl_pre(ulong a, ulong l, ulong p, ulong pi);
ulong   Fl_sqrtn(ulong a, long n, ulong p, ulong *zetan);
ulong   Fl_sqrtn_pre(ulong a, long n, ulong p, ulong pi, ulong *zetan);
GEN     Fp_2gener(GEN p);
GEN     Fp_2gener_i(GEN ns, GEN p);
GEN     Fp_factored_order(GEN a, GEN o, GEN p);
int     Fp_ispower(GEN x, GEN K, GEN p);
GEN     Fp_log(GEN a, GEN g, GEN ord, GEN p);
GEN     Fp_order(GEN a, GEN o, GEN p);
GEN     Fp_pow(GEN a, GEN n, GEN m);
GEN     Fp_pow_init(GEN x, GEN n, long k, GEN p);
GEN     Fp_pow_table(GEN R, GEN n, GEN p);
GEN     Fp_powers(GEN x, long n, GEN p);
GEN     Fp_pows(GEN A, long k, GEN N);
GEN     Fp_powu(GEN x, ulong k, GEN p);
GEN     Fp_sqrt(GEN a, GEN p);
GEN     Fp_sqrt_i(GEN a, GEN y, GEN p);
GEN     Fp_sqrtn(GEN a, GEN n, GEN p, GEN *zetan);
GEN     FpV_prod(GEN V, GEN p);
GEN     Z_ZV_mod(GEN P, GEN xa);
GEN     Z_ZV_mod_tree(GEN P, GEN xa, GEN T);
GEN     Z_chinese(GEN a, GEN b, GEN A, GEN B);
GEN     Z_chinese_all(GEN a, GEN b, GEN A, GEN B, GEN *pC);
GEN     Z_chinese_coprime(GEN a, GEN b, GEN A, GEN B, GEN C);
GEN     Z_chinese_post(GEN a, GEN b, GEN C, GEN U, GEN d);
void    Z_chinese_pre(GEN A, GEN B, GEN *pC, GEN *pU, GEN *pd);
GEN     Z_factor_listP(GEN N, GEN L);
GEN     Z_nv_mod(GEN P, GEN xa);
GEN     ZM_nv_mod_tree(GEN M, GEN xa, GEN T);
GEN     ZMV_producttree(GEN xa);
GEN     ZV_allpnqn(GEN x);
GEN     ZV_chinese(GEN A, GEN P, GEN *pt_mod);
GEN     ZV_chinese_tree(GEN A, GEN P, GEN T, GEN R);
GEN     ZV_chinesetree(GEN P, GEN T);
GEN     ZV_nv_mod_tree(GEN V, GEN xa, GEN T);
GEN     ZV_producttree(GEN xa);
GEN     ZVV_nv_mod_tree(GEN M, GEN xa, GEN T);
GEN     ZX_nv_mod_tree(GEN P, GEN xa, GEN T);
GEN     ZXC_nv_mod_tree(GEN P, GEN xa, GEN T, long w);
GEN     ZXM_nv_mod_tree(GEN M, GEN xa, GEN T, long w);
GEN     ZXX_nv_mod_tree(GEN P, GEN xa, GEN T, long w);
GEN     Zideallog(GEN bid, GEN x);
GEN     bestappr(GEN x, GEN k);
GEN     bestapprPade(GEN x, long B);
GEN     bestapprPade0(GEN x, long B, long C);
GEN     chinese(GEN x, GEN y);
GEN     chinese1(GEN x);
GEN     chinese1_coprime_Z(GEN x);
GEN     contfrac0(GEN x, GEN b, long flag);
GEN     contfracpnqn(GEN x, long n);
GEN     fibo(long n);
GEN     gboundcf(GEN x, long k);
GEN     gcf(GEN x);
GEN     gcf2(GEN b, GEN x);
const struct bb_field *get_Fp_field(void **E, GEN p);
long    hilbert(GEN x, GEN y, GEN p);
long    hilbertii(GEN x, GEN y, GEN p);
long    istotient(GEN n, GEN *px);
long    krois(GEN x, long y);
long    kroiu(GEN x, ulong y);
long    kronecker(GEN x, GEN y);
long    krosi(long s, GEN x);
long    kross(long x, long y);
long    kroui(ulong x, GEN y);
long    krouu(ulong x, ulong y);
GEN     lcmii(GEN a, GEN b);
GEN     Fp_invgen(GEN x, GEN N, GEN *pd);
long    logint0(GEN B, GEN y, GEN *ptq);
long    logintall(GEN B, GEN y, GEN *ptq);
ulong   factorial_Fl(long n, ulong p);
GEN     factorial_Fp(long n, GEN p);
GEN     mpfact(long n);
GEN     mpprimorial(long n);
GEN     muls_interval(long a, long b);
GEN     mulu_interval(ulong a, ulong b);
GEN     mulu_interval_step(ulong a, ulong b, ulong step);
GEN     ncV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     ncV_chinese_center_tree(GEN A, GEN P, GEN T, GEN R);
GEN     nmV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     nmV_chinese_center_tree(GEN A, GEN P, GEN T, GEN R);
ulong   nonsquare_Fl(ulong p);
GEN     nxCV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     nxCV_chinese_center_tree(GEN A, GEN P, GEN T, GEN R);
GEN     nxMV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     nxV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     nxV_chinese_center_tree(GEN A, GEN P, GEN T, GEN R);
GEN     ZV_chinese_center(GEN A, GEN P, GEN *pt_mod);
GEN     odd_prime_divisors(GEN q);
ulong   pgener_Fl(ulong p);
ulong   pgener_Fl_local(ulong p, GEN L);
GEN     pgener_Fp(GEN p);
GEN     pgener_Fp_local(GEN p, GEN L);
ulong   pgener_Zl(ulong p);
GEN     pgener_Zp(GEN p);
GEN     pnqn(GEN x);
GEN     ramanujantau(GEN n, long ell);
ulong   rootsof1_Fl(ulong n, ulong p);
GEN     rootsof1_Fp(GEN n, GEN p);
GEN     rootsof1u_Fp(ulong n, GEN p);
ulong   u_chinese_coprime(ulong a, ulong b, ulong A, ulong B, ulong C);
GEN     znlog(GEN x, GEN g, GEN o);
GEN     znorder(GEN x, GEN o);
GEN     znprimroot(GEN m);
GEN     znstar(GEN x);
GEN     znstar0(GEN N, long flag);

/* arith2.c */

int     RgV_is_ZVpos(GEN v);
int     RgV_is_ZVnon0(GEN v);
int     RgV_is_prV(GEN v);
long    Z_issquarefree_fact(GEN F);
GEN     Z_lsmoothen(GEN N, GEN L, GEN *pP, GEN *pe);
GEN     Z_smoothen(GEN N, GEN L, GEN *pP, GEN *pe);
long    bigomega(GEN n);
long    bigomegau(ulong n);
GEN     boundfact(GEN n, ulong lim);
GEN     check_arith_pos(GEN n, const char *f);
GEN     check_arith_non0(GEN n, const char *f);
GEN     check_arith_all(GEN n, const char *f);
GEN     clean_Z_factor(GEN f);
GEN     core(GEN n);
GEN     coredisc2_fact(GEN fa, long s, GEN *pP, GEN *pE);
ulong   coredisc2u_fact(GEN fa, long s, GEN *pP, GEN *pE);
GEN     corepartial(GEN n, long l);
GEN     core0(GEN n,long flag);
GEN     core2(GEN n);
GEN     core2partial(GEN n, long l);
GEN     coredisc(GEN n);
GEN     coredisc0(GEN n,long flag);
GEN     coredisc2(GEN n);
long    corediscs(long D, ulong *f);
GEN     divisors(GEN n);
GEN     divisors_factored(GEN N);
GEN     divisors0(GEN N, long flag);
GEN     divisorsu(ulong n);
GEN     divisorsu_moebius(GEN P);
GEN     divisorsu_fact(GEN fa);
GEN     divisorsu_fact_factored(GEN fa);
GEN     eulerphi(GEN n);
ulong   eulerphiu(ulong n);
ulong   eulerphiu_fact(GEN f);
GEN     factor_pn_1(GEN p, ulong n);
GEN     factor_pn_1_limit(GEN p, long n, ulong lim);
GEN     factoru_pow(ulong n);
GEN     fuse_Z_factor(GEN f, GEN B);
int     is_Z_factor(GEN f);
int     is_Z_factornon0(GEN f);
int     is_Z_factorpos(GEN f);
int     is_nf_factor(GEN F);
int     is_nf_extfactor(GEN F);
long    issquarefree(GEN x);
GEN     numdiv(GEN n);
long    numdivu(long N);
long    numdivu_fact(GEN fa);
long    omega(GEN n);
long    omegau(ulong n);
GEN     sumdiv(GEN n);
GEN     sumdivk(GEN n,long k);
long    uissquarefree(ulong n);
long    uissquarefree_fact(GEN f);
GEN     usumdiv_fact(GEN f);
GEN     usumdivk_fact(GEN f, ulong k);

/* base1.c */

GEN     FpX_FpC_nfpoleval(GEN nf, GEN pol, GEN a, GEN p);
GEN     embed_T2(GEN x, long r1);
GEN     embednorm_T2(GEN x, long r1);
GEN     embed_norm(GEN x, long r1);
int     check_ZKmodule_i(GEN M);
void    check_ZKmodule(GEN x, const char *s);
void    checkbid(GEN bid);
GEN     checkbid_i(GEN bid);
GEN     checkbnf(GEN bnf);
GEN     checkbnf_i(GEN bnf);
void    checkbnr(GEN bnr);
GEN     checkbnr_i(GEN bnr);
void    checkabgrp(GEN v);
void    checksqmat(GEN x, long N);
GEN     checknf(GEN nf);
GEN     checknf_i(GEN nf);
GEN     checknfelt_mod(GEN nf, GEN x, const char *s);
void    checkprid(GEN bid);
int     checkprid_i(GEN x);
void    checkrnf(GEN rnf);
int     checkrnf_i(GEN rnf);
GEN     factoredpolred(GEN x, GEN fa);
GEN     factoredpolred2(GEN x, GEN fa);
GEN     galoisapply(GEN nf, GEN aut, GEN x);
GEN     get_bnf(GEN x, long *t);
GEN     get_bnfpol(GEN x, GEN *bnf, GEN *nf);
GEN     get_nf(GEN x, long *t);
GEN     get_nfpol(GEN x, GEN *nf);
GEN     get_prid(GEN x);
GEN     idealfrobenius(GEN nf, GEN gal, GEN pr);
GEN     idealfrobenius_aut(GEN nf, GEN gal, GEN pr, GEN aut);
GEN     idealramfrobenius(GEN nf, GEN gal, GEN pr, GEN ram);
GEN     idealramfrobenius_aut(GEN nf, GEN gal, GEN pr, GEN ram, GEN aut);
GEN     idealramgroups(GEN nf, GEN gal, GEN pr);
GEN     idealramgroups_aut(GEN nf, GEN gal, GEN pr, GEN aut);
GEN     nf_get_allroots(GEN nf);
long    nf_get_prec(GEN x);
GEN     nfmaxord_to_nf(nfmaxord_t *T, GEN ro, long prec);
GEN     nfcertify(GEN x);
GEN     nfgaloismatrix(GEN nf, GEN s);
GEN     nfgaloismatrixapply(GEN nf, GEN M, GEN x);
GEN     nfgaloispermtobasis(GEN nf, GEN gal);
void    nfinit_basic(nfmaxord_t *T, GEN x);
GEN     nfinit_complete(nfmaxord_t *T, long flag, long prec);
GEN     nfinit(GEN x, long prec);
GEN     nfinit0(GEN x, long flag, long prec);
GEN     nfinitred(GEN x, long prec);
GEN     nfinitred2(GEN x, long prec);
GEN     nfisincl(GEN a, GEN b);
GEN     nfisincl0(GEN fa, GEN fb, long flag);
GEN     nfisisom(GEN a, GEN b);
GEN     nfnewprec(GEN nf, long prec);
GEN     nfnewprec_shallow(GEN nf, long prec);
GEN     nfpoleval(GEN nf, GEN pol, GEN a);
GEN     nfsplitting(GEN T, GEN D);
GEN     nfsplitting0(GEN T, GEN D, long flag);
long    nftyp(GEN x);
GEN     polredord(GEN x);
GEN     polred(GEN x);
GEN     polred0(GEN x, long flag);
GEN     polred2(GEN x);
GEN     polredabs(GEN x);
GEN     polredabs0(GEN x, long flag);
GEN     polredabs2(GEN x);
GEN     polredabsall(GEN x, long flun);
GEN     polredbest(GEN x, long flag);
GEN     poltomonic(GEN T, GEN *L);
GEN     rnfpolredabs(GEN nf, GEN pol, long flag);
GEN     rnfpolredbest(GEN nf, GEN R, long flag);
GEN     rnfnewprec_shallow(GEN rnf, long prec);
GEN     rnfnewprec(GEN rnf, long prec);
GEN     smallpolred(GEN x);
GEN     smallpolred2(GEN x);
GEN     tschirnhaus(GEN x);
GEN     ZX_Q_mul(GEN A, GEN z);
GEN     ZX_Q_normalize(GEN pol, GEN *ptlc);
GEN     ZX_Z_normalize(GEN pol, GEN *ptk);
GEN     ZX_to_monic(GEN pol, GEN *lead);
GEN     ZX_primitive_to_monic(GEN pol, GEN *lead);
GEN     ZXX_Q_mul(GEN A, GEN z);

/* base2.c */

GEN     Fq_to_nf(GEN x, GEN modpr);
GEN     FqM_to_nfM(GEN z, GEN modpr);
GEN     FqV_to_nfV(GEN z, GEN modpr);
GEN     FqX_to_nfX(GEN x, GEN modpr);
GEN     QXQV_to_FpM(GEN basis, GEN T, GEN p);
GEN     Rg_nffix(const char *f, GEN T, GEN c, int lift);
GEN     RgV_nffix(const char *f, GEN T, GEN P, int lift);
GEN     RgX_nffix(const char *s, GEN nf, GEN x, int lift);
GEN     ZX_composedsum(GEN A, GEN B);
GEN     ZX_compositum(GEN A, GEN B, long *lambda);
long    ZpX_disc_val(GEN f, GEN p);
GEN     ZpX_gcd(GEN f1,GEN f2,GEN p, GEN pm);
GEN     ZpX_monic_factor(GEN f, GEN p, long prec);
GEN     ZpX_primedec(GEN T, GEN p);
GEN     ZpX_reduced_resultant(GEN x, GEN y, GEN p, GEN pm);
GEN     ZpX_reduced_resultant_fast(GEN f, GEN g, GEN p, long M);
long    ZpX_resultant_val(GEN f, GEN g, GEN p, long M);
void    checkmodpr(GEN modpr);
GEN     compositum(GEN P, GEN Q);
GEN     compositum2(GEN P, GEN Q);
long    factorial_lval(ulong n, ulong p);
GEN     get_modpr(GEN x);
GEN     hnf_Znproj(GEN H);
GEN     idealprimedec(GEN nf,GEN p);
GEN     idealprimedec_degrees(GEN nf, GEN p);
GEN     idealprimedec_galois(GEN nf, GEN p);
GEN     idealprimedec_kummer(GEN nf,GEN pol,long e,GEN p);
GEN     idealprimedec_limit_f(GEN nf, GEN p, long f);
GEN     idealprimedec_limit_norm(GEN nf, GEN p, GEN B);
GEN     indexpartial(GEN P, GEN DP);
GEN     modpr_genFq(GEN modpr);
GEN     nf_pV_to_prV(GEN nf, GEN P);
GEN     nf_rnfeq(GEN nf, GEN R);
GEN     nf_rnfeqsimple(GEN nf, GEN R);
GEN     nf_to_Fq(GEN nf, GEN x, GEN modpr);
GEN     nf_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     nfM_to_FqM(GEN z, GEN nf,GEN modpr);
GEN     nfV_to_FqV(GEN z, GEN nf,GEN modpr);
GEN     nfX_to_FqX(GEN x, GEN nf,GEN modpr);
GEN     nfX_to_monic(GEN nf, GEN T, GEN *pL);
GEN     nfbasis(GEN x, GEN *y);
GEN     nfcompositum(GEN nf, GEN A, GEN B, long flag);
GEN     nfdisc(GEN x);
GEN     nfdiscfactors(GEN x);
void    nfmaxord(nfmaxord_t *S, GEN T, long flag);
GEN     nfmodpr(GEN nf, GEN x, GEN pr);
GEN     nfmodprinit(GEN nf, GEN pr);
GEN     nfmodprinit0(GEN nf, GEN pr, long v);
GEN     nfmodprlift(GEN nf, GEN x, GEN pr);
GEN     nfreducemodpr(GEN nf, GEN x, GEN modpr);
GEN     polcompositum0(GEN P, GEN Q,long flag);
GEN     poldiscfactors(GEN T, long flag);
GEN     pr_anti_uniformizer(GEN nf, GEN pr);
GEN     rnfbasis(GEN bnf, GEN order);
GEN     rnfdedekind(GEN nf, GEN T, GEN pr, long flag);
GEN     rnfdet(GEN nf, GEN order);
GEN     rnfdisc_factored(GEN nf, GEN pol, GEN *pd);
GEN     rnfdiscf(GEN nf, GEN pol);
GEN     rnfequation(GEN nf, GEN pol);
GEN     rnfequation0(GEN nf, GEN pol, long flall);
GEN     rnfequation2(GEN nf, GEN pol);
GEN     rnfequationall(GEN A, GEN B, long *pk, GEN *pLPRS);
GEN     rnfhnfbasis(GEN bnf, GEN order);
long    rnfisfree(GEN bnf, GEN order);
GEN     rnflllgram(GEN nf, GEN pol, GEN order,long prec);
GEN     rnfpolred(GEN nf, GEN pol, long prec);
GEN     rnfpseudobasis(GEN nf, GEN pol);
GEN     rnfsimplifybasis(GEN bnf, GEN order);
GEN     rnfsteinitz(GEN nf, GEN order);
GEN     zk_to_Fq(GEN x, GEN modpr);
GEN     zk_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     zkmodprinit(GEN nf, GEN pr);

/* base3.c */

GEN     Idealstar(GEN nf, GEN x,long flun);
GEN     Idealstarmod(GEN nf, GEN ideal, long flag, GEN MOD);
GEN     Idealstarprk(GEN nf, GEN pr, long k, long flag);
GEN     RgC_to_nfC(GEN nf,GEN x);
GEN     RgM_RgX_mul(GEN A, GEN x);
GEN     RgM_to_nfM(GEN nf,GEN x);
GEN     RgX_to_nfX(GEN nf,GEN pol);
long    ZC_nfval(GEN x, GEN P);
long    ZC_nfvalrem(GEN x, GEN P, GEN *t);
int     ZC_prdvd(GEN x, GEN P);
GEN     ZM_ZX_mul(GEN A, GEN x);
GEN     ZV_snf_gcd(GEN x, GEN mod);
GEN     algtobasis(GEN nf, GEN x);
GEN     basistoalg(GEN nf, GEN x);
GEN     ei_multable(GEN nf, long i);
const struct bb_field *get_nf_field(void **E, GEN nf);
GEN     famat_nfvalrem(GEN nf, GEN x, GEN pr, GEN *py);
GEN     gpnfvalrem(GEN nf, GEN x, GEN pr, GEN *py);
GEN     idealfactorback(GEN nf, GEN L, GEN e, long red);
GEN     ideallist(GEN nf,long bound);
GEN     ideallist0(GEN nf,long bound, long flag);
GEN     gideallist(GEN nf, GEN bound, long flag);
GEN     ideallistarch(GEN nf, GEN list, GEN arch);
GEN     ideallog(GEN nf,GEN x,GEN bid);
GEN     ideallogmod(GEN nf,GEN x,GEN bid, GEN mod);
GEN     ideallog_units(GEN bnf, GEN bid);
GEN     ideallog_units0(GEN bnf, GEN bid, GEN MOD);
GEN     idealprincipalunits(GEN nf, GEN pr, long e);
GEN     idealstar0(GEN nf, GEN x,long flag);
GEN     idealstarmod(GEN nf, GEN ideal, long flag, GEN MOD);
GEN     indices_to_vec01(GEN archp, long r);
GEN     matalgtobasis(GEN nf, GEN x);
GEN     matbasistoalg(GEN nf, GEN x);
GEN     multable(GEN nf, GEN x);
GEN     nf_to_scalar_or_alg(GEN nf, GEN x);
GEN     nf_to_scalar_or_basis(GEN nf, GEN x);
GEN     nf_to_scalar_or_polmod(GEN nf, GEN x);
GEN     nf_cxlog(GEN nf, GEN x, long prec);
GEN     nfV_cxlog(GEN nf, GEN x, long prec);
GEN     nfadd(GEN nf, GEN x, GEN y);
int     nfchecksigns(GEN nf, GEN x, GEN pl);
GEN     nfdiv(GEN nf, GEN x, GEN y);
GEN     nfdiveuc(GEN nf, GEN a, GEN b);
GEN     nfdivrem(GEN nf, GEN a, GEN b);
GEN     nfembed(GEN nf, GEN x, long k);
GEN     nfeltembed(GEN nf, GEN x, GEN ind0, long prec);
GEN     nfeltembed_i(GEN *pnf, GEN x, GEN ind0, long prec);
GEN     nfeltsign(GEN nf, GEN x, GEN ind0);
GEN     nffactorback(GEN nf, GEN L, GEN e);
GEN     nfinv(GEN nf, GEN x);
GEN     nfinvmodideal(GEN nf, GEN x, GEN ideal);
long    nfissquare(GEN nf, GEN z, GEN *px);
long    nfispower(GEN nf, GEN z, long n, GEN *px);
GEN     nflogembed(GEN nf, GEN x, GEN *emb, long prec);
GEN     nfM_det(GEN nf, GEN M);
GEN     nfM_inv(GEN nf, GEN M);
GEN     nfM_ker(GEN nf, GEN M);
GEN     nfM_mul(GEN nf, GEN A, GEN B);
GEN     nfM_nfC_mul(GEN nf, GEN A, GEN B);
GEN     nfmod(GEN nf, GEN a, GEN b);
GEN     nfmul(GEN nf,GEN x,GEN y);
GEN     nfmuli(GEN nf,GEN x,GEN y);
GEN     nfnorm(GEN nf, GEN x);
GEN     nfpolsturm(GEN nf, GEN f, GEN ind0);
GEN     nfpow(GEN nf,GEN x,GEN k);
GEN     nfpow_u(GEN nf, GEN z, ulong n);
GEN     nfpowmodideal(GEN nf,GEN x,GEN k,GEN ideal);
GEN     nfsign(GEN nf,GEN alpha);
GEN     nfsign_arch(GEN nf,GEN alpha,GEN arch);
GEN     nfsign_from_logarch(GEN Larch, GEN invpi, GEN archp);
GEN     nfsqr(GEN nf,GEN x);
GEN     nfsqri(GEN nf, GEN x);
GEN     nfsub(GEN nf, GEN x, GEN y);
GEN     nftrace(GEN nf, GEN x);
long    nfval(GEN nf, GEN x, GEN vp);
long    nfvalrem(GEN nf, GEN x, GEN pr, GEN *py);
GEN     polmod_nffix(const char *f, GEN rnf, GEN x,int lift);
GEN     polmod_nffix2(const char *f, GEN T, GEN R, GEN x, int lift);
GEN     pr_basis_perm(GEN nf, GEN pr);
int     pr_equal(GEN P, GEN Q);
GEN     rnfalgtobasis(GEN rnf, GEN x);
GEN     rnfbasistoalg(GEN rnf, GEN x);
GEN     rnfeltnorm(GEN rnf, GEN x);
GEN     rnfelttrace(GEN rnf, GEN x);
GEN     set_sign_mod_divisor(GEN nf, GEN x, GEN y, GEN sarch);
GEN     tablemul(GEN M, GEN x, GEN y);
GEN     tablemul_ei(GEN M, GEN x, long i);
GEN     tablemul_ei_ej(GEN M, long i, long j);
GEN     tablemulvec(GEN M, GEN x, GEN v);
GEN     tablesqr(GEN tab, GEN x);
GEN     vec01_to_indices(GEN arch);
GEN     vecsmall01_to_indices(GEN v);
GEN     zk_inv(GEN nf, GEN x);
GEN     zk_multable(GEN nf, GEN x);
GEN     zk_scalar_or_multable(GEN, GEN x);
GEN     zkchinese(GEN zkc, GEN x, GEN y);
GEN     zkchinese1(GEN zkc, GEN x);
GEN     zkchineseinit(GEN nf, GEN A, GEN B, GEN AB);
GEN     zkmultable_capZ(GEN mx);
GEN     zkmultable_inv(GEN mx);

/* base4.c */

ulong   Fl_invgen(ulong x, ulong p, ulong *pg);
GEN     Q_to_famat(GEN x);
GEN     RM_round_maxrank(GEN G);
GEN     ZM_famat_limit(GEN fa, GEN limit);
GEN     ZV_cba(GEN v);
GEN     ZV_cba_extend(GEN P, GEN b);
GEN     Z_cba(GEN a, GEN b);
GEN     Z_ppgle(GEN a, GEN b);
GEN     Z_ppio(GEN a, GEN b);
GEN     Z_ppo(GEN x, GEN f);
GEN     Z_to_famat(GEN x);
GEN     famatV_factorback(GEN v, GEN e);
GEN     famatV_zv_factorback(GEN v, GEN e);
GEN     famat_Z_gcd(GEN M, GEN n);
GEN     famat_div(GEN f, GEN g);
GEN     famat_div_shallow(GEN f, GEN g);
GEN     famat_idealfactor(GEN nf, GEN x);
GEN     famat_inv(GEN f);
GEN     famat_inv_shallow(GEN f);
GEN     famat_makecoprime(GEN nf, GEN g, GEN e, GEN pr, GEN prk, GEN EX);
GEN     famat_mul(GEN f, GEN g);
GEN     famat_mul_shallow(GEN f, GEN g);
GEN     famat_mulpow_shallow(GEN f, GEN g, GEN e);
GEN     famat_mulpows_shallow(GEN f, GEN g, long e);
GEN     famat_pow(GEN f, GEN n);
GEN     famat_pow_shallow(GEN f, GEN n);
GEN     famat_pows_shallow(GEN f, long n);
GEN     famat_reduce(GEN fa);
GEN     famat_remove_trivial(GEN fa);
GEN     famat_sqr(GEN f);
GEN     famat_to_nf(GEN nf, GEN f);
GEN     famat_to_nf_moddivisor(GEN nf, GEN g, GEN e, GEN bid);
GEN     famat_to_nf_modideal_coprime(GEN nf, GEN g, GEN e, GEN id, GEN EX);
GEN     famatsmall_reduce(GEN fa);
GEN     gpidealfactor(GEN nf, GEN x, GEN lim);
GEN     gpidealval(GEN nf, GEN ix, GEN P);
GEN     idealHNF_Z_factor(GEN x, GEN *pvN, GEN *pvZ);
GEN     idealHNF_Z_factor_i(GEN x, GEN f, GEN *pvN, GEN *pvZ);
GEN     idealHNF_inv(GEN nf, GEN id);
GEN     idealHNF_inv_Z(GEN nf, GEN id);
GEN     idealHNF_mul(GEN nf, GEN ix, GEN iy);
GEN     idealadd(GEN nf, GEN x, GEN y);
GEN     idealaddmultoone(GEN nf, GEN list);
GEN     idealaddtoone(GEN nf, GEN x, GEN y);
GEN     idealaddtoone0(GEN nf, GEN x, GEN y);
GEN     idealaddtoone_i(GEN nf, GEN x, GEN y);
GEN     idealaddtoone_raw(GEN nf, GEN x, GEN y);
GEN     idealappr(GEN nf, GEN x);
GEN     idealappr0(GEN nf, GEN x, long fl);
GEN     idealapprfact(GEN nf, GEN x);
GEN     idealchinese(GEN nf, GEN x, GEN y);
GEN     idealcoprime(GEN nf, GEN x, GEN y);
GEN     idealcoprimefact(GEN nf, GEN x, GEN fy);
GEN     idealdiv(GEN nf, GEN x, GEN y);
GEN     idealdiv0(GEN nf, GEN x, GEN y,long flag);
GEN     idealdivexact(GEN nf, GEN x, GEN y);
GEN     idealdivpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealdown(GEN nf, GEN x);
GEN     idealfactor(GEN nf, GEN x);
GEN     idealfactor_limit(GEN nf, GEN x, ulong lim);
GEN     idealfactor_partial(GEN nf, GEN x, GEN L);
GEN     idealhnf(GEN nf, GEN x);
GEN     idealhnf0(GEN nf, GEN a, GEN b);
GEN     idealhnf_principal(GEN nf, GEN x);
GEN     idealhnf_shallow(GEN nf, GEN x);
GEN     idealhnf_two(GEN nf, GEN vp);
GEN     idealintersect(GEN nf, GEN x, GEN y);
GEN     idealinv(GEN nf, GEN ix);
GEN     idealismaximal(GEN nf, GEN x);
long    idealispower(GEN nf, GEN A, long n, GEN *pB);
GEN     idealmin(GEN nf,GEN ix,GEN vdir);
GEN     idealmul(GEN nf, GEN ix, GEN iy);
GEN     idealmul0(GEN nf, GEN ix, GEN iy, long flag);
GEN     idealmulpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealmulred(GEN nf, GEN ix, GEN iy);
GEN     idealnorm(GEN nf, GEN x);
GEN     idealnumden(GEN nf, GEN x);
GEN     idealpow(GEN nf, GEN ix, GEN n);
GEN     idealpow0(GEN nf, GEN ix, GEN n, long flag);
GEN     idealpowred(GEN nf, GEN ix, GEN n);
GEN     idealpows(GEN nf, GEN ideal, long iexp);
GEN     idealprod(GEN nf, GEN id);
GEN     idealprodprime(GEN nf, GEN L);
long    idealprodval(GEN nf, GEN id, GEN pr);
GEN     idealpseudomin(GEN id, GEN G);
GEN     idealpseudomin_nonscalar(GEN id, GEN G);
GEN     idealpseudominvec(GEN id, GEN G);
GEN     idealpseudored(GEN id, GEN G);
GEN     idealred0(GEN nf, GEN id,GEN vdir);
GEN     idealred_elt(GEN nf, GEN id);
GEN     idealredmodpower(GEN nf, GEN x, ulong k, ulong B);
GEN     idealsqr(GEN nf, GEN x);
GEN     idealtwoelt(GEN nf, GEN ix);
GEN     idealtwoelt0(GEN nf, GEN ix, GEN a);
GEN     idealtwoelt2(GEN nf, GEN x, GEN a);
long    idealtyp(GEN *ideal, GEN *arch);
long    idealval(GEN nf,GEN ix,GEN vp);
long    isideal(GEN nf,GEN x);
GEN     matreduce(GEN fa);
GEN     nfC_multable_mul(GEN v, GEN x);
GEN     nfC_nf_mul(GEN nf, GEN v, GEN x);
GEN     nf_get_Gtwist(GEN nf, GEN vdir);
GEN     nf_get_Gtwist1(GEN nf, long i);
GEN     nf_to_Fp_coprime(GEN nf, GEN x, GEN modpr);
GEN     nfdetint(GEN nf,GEN pseudo);
GEN     nfdivmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     nfhnf(GEN nf, GEN x);
GEN     nfhnf0(GEN nf, GEN x, long flag);
GEN     nfhnfmod(GEN nf, GEN x, GEN d);
GEN     nfkermodpr(GEN nf, GEN x, GEN modpr);
GEN     nfmulmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     nfpowmodpr(GEN nf, GEN x, GEN k, GEN modpr);
GEN     nfreduce(GEN nf, GEN x, GEN ideal);
GEN     nfsnf(GEN nf, GEN x);
GEN     nfsnf0(GEN nf, GEN x, long flag);
GEN     nfsolvemodpr(GEN nf, GEN a, GEN b, GEN modpr);
GEN     nfweilheight(GEN nf, GEN v, long prec);
GEN     prV_lcm_capZ(GEN L);
GEN     prV_primes(GEN v);
GEN     pr_hnf(GEN nf, GEN pr);
GEN     pr_inv(GEN pr);
GEN     pr_inv_p(GEN pr);
GEN     pr_uniformizer(GEN pr, GEN F);
GEN     sunits_makecoprime(GEN X, GEN pr, GEN prk);
GEN     to_famat(GEN x, GEN y);
GEN     to_famat_shallow(GEN x, GEN y);
ulong   u_ppo(ulong x, ulong f);
GEN     vecdiv(GEN x, GEN y);
GEN     vecinv(GEN x);
GEN     vecmul(GEN x, GEN y);
GEN     vecsqr(GEN x);
GEN     vecpow(GEN x, GEN n);
GEN     vecsqr(GEN x);
GEN     zkC_multable_mul(GEN v, GEN x);

/* base5.c */

GEN     eltreltoabs(GEN rnfeq, GEN x);
GEN     eltabstorel(GEN eq, GEN P);
GEN     eltabstorel_lift(GEN rnfeq, GEN P);
GEN     nf_nfzk(GEN nf, GEN rnfeq);
GEN     rnf_build_nfabs(GEN rnf, long prec);
GEN     rnf_zkabs(GEN rnf);
GEN     nfeltup(GEN nf, GEN x, GEN zknf);
void    rnfcomplete(GEN rnf);
GEN     rnfeltabstorel(GEN rnf, GEN x);
GEN     rnfeltdown(GEN rnf, GEN x);
GEN     rnfeltdown0(GEN rnf, GEN x, long flag);
GEN     rnfeltreltoabs(GEN rnf, GEN x);
GEN     rnfeltup(GEN rnf, GEN x);
GEN     rnfeltup0(GEN rnf, GEN x, long flag);
GEN     rnfidealabstorel(GEN rnf, GEN x);
GEN     rnfidealdown(GEN rnf, GEN x);
GEN     rnfidealfactor(GEN rnf, GEN x);
GEN     rnfidealhnf(GEN rnf, GEN x);
GEN     rnfidealmul(GEN rnf,GEN x,GEN y);
GEN     rnfidealnormabs(GEN rnf, GEN x);
GEN     rnfidealnormrel(GEN rnf, GEN x);
GEN     rnfidealprimedec(GEN rnf, GEN pr);
GEN     rnfidealreltoabs(GEN rnf, GEN x);
GEN     rnfidealreltoabs0(GEN rnf, GEN x, long flag);
GEN     rnfidealtwoelement(GEN rnf,GEN x);
GEN     rnfidealup(GEN rnf, GEN x);
GEN     rnfidealup0(GEN rnf,GEN x, long flag);
GEN     rnfinit(GEN nf,GEN pol);
GEN     rnfinit0(GEN nf,GEN pol,long flag);

/* bb_group.c */

GEN     get_arith_ZZM(GEN o);
GEN     get_arith_Z(GEN o);
GEN     gen_PH_log(GEN a, GEN g, GEN ord, void *E, const struct bb_group *grp);
GEN     gen_Shanks_init(GEN g, long n, void *E, const struct bb_group *grp);
GEN     gen_Shanks(GEN T, GEN x, ulong N, void *E, const struct bb_group *grp);
GEN     gen_Shanks_sqrtn(GEN a, GEN n, GEN q, GEN *zetan, void *E, const struct bb_group *grp);
GEN     gen_gener(GEN o, void *E, const struct bb_group *grp);
GEN     gen_ellgens(GEN d1, GEN d2, GEN m, void *E, const struct bb_group *grp,
                     GEN pairorder(void *E, GEN P, GEN Q, GEN m, GEN F));
GEN     gen_ellgroup(GEN N, GEN F, GEN *pt_m, void *E, const struct bb_group *grp,
                     GEN pairorder(void *E, GEN P, GEN Q, GEN m, GEN F));
GEN     gen_factored_order(GEN a, GEN o, void *E, const struct bb_group *grp);
GEN     gen_order(GEN x, GEN o, void *E, const struct bb_group *grp);
GEN     gen_select_order(GEN o, void *E, const struct bb_group *grp);

GEN     gen_plog(GEN x,GEN g0,GEN q, void *E, const struct bb_group *grp);
GEN     gen_pow(GEN x, GEN n, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     gen_pow_fold(GEN x, GEN n, void *E, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     gen_pow_fold_i(GEN x, GEN n, void *E, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     gen_pow_i(GEN x, GEN n, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     gen_pow_init(GEN x, GEN n, long k, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     gen_pow_table(GEN R, GEN n, void *E, GEN (*one)(void*), GEN (*mul)(void*,GEN,GEN));
GEN     gen_powers(GEN x, long l, int use_sqr, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN), GEN (*one)(void*));
GEN     gen_powu(GEN x, ulong n, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     gen_powu_fold(GEN x, ulong n, void *E, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     gen_powu_fold_i(GEN x, ulong n, void *E, GEN  (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     gen_powu_i(GEN x, ulong n, void *E, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     gen_product(GEN x, void *data, GEN (*mul)(void*,GEN,GEN));

/* bb_hnf.c */

GEN     matdetmod(GEN A, GEN d);
GEN     matimagemod(GEN A, GEN d, GEN* U);
GEN     matinvmod(GEN A, GEN d);
GEN     matkermod(GEN A, GEN d, GEN* im);
GEN     matsolvemod(GEN M, GEN D, GEN Y, long flag);

/* bern.c */

GEN     bernfrac(long n);
GEN     bernpol(long k, long v);
GEN     bernpol_eval(long k, GEN x);
GEN     bernreal(long n, long prec);
GEN     bernvec(long nomb);
void    constbern(long n);
GEN     eulerfrac(long k);
GEN     eulerpol(long k, long v);
GEN     eulerreal(long n, long prec);
GEN     eulervec(long n);
GEN     harmonic(ulong n);
GEN     harmonic0(ulong n, GEN k);

/* bibli1.c */

int     QR_init(GEN x, GEN *pB, GEN *pQ, GEN *pL, long prec);
GEN     R_from_QR(GEN x, long prec);
GEN     RgM_Babai(GEN B, GEN t);
int     RgM_QR_init(GEN x, GEN *pB, GEN *pQ, GEN *pL, long prec);
GEN     RgM_gram_schmidt(GEN e, GEN *ptB);
GEN     algdep(GEN x, long n);
GEN     algdep0(GEN x, long n, long bit);
GEN     bestapprnf(GEN x, GEN T, GEN rootsT, long prec);
void    forqfvec(void *E, long (*fun)(void *, GEN, GEN, double), GEN a, GEN BORNE);
void    forqfvec0(GEN a, GEN BORNE, GEN code);
void    forqfvec1(void *E, long (*fun)(void *, GEN), GEN a, GEN BORNE);
GEN     gaussred_from_QR(GEN x, long prec);
GEN     lindep(GEN x);
GEN     lindep_Xadic(GEN x);
GEN     lindep_bit(GEN x, long bit);
GEN     lindep_padic(GEN x);
GEN     lindep0(GEN x, long flag);
GEN     lindep2(GEN x, long bit);
GEN     lindepfull_bit(GEN x, long bit);
GEN     mathouseholder(GEN Q, GEN v);
GEN     matqr(GEN x, long flag, long prec);
GEN     minim(GEN a, GEN borne, GEN stockmax);
GEN     minim_raw(GEN a, GEN borne, GEN stockmax);
GEN     minim_zm(GEN a, GEN borne, GEN stockmax);
GEN     minim2(GEN a, GEN borne, GEN stockmax);
GEN     qfcvp0(GEN a, GEN target, GEN borne, GEN stockmax,long flag);
GEN     qfminim0(GEN a, GEN borne, GEN stockmax,long flag, long prec);
GEN     qfperfection(GEN a);
GEN     qfrep0(GEN a, GEN borne, long flag);
GEN     seralgdep(GEN s, long p, long r);
GEN     serdiffdep(GEN s, long p, long r);
GEN     vandermondeinverse(GEN L, GEN T, GEN den, GEN prep);
GEN     vandermondeinverseinit(GEN L);
GEN     zncoppersmith(GEN P0, GEN N, GEN X, GEN B);

/* bibli2.c */

GEN     QXQ_reverse(GEN a, GEN T);
GEN     vec_equiv(GEN F);
GEN     RgV_polint(GEN X, GEN Y, long v);
GEN     vec_reduce(GEN v, GEN *pE);
GEN     RgXQ_reverse(GEN a, GEN T);
GEN     ZC_union_shallow(GEN x, GEN y);
GEN     ZM_merge_factor(GEN A, GEN B);
GEN     ZV_indexsort(GEN L);
long    ZV_search(GEN x, GEN y);
GEN     ZV_sort(GEN L);
void    ZV_sort_inplace(GEN L);
GEN     ZV_sort_shallow(GEN L);
GEN     ZV_sort_uniq(GEN L);
GEN     ZV_sort_uniq_shallow(GEN L);
GEN     ZV_union_shallow(GEN x, GEN y);
GEN     binomial(GEN x, long k);
GEN     binomial0(GEN x, GEN k);
GEN     binomialuu(ulong n, ulong k);
int     cmp_Flx(GEN x, GEN y);
int     cmp_RgX(GEN x, GEN y);
int     cmp_nodata(void *data, GEN x, GEN y);
int     cmp_prime_ideal(GEN x, GEN y);
int     cmp_prime_over_p(GEN x, GEN y);
int     cmp_universal(GEN x, GEN y);
GEN     convol(GEN x, GEN y);
int     gen_cmp_RgX(void *data, GEN x, GEN y);
GEN     polcyclo(long n, long v);
GEN     polcyclo_eval(long n, GEN x);
GEN     dirdiv(GEN x, GEN y);
GEN     dirmul(GEN x, GEN y);
GEN     eulerianpol(long N, long v);
GEN     gprec_wensure(GEN x, long pr);
GEN     gen_indexsort(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
GEN     gen_indexsort_uniq(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
long    gen_search(GEN x, GEN y, void *data, int (*cmp)(void*,GEN,GEN));
GEN     gen_setminus(GEN set1, GEN set2, int (*cmp)(GEN,GEN));
GEN     gen_sort(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
void    gen_sort_inplace(GEN x, void *E, int (*cmp)(void*,GEN,GEN), GEN *perm);
GEN     gen_sort_shallow(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
GEN     gen_sort_uniq(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
long    getstack(void);
long    gettime(void);
long    getabstime(void);
GEN     getwalltime(void);
GEN     gprec(GEN x, long l);
GEN     gprec_wtrunc(GEN x, long pr);
GEN     gprec_w(GEN x, long pr);
GEN     gtoset(GEN x);
GEN     indexlexsort(GEN x);
GEN     indexsort(GEN x);
GEN     indexvecsort(GEN x, GEN k);
GEN     laplace(GEN x);
GEN     lexsort(GEN x);
GEN     mathilbert(long n);
GEN     matqpascal(long n, GEN q);
GEN     merge_factor(GEN fx, GEN fy, void *data, int (*cmp)(void *,GEN,GEN));
GEN     merge_sort_uniq(GEN x, GEN y, void *data, int (*cmp)(void *,GEN,GEN));
GEN     modreverse(GEN x);
GEN     polhermite(long n, long v);
GEN     polhermite_eval0(long n, GEN x, long flag);
GEN     polhermite_eval(long n, GEN x);
GEN     pollaguerre(long n, GEN a, long v);
GEN     pollaguerre_eval(long n, GEN a, GEN x);
GEN     pollaguerre_eval0(long n, GEN a, GEN x, long flag);
GEN     pollegendre(long n, long v);
GEN     pollegendre_reduced(long n, long v);
GEN     pollegendre_eval(long n, GEN x);
GEN     pollegendre_eval0(long n, GEN x, long flag);
GEN     polint(GEN xa, GEN ya, GEN x, GEN *pe);
GEN     polint_i(GEN X, GEN Y, GEN t, long *pe);
GEN     polintspec(GEN xa, GEN ya, GEN x, long n, long *pe);
GEN     polchebyshev(long n, long kind, long v);
GEN     polchebyshev_eval(long n, long kind, GEN x);
GEN     polchebyshev1(long n, long v);
GEN     polchebyshev2(long n, long v);
GEN     polrecip(GEN x);
GEN     setbinop(GEN f, GEN x, GEN y);
GEN     setdelta(GEN x, GEN y);
GEN     setintersect(GEN x, GEN y);
long    setisset(GEN x);
GEN     setminus(GEN x, GEN y);
long    setsearch(GEN x, GEN y, long flag);
GEN     setunion(GEN x, GEN y);
GEN     setunion_i(GEN x, GEN y);
GEN     sort(GEN x);
GEN     sort_factor(GEN y, void *data, int (*cmp)(void*,GEN,GEN));
GEN     stirling(long n, long m, long flag);
GEN     stirling1(ulong n, ulong m);
GEN     stirling2(ulong n, ulong m);
long    tablesearch(GEN T, GEN x, int (*cmp)(GEN,GEN));
GEN     vecbinomial(long n);
long    vecsearch(GEN v, GEN x, GEN k);
GEN     vecsort(GEN x, GEN k);
GEN     vecsort0(GEN x, GEN k, long flag);
long    zv_search(GEN x, long y);

/* bit.c */

GEN     bits_to_int(GEN x, long l);
ulong   bits_to_u(GEN v, long l);
GEN     binaire(GEN x);
GEN     binary_2k(GEN x, long k);
GEN     binary_2k_nv(GEN x, long k);
GEN     binary_zv(GEN x);
void    bitclear(GEN x, long n);
void    bitflip(GEN x, long n);
void    bitset(GEN x, long n);
long    bittest(GEN x, long n);
GEN     fromdigits_2k(GEN x, long k);
GEN     gbitand(GEN x, GEN y);
GEN     gbitneg(GEN x, long n);
GEN     gbitnegimply(GEN x, GEN y);
GEN     gbitor(GEN x, GEN y);
GEN     gbittest(GEN x, long n);
GEN     gbitxor(GEN x, GEN y);
long    hammingweight(GEN n);
GEN     ibitand(GEN x, GEN y);
GEN     ibitnegimply(GEN x, GEN y);
GEN     ibitor(GEN x, GEN y);
GEN     ibitxor(GEN x, GEN y);
GEN     nv_fromdigits_2k(GEN x, long k);

/* bnflog.c */

GEN     bnflogef(GEN bnf, GEN pr);
GEN     bnflog(GEN bnf, GEN l);
GEN     bnflogdegree(GEN bnf, GEN A, GEN ell);
long    nfislocalpower(GEN nf, GEN pr, GEN a, GEN n);
long    rnfislocalcyclo(GEN rnf);

/* bnfunits.c */

GEN     bnfisunit(GEN bnf, GEN x);
GEN     bnfissunit(GEN bnf,GEN suni,GEN x);
GEN     bnfsunit(GEN bnf,GEN s,long PREC);
GEN     bnfunits(GEN bnf, GEN S);
GEN     bnfisunit0(GEN bnf, GEN x, GEN U);
GEN     sunits_mod_units(GEN bnf, GEN S);

/* buch1.c */

GEN     Buchquad(GEN D, double c1, double c2, long prec);
GEN     quadclassno(GEN x);
long    quadclassnos(long x);
GEN     quadclassunit0(GEN x, long flag,GEN data, long prec);

/* buch2.c */

GEN     Buchall(GEN P, long flag, long prec);
GEN     Buchall_param(GEN P, double bach, double bach2, long nbrelpid, long max_fact, long idex, long nbthr, long flun, long prec);
GEN     bnf_build_cheapfu(GEN bnf);
GEN     bnf_build_cycgen(GEN bnf);
GEN     bnf_build_matalpha(GEN bnf);
GEN     bnf_build_units(GEN bnf);
GEN     bnf_compactfu(GEN bnf);
GEN     bnf_compactfu_mat(GEN bnf);
GEN     bnf_has_fu(GEN bnf);
GEN     bnfinit0(GEN P,long flag,GEN data,long prec);
GEN     bnfisprincipal0(GEN bnf, GEN x,long flall);
GEN     bnfnewprec(GEN nf, long prec);
GEN     bnfnewprec_shallow(GEN nf, long prec);
void    bnftestprimes(GEN bnf, GEN bound);
GEN     bnrnewprec(GEN bnr, long prec);
GEN     bnrnewprec_shallow(GEN bnr, long prec);
GEN     isprincipalfact(GEN bnf, GEN C, GEN L, GEN f, long flag);
GEN     isprincipalfact_or_fail(GEN bnf, GEN C, GEN P, GEN e);
GEN     isprincipal(GEN bnf, GEN x);
GEN     nf_cxlog_normalize(GEN nf, GEN x, long prec);
GEN     nfcyclotomicunits(GEN nf, GEN zu);
GEN     nfsign_units(GEN bnf, GEN archp, int add_zu);
GEN     nfsign_tu(GEN bnf, GEN archp);
GEN     nfsign_fu(GEN bnf, GEN archp);
GEN     signunits(GEN bnf);

/* buch3.c */

GEN     abmap_char_image(GEN S, GEN chi);
GEN     abmap_nchar_image(GEN S, GEN nchi);
GEN     Hermite_bound(long n, long prec);
void    bnr_subgroup_sanitize(GEN *pbnr, GEN *pH);
void    bnr_char_sanitize(GEN *pbnr, GEN *pchi);
void    bnr_vecchar_sanitize(GEN *pbnr, GEN *pCHI);
GEN     bnrtoprimitive(GEN bnr, GEN H, GEN mod);
GEN     ABC_to_bnr(GEN A, GEN B, GEN C, GEN *H, int gen);
GEN     Buchray(GEN bnf, GEN module, long flag);
GEN     Buchraymod(GEN bnf, GEN f, long flag, GEN MOD);
GEN     bnrautmatrix(GEN bnr, GEN aut);
GEN     bnr_subgroup_check(GEN bnr, GEN H, GEN *pdeg);
GEN     bnrchar(GEN bnr, GEN g, GEN v);
GEN     bnrclassno(GEN bnf,GEN ideal);
GEN     bnrclassno0(GEN A,GEN B,GEN C);
GEN     bnrclassnolist(GEN bnf,GEN listes);
GEN     bnrconductor_factored(GEN bnr, GEN H);
GEN     bnrconductor_factored_arch(GEN bnr, GEN H, GEN *parch);
GEN     bnrconductor_raw(GEN bnr, GEN H);
GEN     bnrconductor0(GEN A, GEN B, GEN C, long flag);
GEN     bnrconductor(GEN bnr, GEN H0, long flag);
GEN     bnrconductorofchar(GEN bnr,GEN chi);
GEN     bnrdisc0(GEN A, GEN B, GEN C, long flag);
GEN     bnrdisc(GEN bnr, GEN H, long flag);
GEN     bnrdisclist0(GEN bnf,GEN borne, GEN arch);
GEN     bnrgaloismatrix(GEN bnr, GEN aut);
GEN     bnrgaloisapply(GEN bnr, GEN mat, GEN x);
GEN     bnrinit0(GEN bnf,GEN ideal,long flag);
GEN     bnrinitmod(GEN bnf, GEN ideal, long flag, GEN MOD);
long    bnrisconductor0(GEN A, GEN B, GEN C);
long    bnrisconductor(GEN bnr, GEN H);
long    bnrisgalois(GEN bnr, GEN M, GEN H);
GEN     bnrisprincipalmod(GEN bnf, GEN x, GEN mod, long flag);
GEN     bnrisprincipal(GEN bnf, GEN x,long flag);
GEN     bnrmap(GEN A, GEN B);
GEN     bnrsurjection(GEN bnr1, GEN bnr2);
GEN     bnfnarrow(GEN bnf);
long    bnfcertify(GEN bnf);
long    bnfcertify0(GEN bnf, long flag);
GEN     bnrcompositum(GEN fH1, GEN fH2);
GEN     decodemodule(GEN nf, GEN fa);
GEN     discrayabslist(GEN bnf,GEN listes);
GEN     discrayabslistarch(GEN bnf, GEN arch, ulong bound);
GEN     idealmoddivisor(GEN bnr, GEN x);
GEN     isprincipalray(GEN bnf, GEN x);
GEN     isprincipalraygen(GEN bnf, GEN x);
GEN     nf_deg1_prime(GEN nf);
GEN     nfarchstar(GEN nf,GEN x,GEN arch);
GEN     rnfconductor(GEN bnf, GEN polrel);
GEN     rnfconductor0(GEN bnf, GEN T, long flag);
GEN     rnfnormgroup(GEN bnr, GEN polrel);
GEN     subgrouplist0(GEN bnr, GEN indexbound, long all);

/* buch4.c */

GEN     bnfisnorm(GEN bnf,GEN x,long flag);
GEN     rnfisnorm(GEN S, GEN x, long flag);
GEN     rnfisnorminit(GEN bnf, GEN R, long galois);

/* char.c */

GEN     coprimes_zv(ulong N);
int     char_check(GEN cyc, GEN chi);
GEN     charconj(GEN cyc, GEN chi);
GEN     charconj0(GEN cyc, GEN chi);
GEN     chardiv(GEN x, GEN a, GEN b);
GEN     chardiv0(GEN x, GEN a, GEN b);
GEN     chareval(GEN G, GEN chi, GEN n, GEN z);
GEN     chargalois(GEN G, GEN ORD);
GEN     charker(GEN cyc, GEN chi);
GEN     charker0(GEN cyc, GEN chi);
GEN     charmul(GEN x, GEN a, GEN b);
GEN     charmul0(GEN x, GEN a, GEN b);
GEN     charorder(GEN cyc, GEN x);
GEN     charorder0(GEN x, GEN chi);
GEN     charpow(GEN cyc, GEN a, GEN N);
GEN     charpow0(GEN x, GEN a, GEN N);
GEN     char_denormalize(GEN cyc, GEN D, GEN chic);
GEN     char_normalize(GEN chi, GEN ncyc);
GEN     char_simplify(GEN D, GEN C);
int     checkznstar_i(GEN G);
GEN     cyc_normalize(GEN c);
GEN     ncharvecexpo(GEN G, GEN nchi);
GEN     znchar(GEN D);
GEN     znchar_quad(GEN G, GEN D);
int     zncharcheck(GEN G, GEN chi);
GEN     zncharconductor(GEN G, GEN chi);
GEN     zncharconj(GEN G, GEN chi);
GEN     znchardecompose(GEN G, GEN chi, GEN Q);
GEN     znchardiv(GEN G, GEN a, GEN b);
GEN     znchareval(GEN G, GEN chi, GEN n, GEN z);
GEN     zncharinduce(GEN G, GEN chi, GEN N);
long    zncharisodd(GEN G, GEN chi);
GEN     zncharker(GEN G, GEN chi);
GEN     zncharmul(GEN G, GEN a, GEN b);
GEN     zncharorder(GEN G,  GEN chi);
GEN     zncharpow(GEN G, GEN a, GEN n);
GEN     znchartokronecker(GEN G, GEN chi, long flag);
GEN     znchartoprimitive(GEN G, GEN chi);
int     znconrey_check(GEN cyc, GEN chi);
GEN     znconrey_normalized(GEN G, GEN chi);
GEN     znconreychar(GEN bid, GEN m);
GEN     znconreyfromchar_normalized(GEN bid, GEN chi);
GEN     znconreyconductor(GEN bid, GEN co, GEN *pm);
GEN     znconreyexp(GEN bid, GEN x);
GEN     znconreyfromchar(GEN bid, GEN chi);
GEN     znconreylog(GEN bid, GEN x);
GEN     znconreylog_normalize(GEN G, GEN m);
GEN     znlog0(GEN h, GEN g, GEN o);
long    zv_cyc_minimal(GEN cyc, GEN g, GEN coprime);
long    zv_cyc_minimize(GEN cyc, GEN g, GEN coprime);

/* compile.c */

GEN     closure_deriv(GEN G);
GEN     closure_derivn(GEN G, long k);
GEN     closuretoinl(GEN C);
long    localvars_find(GEN pack, entree *ep);
GEN     localvars_read_str(const char *str, GEN pack);
GEN     snm_closure(entree *ep, GEN data);
GEN     strtoclosure(const char *s, long n, ...);
GEN     strtofunction(const char *s);

/* concat.c */

GEN     gconcat(GEN x, GEN y);
GEN     gconcat1(GEN x);
GEN     matconcat(GEN v);
GEN     shallowconcat(GEN x, GEN y);
GEN     shallowconcat1(GEN x);
GEN     shallowmatconcat(GEN v);
GEN     vconcat(GEN A, GEN B);

/* default.c */
enum { d_SILENT = 0, d_ACKNOWLEDGE, d_INITRC, d_RETURN };

GEN     default0(const char *a, const char *b);
long    getrealprecision(void);
entree *pari_is_default(const char *s);
GEN     sd_TeXstyle(const char *v, long flag);
GEN     sd_colors(const char *v, long flag);
GEN     sd_compatible(const char *v, long flag);
GEN     sd_datadir(const char *v, long flag);
GEN     sd_debug(const char *v, long flag);
GEN     sd_debugfiles(const char *v, long flag);
GEN     sd_debugmem(const char *v, long flag);
GEN     sd_doctest(const char *v, long flag);
GEN     sd_factor_add_primes(const char *v, long flag);
GEN     sd_factor_proven(const char *v, long flag);
GEN     sd_factorlimit(const char *v, long flag);
GEN     sd_format(const char *v, long flag);
GEN     sd_histsize(const char *v, long flag);
GEN     sd_log(const char *v, long flag);
GEN     sd_logfile(const char *v, long flag);
GEN     sd_nbthreads(const char *v, long flag);
GEN     sd_new_galois_format(const char *v, long flag);
GEN     sd_output(const char *v, long flag);
GEN     sd_parisize(const char *v, long flag);
GEN     sd_parisizemax(const char *v, long flag);
GEN     sd_path(const char *v, long flag);
GEN     sd_plothsizes(const char *v, long flag);
GEN     sd_prettyprinter(const char *v, long flag);
GEN     sd_primelimit(const char *v, long flag);
GEN     sd_realbitprecision(const char *v, long flag);
GEN     sd_realprecision(const char *v, long flag);
GEN     sd_secure(const char *v, long flag);
GEN     sd_seriesprecision(const char *v, long flag);
GEN     sd_simplify(const char *v, long flag);
GEN     sd_sopath(char *v, int flag);
GEN     sd_strictargs(const char *v, long flag);
GEN     sd_strictmatch(const char *v, long flag);
GEN     sd_string(const char *v, long flag, const char *s, char **f);
GEN     sd_threadsize(const char *v, long flag);
GEN     sd_threadsizemax(const char *v, long flag);
GEN     sd_intarray(const char *v, long flag, GEN *pz, const char *s);
GEN     sd_toggle(const char *v, long flag, const char *s, int *ptn);
GEN     sd_ulong(const char *v, long flag, const char *s, ulong *ptn, ulong Min, ulong Max, const char **msg);
GEN     setdefault(const char *s, const char *v, long flag);
long    setrealprecision(long n, long *prec);

/* digits.c */
GEN     digits(GEN N, GEN B);
GEN     fromdigits(GEN x, GEN B);
GEN     fromdigitsu(GEN x, GEN B);
GEN     gen_digits(GEN x, GEN B, long n, void *E, struct bb_ring *r,
                          GEN (*div)(void *E, GEN x, GEN y, GEN *r));
GEN     gen_fromdigits(GEN x, GEN B, void *E, struct bb_ring *r);
GEN     sumdigits(GEN n);
GEN     sumdigits0(GEN n, GEN B);
ulong   sumdigitsu(ulong n);

/* ecpp.c */

GEN     ecpp(GEN N);
GEN     ecpp0(GEN N, long stopat);
GEN     ecppexport(GEN cert, long flag);
long    ecppisvalid(GEN cert);
long    isprimeECPP(GEN N);

/* gplib.c */

GEN     sd_breakloop(const char *v, long flag);
GEN     sd_echo(const char *v, long flag);
GEN     sd_graphcolormap(const char *v, long flag);
GEN     sd_graphcolors(const char *v, long flag);
GEN     sd_help(const char *v, long flag);
GEN     sd_histfile(const char *v, long flag);
GEN     sd_lines(const char *v, long flag);
GEN     sd_linewrap(const char *v, long flag);
GEN     sd_prompt(const char *v, long flag);
GEN     sd_prompt_cont(const char *v, long flag);
GEN     sd_psfile(const char *v, long flag);
GEN     sd_readline(const char *v, long flag);
GEN     sd_recover(const char *v, long flag);
GEN     sd_timer(const char *v, long flag);
void    pari_hit_return(void);
void    gp_display_hist(long n);
void    str_display_hist(pari_str *S, long n);
void    gp_load_gprc(void);
int     gp_meta(const char *buf, int ismain);
const char **gphelp_keyword_list(void);
void    pari_breakpoint(void);
void    pari_center(const char *s);
long    pari_community(void);
void    pari_print_version(void);
const char *gp_format_time(long delay);
const char *gp_format_prompt(const char *p);
void    pari_alarm(long s);
GEN     gp_alarm(long s, GEN code);
GEN     gp_input(void);
void    gp_allocatemem(GEN z);
int     gp_handle_exception(long numerr);
void    gp_alarm_handler(int sig);
void    gp_sigint_fun(void);
enum { h_REGULAR=0, h_LONG=1, h_APROPOS=2, h_RL=4 };
void    gp_help(const char *s, long flag);
void    gp_echo_and_log(const char *prompt, const char *s);
void    print_fun_list(char **list, long nbli);
GEN     strtime(long t);

/* dirichlet.c */

GEN     direuler(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, GEN c);
GEN     dirpowers(long n, GEN x, long prec);
GEN     dirpowerssum(ulong N, GEN s, long both, long prec);
GEN     dirpowerssum0(GEN N, GEN s, GEN f, long both, long prec);
GEN     dirpowerssumfun(ulong N, GEN s, void *E, GEN (*f)(void *,ulong,long), long both, long prec);
GEN     pardirpowerssumfun(GEN f, ulong N, GEN s, long both, long prec);
GEN     pardirpowerssum(ulong N, GEN s, long prec);
GEN     pardirpowerssum0(GEN N, GEN s, GEN f, long both, long prec);
GEN     vecpowuu(long N, ulong B);
GEN     vecpowug(long N, GEN B, long prec);

/* ellanal.c */

GEN     ellanalyticrank(GEN e, GEN eps, long prec);
GEN     ellanal_globalred_all(GEN e, GEN *N, GEN *cb, GEN *tam);
GEN     ellheegner(GEN e);
GEN     ellL1(GEN E, long r, long prec);

/* elldata.c */

GEN     ellconvertname(GEN s);
GEN     elldatagenerators(GEN E);
GEN     ellidentify(GEN E);
GEN     ellsearch(GEN A);
GEN     ellsearchcurve(GEN name);
void    forell(void *E, long call(void*, GEN), long a, long b, long flag);
void    forell0(long a, long b, GEN code, long flag);

/* ellfromeqn.c */

GEN     ellfromeqn(GEN s);
GEN     ellfromeqn0(GEN s, GEN p);

/* elliptic.c */

enum { t_ELL_Rg = 0, t_ELL_Q, t_ELL_Qp, t_ELL_Fp, t_ELL_Fq, t_ELL_NF };
GEN     akell(GEN e, GEN n);
GEN     bilhell(GEN e, GEN z1, GEN z2, long prec);
void    checkell(GEN e);
void    checkell_Fq(GEN e);
void    checkell_Q(GEN e);
void    checkell_Qp(GEN e);
void    checkellisog(GEN v);
void    checkellpt(GEN z);
int     checkellpt_i(GEN z);
void    checkell5(GEN e);
GEN     ec_2divpol_evalx(GEN E, GEN x);
GEN     ec_3divpol_evalx(GEN E, GEN x);
GEN     ec_bmodel(GEN e, long v);
GEN     ec_f_evalx(GEN E, GEN x);
GEN     ec_h_evalx(GEN e, GEN x);
GEN     ec_dFdx_evalQ(GEN E, GEN Q);
GEN     ec_dFdy_evalQ(GEN E, GEN Q);
GEN     ec_dmFdy_evalQ(GEN e, GEN Q);
GEN     ec_half_deriv_2divpol(GEN E, long vx);
GEN     ec_half_deriv_2divpol_evalx(GEN E, GEN x);
GEN     ec_phi2(GEN e, long v);
int     ell_is_integral(GEN E);
long    ellQ_get_CM(GEN e);
GEN     ellQ_get_N(GEN e);
void    ellQ_get_Nfa(GEN e, GEN *N, GEN *faN);
GEN     ellQp_Tate_uniformization(GEN E, long prec);
GEN     ellQp_AGM(GEN E, long prec);
GEN     ellQp_u(GEN E, long prec);
GEN     ellQp_u2(GEN E, long prec);
GEN     ellQp_q(GEN E, long prec);
GEN     ellQp_ab(GEN E, long prec);
GEN     ellQp_L(GEN E, long prec);
GEN     ellQp_root(GEN E, long prec);
GEN     ellQtwist_bsdperiod(GEN E, long s);
GEN     ellR_area(GEN E, long prec);
GEN     ellR_ab(GEN E, long prec);
GEN     ellR_roots(GEN E, long prec);
GEN     elladd(GEN e, GEN z1, GEN z2);
GEN     ellan(GEN e, long n);
GEN     ellanQ_zv(GEN e, long n);
GEN     ellanal_globalred(GEN e, GEN *gr);
GEN     ellap(GEN e, GEN p);
long    ellap_CM_fast(GEN E, ulong p, long CM);
GEN     ellbasechar(GEN E);
GEN     ellbsd(GEN e, long prec);
GEN     ellcard(GEN E, GEN p);
GEN     ellchangecompose(GEN E, GEN v, GEN w);
GEN     ellchangecurve(GEN e, GEN ch);
GEN     ellchangeinvert(GEN E, GEN w);
GEN     ellchangepoint0(GEN E, GEN x, GEN ch);
GEN     ellchangepoint(GEN x, GEN ch);
GEN     ellchangepointinv0(GEN E, GEN x, GEN ch);
GEN     ellchangepointinv(GEN x, GEN ch);
GEN     ellcharpoly(GEN E, GEN p);
GEN     elldivpol(GEN e, long n, long v);
GEN     elleulerf(GEN e, GEN p);
GEN     ellff_get_card(GEN E);
GEN     ellff_get_gens(GEN E);
GEN     ellff_get_group(GEN E);
GEN     ellff_get_o(GEN x);
GEN     ellff_get_p(GEN E);
GEN     ellff_get_m(GEN E);
GEN     ellff_get_D(GEN E);
GEN     ellfromj(GEN j);
GEN     ellgenerators(GEN E);
GEN     ellglobalred(GEN e1);
GEN     ellgroup(GEN E, GEN p);
GEN     ellgroup0(GEN E, GEN p, long flag);
GEN     ellheight0(GEN e, GEN a, GEN b, long prec);
GEN     ellheight(GEN e, GEN a, long prec);
GEN     ellheightmatrix(GEN E, GEN x, long n);
GEN     ellheightoo(GEN e, GEN z, long prec);
GEN     ellinit(GEN x, GEN p, long prec);
GEN     ellintegralmodel(GEN e, GEN *pv);
GEN     ellintegralmodel_i(GEN e, GEN *pv);
long    elliscm(GEN e);
GEN     ellisisom(GEN e, GEN f);
GEN     ellisoncurve(GEN e, GEN z);
GEN     ellisotree(GEN e);
int     ellissupersingular(GEN x, GEN p);
int     elljissupersingular(GEN x);
GEN     elllseries(GEN e, GEN s, GEN A, long prec);
GEN     elllocalred(GEN e, GEN p1);
GEN     elllog(GEN e, GEN a, GEN g, GEN o);
GEN     ellminimaldisc(GEN E);
GEN     ellminimalmodel(GEN E, GEN *ptv);
GEN     ellminimaltwist(GEN e);
GEN     ellminimaltwist0(GEN e, long fl);
GEN     ellminimaltwistcond(GEN e);
GEN     ellmul(GEN e, GEN z, GEN n);
GEN     ellnf_vecarea(GEN E, long prec);
GEN     ellnf_veceta(GEN E, long prec);
GEN     ellnf_vecomega(GEN E, long prec);
GEN     ellneg(GEN e, GEN z);
GEN     ellorder(GEN e, GEN p, GEN o);
long    ellorder_Q(GEN E, GEN P);
GEN     ellordinate(GEN e, GEN x, long prec);
GEN     ellpadicheight0(GEN e, GEN p, long n, GEN P, GEN Q);
GEN     ellpadicheightmatrix(GEN e, GEN p, long n, GEN P);
GEN     ellrandom(GEN e);
long    ellrootno(GEN e, GEN p);
long    ellrootno_global(GEN e);
GEN     ellsaturation(GEN E, GEN P, long B, long prec);
GEN     ellsea(GEN E, long smallfact);
GEN     ellsigma(GEN om, GEN z, long flag, long prec);
GEN     ellsub(GEN e, GEN z1, GEN z2);
GEN     ellsupersingularj(GEN a);
GEN     elltamagawa(GEN e);
GEN     elltaniyama(GEN e, long prec);
GEN     elltatepairing(GEN E, GEN t, GEN s, GEN m);
GEN     elltors(GEN e);
GEN     elltors0(GEN e, long flag);
GEN     elltors_psylow(GEN e, ulong p);
GEN     elltrace(GEN e, GEN P);
GEN     elltwist(GEN E, GEN D);
GEN     ellweilpairing(GEN E, GEN t, GEN s, GEN m);
GEN     ellxn(GEN e, long n, long v);
int     ellisoncurve_i(GEN e, GEN z);
GEN     orderell(GEN e, GEN p);
GEN     point_to_a4a6(GEN E, GEN P, GEN p, GEN *pa4);
GEN     point_to_a4a6_Fl(GEN E, GEN P, ulong p, ulong *pa4);

/* ellpadic.c */

GEN     Qp_agm2_sequence(GEN a1, GEN b1);
void    Qp_ascending_Landen(GEN AB, GEN *ptx, GEN *pty);
void    Qp_descending_Landen(GEN AB, GEN *ptx, GEN *pty);
GEN     ellformaldifferential(GEN e, long n, long v);
GEN     ellformalexp(GEN e, long n, long v);
GEN     ellformallog(GEN e, long n, long v);
GEN     ellformalpoint(GEN e, long n, long v);
GEN     ellformalw(GEN e, long n, long v);
GEN     ellnonsingularmultiple(GEN e, GEN P);
GEN     ellpadicL(GEN E, GEN p, long n, GEN s, long r, GEN D);
GEN     ellpadicbsd(GEN E, GEN p, long n, GEN D);
GEN     ellpadicfrobenius(GEN E, ulong p, long n);
GEN     ellpadicheight(GEN e, GEN p, long n, GEN P);
GEN     ellpadiclog(GEN E, GEN p, long n, GEN P);
GEN     ellpadicregulator(GEN E, GEN p, long n, GEN S);
GEN     ellpadics2(GEN E, GEN p, long n);

/* ellrank.c*/

GEN     ell2cover(GEN ell, long prec);
GEN     ellrank(GEN ell, long effort, GEN help, long prec);
GEN     ellrankinit(GEN ell, long prec);
long    hyperell_locally_soluble(GEN pol,GEN p);
long    nf_hyperell_locally_soluble(GEN nf,GEN pol,GEN p);
long    nfhilbert(GEN bnf,GEN a,GEN b);
long    nfhilbert0(GEN bnf,GEN a,GEN b,GEN p);

/* elltors.c */

long    ellisdivisible(GEN E, GEN P, GEN n, GEN *Q);

/* elltrans.c */

GEN     cxEk(GEN tau, long k, long prec);
GEN     cxredsl2(GEN t, GEN *U);
GEN     cxredsl2_i(GEN z, GEN *pU, GEN *czd);
GEN     ellR_eta(GEN E, long prec);
GEN     ellR_omega(GEN x, long prec);
GEN     elleisnum(GEN om, long k, long prec);
GEN     elleisnum0(GEN om, GEN k, long prec);
GEN     elleta(GEN om, long prec);
GEN     elljacobi(GEN z, GEN k, long prec);
GEN     ellperiods(GEN w, long flag, long prec);
GEN     ellwp(GEN w, GEN z, long prec);
GEN     ellwp0(GEN w, GEN z, long flag, long prec);
GEN     ellwpseries(GEN e, long v, long PRECDL);
GEN     ellzeta(GEN om, GEN z, long prec);
GEN     expIPiQ(GEN z, long prec);
GEN     expIPiR(GEN x, long prec);
GEN     expIPiC(GEN z, long prec);
GEN     expIxy(GEN x, GEN y, long prec);
GEN     eta(GEN x, long prec);
GEN     eta0(GEN x, long flag,long prec);
GEN     jell(GEN x, long prec);
GEN     pointell(GEN e, GEN z, long prec);
GEN     sumdedekind(GEN h, GEN k);
GEN     sumdedekind_coprime(GEN h, GEN k);
GEN     theta(GEN z, GEN tau, GEN flag, long prec);
GEN     thetanull(GEN tau, GEN flag, long prec);
GEN     thetanullk(GEN q, long k, long prec);
GEN     trueeta(GEN x, long prec);
GEN     u_sumdedekind_coprime(long h, long k);
GEN     upper_to_cx(GEN x, long *prec);
GEN     vecthetanullk(GEN q, long k, long prec);
GEN     vecthetanullk_tau(GEN tau, long k, long prec);
GEN     weber0(GEN x, long flag,long prec);
GEN     weberf(GEN x, long prec);
GEN     weberf1(GEN x, long prec);
GEN     weberf2(GEN x, long prec);
GEN     zell(GEN e, GEN z, long prec);

/* ellisog.c */

GEN     ellisogenyapply(GEN f, GEN P);
GEN     ellisogeny(GEN e, GEN G, long only_image, long vx, long vy);
GEN     ellisomat(GEN E, long p, long flag);
GEN     ellmaninconstant(GEN E, long flag);
GEN     ellweilcurve(GEN E, GEN *pm);

/* ellsea.c */

GEN     Flxq_elldivpolmod(GEN a4, GEN a6, long n, GEN h, GEN T, ulong p);
GEN     Fp_ellcard_SEA(GEN a4, GEN a6, GEN p, long smallfact);
GEN     Fq_ellcard_SEA(GEN a4, GEN a6, GEN q, GEN T, GEN p, long smallfact);
GEN     Fq_elldivpolmod(GEN a4, GEN a6, long n, GEN h, GEN T, GEN p);
GEN     ellmodulareqn(long l, long vx, long vy);

/* es.c */

GEN     externstr(const char *cmd);
char    *gp_filter(const char *s);
GEN     gpextern(const char *cmd);
long    gpsystem(const char *s);
void    gpwritebin(const char *s, GEN x);
GEN     readstr(const char *s);
GEN     GENtoGENstr_nospace(GEN x);
GEN     GENtoGENstr(GEN x);
char*   GENtoTeXstr(GEN x);
char*   GENtostr(GEN x);
char*   GENtostr_raw(GEN x);
char*   GENtostr_unquoted(GEN x);
GEN     Str(GEN g);
GEN     strexpand(GEN g);
GEN     strtex(GEN g);
void    brute(GEN g, char format, long dec);
void    dbgGEN(GEN x, long nb);
void    error0(GEN g);
void    dbg_pari_heap(void);
int     file_is_binary(FILE *f);
void    err_flush(void);
void    err_printf(const char* pat, ...);
long    gp_embedded(const char *s);
void    gp_embedded_init(long rsize, long vsize);
void    gp_fileclose(long n);
long    gp_fileextern(const char *s, const char *mode);
void    gp_fileflush(long n);
void    gp_fileflush0(GEN n);
long    gp_fileopen(const char *s, const char *mode);
GEN     gp_fileread(long n);
GEN     gp_filereadstr(long n);
void    gp_filewrite(long n, const char *s);
void    gp_filewrite1(long n, const char *s);
GEN     gp_getenv(const char *s);
GEN     gp_read_file(const char *s);
GEN     gp_read_str_multiline(const char *s, char *last);
GEN     gp_read_stream(FILE *f);
GEN     gp_readvec_file(const char *s);
GEN     gp_readvec_stream(FILE *f);
void    gpinstall(const char *s, const char *code,
                  const char *gpname, const char *lib);
GEN     gsprintf(const char *fmt, ...);
GEN     gvsprintf(const char *fmt, va_list ap);
char*   itostr(GEN x);
void    matbrute(GEN g, char format, long dec);
char*   os_getenv(const char *s);
char*   uordinal(ulong i);
void    outmat(GEN x);
void    output(GEN x);
char*   RgV_to_str(GEN g, long flag);
void    pari_add_hist(GEN z, long t, long r);
void    pari_ask_confirm(const char *s);
void    pari_fclose(pariFILE *f);
void    pari_flush(void);
pariFILE* pari_fopen(const char *s, const char *mode);
pariFILE* pari_fopen_or_fail(const char *s, const char *mode);
pariFILE* pari_fopengz(const char *s);
void    pari_fprintf(FILE *file, const char *fmt, ...);
void    pari_fread_chars(void *b, size_t n, FILE *f);
GEN     pari_get_hist(long p);
long    pari_get_histrtime(long p);
long    pari_get_histtime(long p);
char*   pari_get_homedir(const char *user);
GEN     pari_histtime(long p);
int     pari_is_dir(const char *name);
int     pari_is_file(const char *name);
int     pari_last_was_newline(void);
void    pari_set_last_newline(int last);
ulong   pari_nb_hist(void);
void    pari_printf(const char *fmt, ...);
void    pari_putc(char c);
void    pari_puts(const char *s);
pariFILE* pari_safefopen(const char *s, const char *mode);
char*   pari_sprintf(const char *fmt, ...);
int     pari_stdin_isatty(void);
char*   pari_unique_dir(const char *s);
char*   pari_unique_filename(const char *s);
char*   pari_unique_filename_suffix(const char *s, const char *suf);
void    pari_unlink(const char *s);
void    pari_vfprintf(FILE *file, const char *fmt, va_list ap);
void    pari_vprintf(const char *fmt, va_list ap);
char*   pari_vsprintf(const char *fmt, va_list ap);
char*   path_expand(const char *s);
void    out_print0(PariOUT *out, const char *sep, GEN g, long flag);
void    out_print1(PariOUT *out, const char *sep, GEN g, long flag);
void    out_printf(PariOUT *out, const char *fmt, ...);
void    out_putc(PariOUT *out, char c);
void    out_puts(PariOUT *out, const char *s);
void    out_term_color(PariOUT *out, long c);
void    out_vprintf(PariOUT *out, const char *fmt, va_list ap);
char*   pari_sprint0(const char *msg, GEN g, long flag);
void    print(GEN g);
void    printp(GEN g);
enum { f_RAW = 0, f_PRETTYMAT = 1, f_PRETTY = 3, f_TEX = 4 };
void    print1(GEN g);
void    printf0(const char *fmt, GEN args);
void    printsep(const char *s, GEN g);
void    printsep1(const char *s, GEN g);
void    printtex(GEN g);
char*   stack_sprintf(const char *fmt, ...);
void    str_init(pari_str *S, int use_stack);
void    str_printf(pari_str *S, const char *fmt, ...);
void    str_putc(pari_str *S, char c);
void    str_puts(pari_str *S, const char *s);
void    strftime_expand(const char *s, char *buf, long max);
GEN     strprintf(const char *fmt, GEN args);
FILE*   switchin(const char *name);
void    switchout(const char *name);
void    term_color(long c);
char*   term_get_color(char *s, long c);
void    texe(GEN g, char format, long dec);
void    warning0(GEN g);
void    write0(const char *s, GEN g);
void    write1(const char *s, GEN g);
void    writebin(const char *name, GEN x);
void    writetex(const char *s, GEN g);

/* eval.c */

enum { br_NONE = 0, br_BREAK, br_NEXT, br_MULTINEXT, br_RETURN };
void    bincopy_relink(GEN C, GEN vi);
GEN     bitprecision0(GEN x,long n);
GEN     bitprecision00(GEN x,GEN n);
GEN     break0(long n);
GEN     call0(GEN fun, GEN args);
GEN     closure_callgen0prec(GEN C, long prec);
GEN     closure_callgen0(GEN C);
GEN     closure_callgen1(GEN C, GEN x);
GEN     closure_callgen1prec(GEN C, GEN x, long prec);
GEN     closure_callgen2(GEN C, GEN x, GEN y);
GEN     closure_callgenall(GEN C, long n, ...);
GEN     closure_callgenvec(GEN C, GEN args);
GEN     closure_callgenvecdef(GEN C, GEN args, GEN def);
GEN     closure_callgenvecdefprec(GEN C, GEN args, GEN def, long prec);
GEN     closure_callgenvecprec(GEN C, GEN args, long prec);
void    closure_callvoid1(GEN C, GEN x);
long    closure_context(long start, long level);
void    closure_disassemble(GEN n);
void    closure_err(long level);
GEN     closure_evalbrk(GEN C, long *status);
GEN     closure_evalgen(GEN C);
GEN     closure_evalnobrk(GEN C);
GEN     closure_evalres(GEN C);
void    closure_evalvoid(GEN C);
const char * closure_func_err(void);
GEN     copybin_unlink(GEN C);
long    getlocalprec(long prec);
long    getlocalbitprec(long bit);
GEN     get_lex(long vn);
long    get_localprec(void);
long    get_localbitprec(void);
GEN     gp_call(void *E, GEN x);
GEN     gp_callprec(void *E, GEN x, long prec);
GEN     gp_call2(void *E, GEN x, GEN y);
long    gp_callbool(void *E, GEN x);
long    gp_callvoid(void *E, GEN x);
GEN     gp_eval(void *E, GEN x);
long    gp_evalbool(void *E, GEN x);
GEN     gp_evalprec(void *E, GEN x, long prec);
GEN     gp_evalupto(void *E, GEN x);
long    gp_evalvoid(void *E, GEN x);
void    localprec(GEN p);
void    localbitprec(GEN p);
long    loop_break(void);
GEN     next0(long n);
GEN     pareval(GEN C);
void    parfor0(GEN a, GEN b, GEN code, GEN code2);
void    parforeach0(GEN x, GEN code, GEN code2);
void    parforprime0(GEN a, GEN b, GEN code, GEN code2);
void    parforprimestep0(GEN a, GEN b, GEN q, GEN code, GEN code2);
void    parforstep0(GEN a, GEN b, GEN s, GEN code, GEN code2);
void    parforvec0(GEN a, GEN code, GEN code2, long flag);
GEN     pari_self(void);
GEN     parsum(GEN a, GEN b, GEN code);
GEN     parvector(long n, GEN code);
void    pop_lex(long n);
void    pop_localprec(void);
GEN     precision0(GEN x,long n);
GEN     precision00(GEN x, GEN n);
void    push_lex(GEN a, GEN C);
void    push_localbitprec(long p);
void    push_localprec(long p);
GEN     return0(GEN x);
void    set_lex(long vn, GEN x);

/* forprime.c */

void    forcomposite(GEN a, GEN b, GEN code);
int     forcomposite_init(forcomposite_t *C, GEN a, GEN b);
GEN     forcomposite_next(forcomposite_t *C);
void    forprime(GEN a, GEN b, GEN code);
GEN     forprime_next(forprime_t *T);
int     forprime_init(forprime_t *T, GEN a, GEN b);
void    forprimestep(GEN a, GEN b, GEN q, GEN code);
int     forprimestep_init(forprime_t *T, GEN a, GEN b, GEN q);
void    initprimetable(ulong maxnum, ulong factorlimit);
ulong   maxprime(void);
ulong   maxprimeN(void);
void    maxprime_check(ulong c);
ulong   maxprimelim(void);
void    pari_init_primes(ulong maxprime, ulong factorlimit);
GEN     prodprimes(void);
GEN     prodprimeslim(void);
ulong   u_forprime_next(forprime_t *T);
int     u_forprime_init(forprime_t *T, ulong a, ulong b);
void    u_forprime_restrict(forprime_t *T, ulong c);
int     u_forprime_arith_init(forprime_t *T, ulong a, ulong b, ulong c, ulong q);

/* FF.c */

GEN     FF_1(GEN a);
GEN     FF_Frobenius(GEN x, long e);
GEN     FF_Z_Z_muldiv(GEN x, GEN y, GEN z);
GEN     FF_Q_add(GEN x, GEN y);
GEN     FF_Z_add(GEN a, GEN b);
GEN     FF_Z_mul(GEN a, GEN b);
GEN     FF_add(GEN a, GEN b);
GEN     FF_charpoly(GEN x);
GEN     FF_conjvec(GEN x);
GEN     FF_div(GEN a, GEN b);
GEN     FF_ellcard(GEN E);
GEN     FF_ellcard_SEA(GEN E, long smallfact);
GEN     FF_ellgens(GEN E);
GEN     FF_ellgroup(GEN E, GEN *m);
GEN     FF_elllog(GEN E, GEN P, GEN Q, GEN o);
GEN     FF_ellmul(GEN E, GEN P, GEN n);
GEN     FF_ellorder(GEN E, GEN P, GEN o);
GEN     FF_elltwist(GEN E);
GEN     FF_ellrandom(GEN E);
GEN     FF_elltatepairing(GEN E, GEN P, GEN Q, GEN m);
GEN     FF_ellweilpairing(GEN E, GEN P, GEN Q, GEN m);
int     FF_equal(GEN a, GEN b);
int     FF_equal0(GEN x);
int     FF_equal1(GEN x);
int     FF_equalm1(GEN x);
long    FF_f(GEN x);
GEN     FF_gen(GEN x);
GEN     FF_inv(GEN a);
long    FF_issquare(GEN x);
long    FF_issquareall(GEN x, GEN *pt);
long    FF_ispower(GEN x, GEN K, GEN *pt);
GEN     FF_log(GEN a, GEN b, GEN o);
GEN     FF_map(GEN m, GEN x);
GEN     FF_minpoly(GEN x);
GEN     FF_mod(GEN x);
GEN     FF_mul(GEN a, GEN b);
GEN     FF_mul2n(GEN a, long n);
GEN     FF_neg(GEN a);
GEN     FF_neg_i(GEN a);
GEN     FF_norm(GEN x);
GEN     FF_order(GEN x, GEN o);
GEN     FF_p(GEN x);
GEN     FF_p_i(GEN x);
GEN     FF_pow(GEN x, GEN n);
GEN     FF_primroot(GEN x, GEN *o);
GEN     FF_q(GEN x);
int     FF_samefield(GEN x, GEN y);
GEN     FF_sqr(GEN a);
GEN     FF_sqrt(GEN a);
GEN     FF_sqrtn(GEN x, GEN n, GEN *zetan);
GEN     FF_sub(GEN x, GEN y);
GEN     FF_to_F2xq(GEN x);
GEN     FF_to_F2xq_i(GEN x);
GEN     FF_to_Flxq(GEN x);
GEN     FF_to_Flxq_i(GEN x);
GEN     FF_to_FpXQ(GEN x);
GEN     FF_to_FpXQ_i(GEN x);
GEN     FF_trace(GEN x);
long    FF_var(GEN x);
GEN     FF_zero(GEN a);
GEN     FFM_FFC_invimage(GEN M, GEN C, GEN ff);
GEN     FFM_FFC_gauss(GEN M, GEN C, GEN ff);
GEN     FFM_FFC_mul(GEN M, GEN C, GEN ff);
GEN     FFM_deplin(GEN M, GEN ff);
GEN     FFM_det(GEN M, GEN ff);
GEN     FFM_gauss(GEN M, GEN N, GEN ff);
GEN     FFM_image(GEN M, GEN ff);
GEN     FFM_indexrank(GEN M, GEN ff);
GEN     FFM_inv(GEN M, GEN ff);
GEN     FFM_invimage(GEN M, GEN N, GEN ff);
GEN     FFM_ker(GEN M, GEN ff);
GEN     FFM_mul(GEN M, GEN N, GEN ff);
long    FFM_rank(GEN M, GEN ff);
GEN     FFM_suppl(GEN M, GEN ff);
GEN     FFV_roots_to_pol(GEN V, GEN ff, long v);
GEN     FFX_add(GEN Pf, GEN Qf, GEN ff);
GEN     FFX_ddf(GEN f, GEN x);
GEN     FFX_degfact(GEN Pf, GEN ff);
GEN     FFX_disc(GEN Pf, GEN ff);
GEN     FFX_extgcd(GEN Pf, GEN Qf, GEN ff, GEN *pt_Uf, GEN *pt_Vf);
GEN     FFX_factor(GEN f, GEN x);
GEN     FFX_factor_squarefree(GEN f, GEN x);
GEN     FFX_gcd(GEN Pf, GEN Qf, GEN ff);
GEN     FFX_halfgcd(GEN Pf, GEN Qf, GEN ff);
GEN     FFX_halfgcd_all(GEN Pf, GEN Qf, GEN ff, GEN *a, GEN *b);
long    FFX_ispower(GEN Pf, long k, GEN ff, GEN *pt_r);
GEN     FFX_mul(GEN Pf, GEN Qf, GEN ff);
long    FFX_nbroots(GEN f, GEN x);
GEN     FFX_preimage(GEN x, GEN F, GEN y);
GEN     FFX_preimagerel(GEN x, GEN F, GEN y);
GEN     FFX_rem(GEN Pf, GEN Qf, GEN ff);
GEN     FFX_resultant(GEN Pf, GEN Qf, GEN ff);
GEN     FFX_roots(GEN f, GEN x);
GEN     FFX_sqr(GEN Pf, GEN ff);
GEN     FFXQ_inv(GEN Pf, GEN Qf, GEN ff);
GEN     FFXQ_minpoly(GEN Pf, GEN Qf, GEN ff);
GEN     FFXQ_mul(GEN Pf, GEN Qf, GEN Sf, GEN ff);
GEN     FFXQ_sqr(GEN Pf, GEN Qf, GEN ff);
GEN     FqC_to_FFC(GEN x, GEN ff);
GEN     FqM_to_FFM(GEN x, GEN ff);
GEN     FqV_to_FFV(GEN x, GEN ff);
GEN     FqX_to_FFX(GEN x, GEN ff);
GEN     Fq_to_FF(GEN x, GEN ff);
GEN     Z_FF_div(GEN a, GEN b);
GEN     ffembed(GEN a, GEN b);
GEN     ffextend(GEN a, GEN P, long v);
GEN     fffrobenius(GEN m, long n);
GEN     ffgen(GEN T, long v);
GEN     ffinvmap(GEN m);
GEN     fflog(GEN x, GEN g, GEN o);
GEN     ffmap(GEN m, GEN x);
GEN     ffmaprel(GEN m, GEN x);
GEN     ffcompomap(GEN m, GEN n);
GEN     fforder(GEN x, GEN o);
GEN     ffprimroot(GEN x, GEN *o);
GEN     ffrandom(GEN ff);
int     Rg_is_FF(GEN c, GEN *ff);
int     RgC_is_FFC(GEN x, GEN *ff);
int     RgM_is_FFM(GEN x, GEN *ff);
GEN     p_to_FF(GEN p, long v);
GEN     Tp_to_FF(GEN T, GEN p);

/* factcyclo.c */

GEN     Flx_factcyclo(ulong n, ulong p, ulong m);
GEN     FpX_factcyclo(ulong n, GEN p, ulong m);
GEN     factormodcyclo(long n, GEN p, long m, long v);

/* galconj.c */

GEN     checkgal(GEN gal);
GEN     checkgroup(GEN g, GEN *S);
GEN     checkgroupelts(GEN gal);
GEN     embed_disc(GEN r, long r1, long prec);
GEN     embed_roots(GEN r, long r1);
GEN     galois_group(GEN gal);
GEN     galoisconj(GEN nf, GEN d);
GEN     galoisconj0(GEN nf, long flag, GEN d, long prec);
GEN     galoisconjclasses(GEN gal);
GEN     galoisexport(GEN gal, long format);
GEN     galoisfixedfield(GEN gal, GEN v, long flag, long y);
GEN     galoisidentify(GEN gal);
GEN     galoisinit(GEN nf, GEN den);
GEN     galoisisabelian(GEN gal, long flag);
long    galoisisnormal(GEN gal, GEN sub);
GEN     galoispermtopol(GEN gal, GEN perm);
GEN     galoissplittinginit(GEN nf, GEN deg);
GEN     galoissubgroups(GEN G);
GEN     galoissubfields(GEN G, long flag, long v);
long    numberofconjugates(GEN T, long pdepart);

/* galois.c */

GEN     polgalois(GEN x, long prec);

/* galpol.c */

GEN     galoisnbpol(long a);
GEN     galoisgetgroup(long a, long b);
GEN     galoisgetname(long a, long b);
GEN     galoisgetpol(long a, long b, long s);

/* gen1.c */
GEN     conj_i(GEN x);
GEN     conjvec(GEN x,long prec);
GEN     divrunextu(GEN x, ulong i);
GEN     gadd(GEN x, GEN y);
GEN     gaddsg(long x, GEN y);
GEN     gconj(GEN x);
GEN     gdiv(GEN x, GEN y);
GEN     gdivgs(GEN x, long s);
GEN     gdivgu(GEN x, ulong s);
GEN     gdivgunextu(GEN x, ulong i);
GEN     ginv(GEN x);
GEN     gmul(GEN x, GEN y);
GEN     gmul2n(GEN x, long n);
GEN     gmulsg(long s, GEN y);
GEN     gmulug(ulong s, GEN y);
GEN     gsqr(GEN x);
GEN     gsub(GEN x, GEN y);
GEN     gsubsg(long x, GEN y);
GEN     mulcxI(GEN x);
GEN     mulcxmI(GEN x);
GEN     mulcxpowIs(GEN x, long k);
GEN     Qdivii(GEN x1, GEN x2);
GEN     Qdiviu(GEN x, ulong y);
GEN     Qdivis(GEN x, long y);
GEN     ser_normalize(GEN x);

/* gen2.c */

GEN     gassoc_proto(GEN f(GEN,GEN),GEN,GEN);
GEN     map_proto_G(GEN f(GEN), GEN x);
GEN     map_proto_lG(long f(GEN), GEN x);
GEN     map_proto_lGL(long f(GEN,long), GEN x, long y);

long    Q_lval(GEN x, ulong p);
long    Q_lvalrem(GEN x, ulong p, GEN *y);
long    Q_pval(GEN x, GEN p);
long    Q_pvalrem(GEN x, GEN p, GEN *y);
long    RgX_val(GEN x);
long    RgX_valrem(GEN x, GEN *z);
long    RgX_valrem_inexact(GEN x, GEN *Z);
long    RgXV_maxdegree(GEN x);
long    Z_lval(GEN n, ulong p);
long    Z_lvalrem(GEN n, ulong p, GEN *py);
long    Z_lvalrem_stop(GEN *n, ulong p, int *stop);
long    Z_pval(GEN n, GEN p);
long    Z_pvalrem(GEN x, GEN p, GEN *py);
int     ZV_Z_dvd(GEN v, GEN p);
long    ZV_pval(GEN x, GEN p);
long    ZV_pvalrem(GEN x, GEN p, GEN *px);
long    ZV_lval(GEN x, ulong p);
long    ZV_lvalrem(GEN x, ulong p, GEN *px);
long    ZX_lvalrem(GEN x, ulong p, GEN *px);
long    ZX_lval(GEN x, ulong p);
long    ZX_pval(GEN x, GEN p);
long    ZX_pvalrem(GEN x, GEN p, GEN *px);
long    ZXV_pvalrem(GEN x, GEN p, GEN *px);
long    ZXX_pvalrem(GEN x, GEN p, GEN *px);
void    affgc(GEN x, GEN y);
GEN     cvstop2(long s, GEN y);
GEN     cvtop(GEN x, GEN p, long l);
GEN     cvtop2(GEN x, GEN y);
int     cx_approx_equal(GEN a, GEN b);
int     cx_approx0(GEN x, GEN y);
GEN     gabs(GEN x, long prec);
int     gcmp(GEN x, GEN y);
int     gequal0(GEN x);
int     gequal1(GEN x);
int     gequalX(GEN x);
int     gequalm1(GEN x);
int     gcmpsg(long x, GEN y);
GEN     gcvtop(GEN x, GEN p, long r);
int     gequal(GEN x, GEN y);
int     gequalsg(long s, GEN x);
long    gexpo(GEN x);
long    gexpo_safe(GEN x);
GEN     gpexponent(GEN x);
GEN     gpvaluation(GEN x, GEN p);
long    gvaluation(GEN x, GEN p);
int     gidentical(GEN x, GEN y);
long    glength(GEN x);
GEN     gmax(GEN x, GEN y);
GEN     gmaxgs(GEN x, long y);
GEN     gmin(GEN x, GEN y);
GEN     gmings(GEN x, long y);
GEN     gneg(GEN x);
GEN     gneg_i(GEN x);
int     gsigne(GEN x);
GEN     gtolist(GEN x);
long    gtolong(GEN x);
long    gtranslength(GEN x);
int     lexcmp(GEN x, GEN y);
GEN     listinsert(GEN list, GEN object, long index);
GEN     listinsert0(GEN list, GEN object, long index);
void    listpop(GEN L, long index);
void    listpop0(GEN L, long index);
GEN     listput(GEN list, GEN object, long index);
GEN     listput0(GEN list, GEN object, long index);
void    listsort(GEN list, long flag);
GEN     matsize(GEN x);
GEN     mklist(void);
GEN     mklist_typ(long t);
GEN     mklistcopy(GEN x);
GEN     mkmap(void);
GEN     normalizeser(GEN x);
GEN     normalizepol(GEN x);
GEN     normalizepol_approx(GEN x, long lx);
GEN     normalizepol_lg(GEN x, long lx);
ulong   padic_to_Fl(GEN x, ulong p);
GEN     padic_to_Fp(GEN x, GEN Y);
GEN     quadtofp(GEN x, long l);
long    sizedigit(GEN x);
long    u_lval(ulong x, ulong p);
long    u_lvalrem(ulong x, ulong p, ulong *py);
long    u_lvalrem_stop(ulong *n, ulong p, int *stop);
long    u_pval(ulong x, GEN p);
long    u_pvalrem(ulong x, GEN p, ulong *py);
long    vecindexmax(GEN x);
long    vecindexmin(GEN x);
GEN     vecmax0(GEN x, GEN *pv);
GEN     vecmax(GEN x);
GEN     vecmin0(GEN x, GEN *pv);
GEN     vecmin(GEN x);
long    z_lval(long s, ulong p);
long    z_lvalrem(long s, ulong p, long *py);
long    z_pval(long n, GEN p);
long    z_pvalrem(long n, GEN p, long *py);
long    zx_lval(GEN f, long p);

/* hgm.c */

GEN     hgmcyclo(GEN hgm);
GEN     hgmalpha(GEN hgm);
GEN     hgmgamma(GEN hgm);
GEN     hgminit(GEN val, GEN vbe);
GEN     hgmparams(GEN hgm);
GEN     hgmeulerfactor(GEN hgm, GEN t, long p, GEN* ptcondexpo);
GEN     hgmcoef(GEN hgm, GEN t, GEN n);
GEN     hgmcoefs(GEN hgm, GEN t, long n);
GEN     hgmtwist(GEN hgm);
long    hgmissymmetrical(GEN hgm);
GEN     hgmbydegree(long n);
GEN     lfunhgm(GEN hgm, GEN t, GEN hint, long bit);

/* lerch.c */

GEN     Qp_zeta(GEN s);
GEN     Qp_zetahurwitz(GEN s, GEN x, long k);
GEN     lerchphi(GEN z, GEN s, GEN a, long bitprec);
GEN     lerchzeta(GEN s, GEN a, GEN lam, long bitprec);
GEN     zetahurwitz(GEN s, GEN x, long der, long bitprec);

/* Ser.c */

GEN     RgX_to_ser(GEN x, long l);
GEN     RgX_to_ser_inexact(GEN x, long l);
GEN     gtoser(GEN x, long v, long d);
GEN     gtoser_prec(GEN x, long v, long d);
GEN     rfrac_to_ser(GEN x, long l);
GEN     rfrac_to_ser_i(GEN x, long);
GEN     rfracrecip_to_ser_absolute(GEN R, long l);
long    rfracrecip(GEN *pn, GEN *pd);
GEN     scalarser(GEN x, long v, long prec);
GEN     sertoser(GEN x, long prec);
GEN     toser_i(GEN x);
GEN     RgV_to_ser(GEN x, long v, long l);
GEN     Ser0(GEN x, long v, GEN d, long prec);

/* gen3.c */

GEN     QpV_to_QV(GEN v);
GEN     RgC_RgV_mulrealsym(GEN x, GEN y);
GEN     RgM_mulreal(GEN x, GEN y);
GEN     RgX_cxeval(GEN T, GEN u, GEN ui);
GEN     RgX_deflate_max(GEN x0, long *m);
long    RgX_deflate_order(GEN x);
long    RgX_degree(GEN x,long v);
GEN     RgX_integ(GEN x);
GEN     RgXY_cxevalx(GEN T, GEN u, GEN ui);
long    ZX_deflate_order(GEN x);
GEN     ZX_deflate_max(GEN x, long *m);
GEN     ceil_safe(GEN x);
GEN     ceilr(GEN x);
GEN     centerlift(GEN x);
GEN     centerlift0(GEN x,long v);
GEN     compo(GEN x, long n);
GEN     deg1pol(GEN x1, GEN x0,long v);
GEN     deg1pol_shallow(GEN x1, GEN x0,long v);
GEN     deg2pol_shallow(GEN x2, GEN x1, GEN x0,long v);
long    degree(GEN x);
GEN     denom(GEN x);
GEN     denom_i(GEN x);
GEN     denominator(GEN x, GEN D);
GEN     deriv(GEN x, long v);
GEN     derivn(GEN x, long n, long v);
GEN     derivser(GEN x);
GEN     diffop(GEN x, GEN v, GEN dv);
GEN     diffop0(GEN x, GEN v, GEN dv, long n);
GEN     diviiround(GEN x, GEN y);
GEN     divrem(GEN x, GEN y, long v);
GEN     floor_safe(GEN x);
GEN     gceil(GEN x);
GEN     gcvtoi(GEN x, long *e);
GEN     gdeflate(GEN x, long v, long d);
GEN     gdivent(GEN x, GEN y);
GEN     gdiventgs(GEN x, long y);
GEN     gdiventsg(long x, GEN y);
GEN     gdiventres(GEN x, GEN y);
GEN     gdivmod(GEN x, GEN y, GEN *pr);
GEN     gdivround(GEN x, GEN y);
int     gdvd(GEN x, GEN y);
GEN     geq(GEN x, GEN y);
GEN     geval(GEN x);
GEN     geval_gp(GEN x, GEN t);
GEN     gfloor(GEN x);
GEN     gtrunc2n(GEN x, long s);
GEN     gfrac(GEN x);
GEN     gge(GEN x, GEN y);
GEN     ggrando(GEN x, long n);
GEN     ggt(GEN x, GEN y);
GEN     gimag(GEN x);
GEN     gisexactzero(GEN g);
GEN     gle(GEN x, GEN y);
GEN     glt(GEN x, GEN y);
GEN     gmod(GEN x, GEN y);
GEN     gmodgs(GEN x, long y);
GEN     gmodsg(long x, GEN y);
GEN     gmodulo(GEN x,GEN y);
GEN     gmodulsg(long x, GEN y);
GEN     gmodulss(long x, long y);
GEN     gne(GEN x, GEN y);
GEN     gnot(GEN x);
GEN     gpolvar(GEN y);
GEN     gppadicprec(GEN x, GEN p);
GEN     gppoldegree(GEN x, long v);
long    gprecision(GEN x);
GEN     gpserprec(GEN x, long v);
GEN     greal(GEN x);
GEN     grndtoi(GEN x, long *e);
GEN     ground(GEN x);
GEN     gshift(GEN x, long n);
GEN     gsubst(GEN x, long v, GEN y);
GEN     gsubstpol(GEN x, GEN v, GEN y);
GEN     gsubstvec(GEN x, GEN v, GEN y);
GEN     gtocol(GEN x);
GEN     gtocol0(GEN x, long n);
GEN     gtocolrev(GEN x);
GEN     gtocolrev0(GEN x, long n);
GEN     gtopoly(GEN x, long v);
GEN     gtopolyrev(GEN x, long v);
GEN     gtovec(GEN x);
GEN     gtovec0(GEN x, long n);
GEN     gtovecrev(GEN x);
GEN     gtovecrev0(GEN x, long n);
GEN     gtovecsmall(GEN x);
GEN     gtovecsmall0(GEN x, long n);
GEN     gtrunc(GEN x);
long    gvar(GEN x);
long    gvar2(GEN x);
GEN     hqfeval(GEN q, GEN x);
GEN     imag_i(GEN x);
GEN     integ(GEN x, long v);
GEN     integser(GEN x);
GEN     ser_inv(GEN b);
int     iscomplex(GEN x);
int     isexactzero(GEN g);
int     isrationalzeroscalar(GEN g);
int     isinexact(GEN x);
int     isinexactreal(GEN x);
int     isint(GEN n, GEN *ptk);
int     isrationalzero(GEN g);
int     issmall(GEN n, long *ptk);
GEN     lift(GEN x);
GEN     lift_shallow(GEN x);
GEN     lift0(GEN x,long v);
GEN     liftall(GEN x);
GEN     liftall_shallow(GEN x);
GEN     liftint(GEN x);
GEN     liftint_shallow(GEN x);
GEN     liftpol(GEN x);
GEN     liftpol_shallow(GEN x);
GEN     mkcoln(long n, ...);
GEN     mkintn(long n, ...);
GEN     mkpoln(long n, ...);
GEN     mkvecn(long n, ...);
GEN     mkvecsmalln(long n, ...);
GEN     modRr_safe(GEN x, GEN y);
GEN     modRr_i(GEN x, GEN y, GEN iy);
GEN     mulimag(GEN x, GEN y);
GEN     mulreal(GEN x, GEN y);
GEN     numer(GEN x);
GEN     numer_i(GEN x);
GEN     numerator(GEN x, GEN D);
GEN     padic_to_Q(GEN x);
GEN     padic_to_Q_shallow(GEN x);
long    padicprec(GEN x, GEN p);
long    padicprec_relative(GEN x);
GEN     polcoef(GEN x, long n, long v);
GEN     polcoef_i(GEN x, long n, long v);
long    poldegree(GEN x,long v);
GEN     poleval(GEN x, GEN y);
GEN     pollead(GEN x,long v);
long    precision(GEN x);
GEN     qf_RgM_apply(GEN q, GEN M);
GEN     qf_ZM_apply(GEN q, GEN M);
GEN     qfb_ZM_apply(GEN q, GEN M);
GEN     qfbil(GEN x, GEN y, GEN q);
GEN     qfeval(GEN q, GEN x);
GEN     qfeval0(GEN q, GEN x, GEN y);
GEN     qfevalb(GEN q, GEN x, GEN y);
GEN     qfnorm(GEN x, GEN q);
GEN     real_i(GEN x);
GEN     round0(GEN x, GEN *pte);
GEN     roundr(GEN x);
GEN     roundr_safe(GEN x);
GEN     scalarpol(GEN x, long v);
GEN     scalarpol_shallow(GEN x, long v);
GEN     ser_unscale(GEN P, GEN h);
long    serprec(GEN x, long v);
GEN     serreverse(GEN x);
GEN     simplify(GEN x);
GEN     simplify_shallow(GEN x);
GEN     tayl(GEN x, long v, long precdl);
GEN     trunc0(GEN x, GEN *pte);
GEN     uu32toi(ulong a, ulong b);
GEN     uu32toineg(ulong a, ulong b);
GEN     vars_sort_inplace(GEN z);
GEN     vars_to_RgXV(GEN h);
GEN     variables_vecsmall(GEN x);
GEN     variables_vec(GEN x);

/* genus2red.c */

GEN     genus2red(GEN PQ, GEN p);
GEN     genus2igusa(GEN P, long n);

/* grossenchar.c */

GEN     gchar_conductor(GEN gc, GEN chi);
GEN     gchar_identify(GEN gc, GEN Lv, GEN Lchiv, long prec);
GEN     gcharalgebraic(GEN gc, GEN type);
GEN     gcharduallog(GEN gc, GEN chi);
GEN     gchareval(GEN gc, GEN chi, GEN x, long flag);
GEN     gchari_lfun(GEN gc, GEN chi, GEN w);
GEN     gcharinit(GEN bnf, GEN mod, long prec);
int     gcharisalgebraic(GEN gc, GEN chi, GEN *pq);
GEN     gcharlocal(GEN gc, GEN chi, GEN v, long prec, GEN *ptbid);
GEN     gcharlog(GEN gc, GEN x, long prec);
GEN     gcharnewprec(GEN gc, long prec);
int     is_gchar_group(GEN gc);
GEN     lfungchar(GEN gc, GEN chi);
GEN     vecan_gchar(GEN an, long n, long prec);
GEN     eulerf_gchar(GEN an, GEN p, long prec);

/* groupid.c */

long    group_ident(GEN G, GEN S);
long    group_ident_trans(GEN G, GEN S);

/* hash.c */

hashtable *hash_create(ulong minsize, ulong (*hash)(void*), int (*eq)(void*,void*), int use_stack);
hashtable *hash_create_GEN(ulong s, long stack);
hashtable *hash_create_INT(ulong s, long stack);
hashtable *hash_create_str(ulong s, long stack);
hashtable *hash_create_ulong(ulong s, long stack);
void    hash_dbg(hashtable *h);
GEN     hash_haskey_GEN(hashtable *h, void *k);
int     hash_haskey_long(hashtable *h, void *k, long *v);
void    hash_init(hashtable *h, ulong minsize, ulong (*hash)(void*),
                                int (*eq)(void*,void*), int use_stack);
void    hash_init_GEN(hashtable *h, ulong minsize, int (*eq)(GEN,GEN), int use_stack);
void    hash_init_ulong(hashtable *h, ulong minsize, int use_stack);
void    hash_insert(hashtable *h, void *k, void *v);
void    hash_insert_long(hashtable *h, void *k, long v);
void    hash_insert2(hashtable *h, void *k, void *v, ulong hash);
GEN     hash_keys(hashtable *h);
GEN     hash_keys_GEN(hashtable *h);
GEN     hash_values(hashtable *h);
GEN     hash_values_GEN(hashtable *h);
hashentry *hash_search(hashtable *h, void *k);
hashentry *hash_search2(hashtable *h, void *k, ulong hash);
hashentry *hash_select(hashtable *h, void *k, void *E,int(*select)(void *,hashentry *));
hashentry *hash_remove(hashtable *h, void *k);
hashentry *hash_remove_select(hashtable *h, void *k, void *E, int (*select)(void*,hashentry*));
void    hash_destroy(hashtable *h);
ulong   hash_GEN(GEN x);
ulong   hash_zv(GEN x);

/* hyperell.c */

GEN     ZX_hyperellred(GEN P, GEN *pM);
GEN     genus2charpoly(GEN G, GEN p);
GEN     hyperellcharpoly(GEN x);
GEN     hyperellchangecurve(GEN C, GEN m);
GEN     hyperelldisc(GEN x);
int     hyperellisoncurve(GEN W, GEN P);
GEN     hyperellminimaldisc(GEN x, GEN pr);
GEN     hyperellminimalmodel(GEN x, GEN *pM, GEN pr);
GEN     hyperellordinate(GEN W, GEN x);
GEN     hyperellpadicfrobenius0(GEN x, GEN p, long e);
GEN     hyperellpadicfrobenius(GEN x, ulong p, long e);
GEN     hyperellred(GEN P, GEN *pM);
GEN     nfhyperellpadicfrobenius(GEN H, GEN T, ulong p, long n);

/* hypergeom.c */

GEN     hypergeom(GEN vnum, GEN vden, GEN z, long prec);
GEN     airy(GEN z, long prec);

/* hnf_snf.c */

GEN     RgM_hnfall(GEN A, GEN *pB, long remove);
GEN     ZM_hnf(GEN x);
GEN     ZM_hnf_knapsack(GEN x);
GEN     ZM_hnfall(GEN A, GEN *ptB, long remove);
GEN     ZM_hnfall_i(GEN A, GEN *ptB, long remove);
GEN     ZM_hnfcenter(GEN M);
GEN     ZM_hnflll(GEN A, GEN *ptB, int remove);
GEN     ZV_extgcd(GEN A);
GEN     ZV_snfall(GEN D, GEN *pU, GEN *pV);
GEN     ZV_snf_group(GEN d, GEN *newU, GEN *newUi);
long    ZV_snf_rank(GEN D, GEN p);
long    ZV_snf_rank_u(GEN D, ulong p);
void    ZV_snf_trunc(GEN D);
GEN     ZM_hnfmod(GEN x, GEN d);
GEN     ZM_hnfmodall(GEN x, GEN dm, long flag);
GEN     ZM_hnfmodall_i(GEN x, GEN dm, long flag);
GEN     ZM_hnfmodid(GEN x, GEN d);
GEN     ZM_hnfmodprime(GEN x, GEN p);
GEN     ZM_hnfperm(GEN A, GEN *ptU, GEN *ptperm);
void    ZM_snfclean(GEN d, GEN u, GEN v);
GEN     ZM_snf(GEN x);
GEN     ZM_snf_group(GEN H, GEN *newU, GEN *newUi);
GEN     ZM_snfall(GEN x, GEN *ptU, GEN *ptV);
GEN     ZM_snfall_i(GEN x, GEN *ptU, GEN *ptV, long flag);
GEN     ZV_snfclean(GEN d);
GEN     ZpM_echelon(GEN x, long early_abort, GEN p, GEN pm);
GEN     gsmith(GEN x);
GEN     gsmithall(GEN x);
GEN     hnf(GEN x);
GEN     hnf_divscale(GEN A, GEN B,GEN t);
GEN     hnf_invscale(GEN A, GEN t);
GEN     hnf_solve(GEN A, GEN B);
GEN     hnf_invimage(GEN A, GEN b);
GEN     hnfall(GEN x);
int     hnfdivide(GEN A, GEN B);
GEN     hnflll(GEN x);
GEN     hnfmerge_get_1(GEN A, GEN B);
GEN     hnfmod(GEN x, GEN d);
GEN     hnfmodid(GEN x,GEN p);
GEN     hnfperm(GEN x);
GEN     matfrobenius(GEN M, long flag, long v);
GEN     mathnf0(GEN x, long flag);
GEN     matsnf0(GEN x, long flag);
GEN     smith(GEN x);
GEN     smithall(GEN x);
GEN     smithclean(GEN z);
long    snfrank(GEN D, GEN p);
GEN     zlm_echelon(GEN x, long early_abort, ulong p, ulong pm);
long    zv_snf_rank(GEN D, ulong p);

/* ifactor1.c */

GEN     Z_ECM(GEN N, long rounds, long seed, ulong B1);
GEN     Z_factor(GEN n);
GEN     Z_factor_limit(GEN n, ulong all);
GEN     Z_factor_until(GEN n, GEN limit);
int     Z_has_prime_3mod4(GEN n);
long    Z_issmooth(GEN m, ulong lim);
GEN     Z_issmooth_fact(GEN m, ulong lim);
long    Z_issquarefree(GEN x);
GEN     Z_pollardbrent(GEN n, long rounds, long seed);
long    Zn_ispower(GEN a, GEN q, GEN K, GEN *pt);
GEN     absZ_factor(GEN n);
GEN     absZ_factor_limit(GEN n, ulong all);
GEN     absZ_factor_limit_strict(GEN n, ulong all, GEN *pU);
ulong   coreu(ulong n);
ulong   coreu_fact(GEN f);
GEN     factorint(GEN n, long flag);
GEN     factoru(ulong n);
ulong   tridiv_boundu(ulong n);
int     ifac_isprime(GEN x);
int     ifac_next(GEN *part, GEN *p, long *e);
int     ifac_read(GEN part, GEN *p, long *e);
void    ifac_skip(GEN part);
GEN     ifac_start(GEN n, int moebius);
int     is_357_power(GEN x, GEN *pt, ulong *mask);
int     is_pth_power(GEN x, GEN *pt, forprime_t *T, ulong cutoffbits);
long    ispowerful(GEN n);
long    maxomegau(ulong x);
long    maxomegaoddu(ulong x);
long    moebius(GEN n);
long    moebiusu(ulong n);
long    moebiusu_fact(GEN f);
GEN     nextprime(GEN n);
GEN     precprime(GEN n);
ulong   radicalu(ulong n);
ulong   tridiv_bound(GEN n);
int     uis_357_power(ulong x, ulong *pt, ulong *mask);
int     uis_357_powermod(ulong x, ulong *mask);
ulong   unextprime(ulong n);
ulong   uprecprime(ulong n);
GEN     vecfactorsquarefreeu(ulong a, ulong b);
GEN     vecfactorsquarefreeu_coprime(ulong a, ulong b, GEN P);
GEN     vecfactoru_i(ulong a, ulong b);
GEN     vecfactoru(ulong a, ulong b);
GEN     vecfactoroddu_i(ulong a, ulong b);
GEN     vecfactoroddu(ulong a, ulong b);
GEN     vecsquarefreeu(ulong a, ulong b);

/* init.c */

int     chk_gc_upto(GEN x);
GENbin* copy_bin(GEN x);
GENbin* copy_bin_canon(GEN x);
void    dbg_fill_stack(void);
void    dbg_stack(pari_sp av);
void    dbg_gc_upto(GEN q);
GEN     errname(GEN err);
void    exportall(void);
GEN     gclone(GEN x);
GEN     gcloneref(GEN x);
void    gclone_refc(GEN x);
GEN     gcopy(GEN x);
GEN     gcopy_avma(GEN x, pari_sp *AVMA);
GEN     gcopy_lg(GEN x, long lx);
GEN     gerepile(pari_sp ltop, pari_sp lbot, GEN q);
GEN     gc_all_unsafe(pari_sp av, pari_sp tetpil, int n, ...);
void    gc_slice_unsafe(pari_sp av, pari_sp tetpil, GEN g, int n);
size_t  gc_stack_update(pari_sp av, pari_sp tetpil);
GEN     getheap(void);
void    gp_context_save(struct gp_context* rec);
void    gp_context_restore(struct gp_context* rec);
long    gsizeword(GEN x);
long    gsizebyte(GEN x);
void    gunclone(GEN x);
void    gunclone_deep(GEN x);
GEN     listcopy(GEN x);
GEN     listinit(GEN x);
void    msgtimer(const char *format, ...);
long    name_numerr(const char *s);
void    new_chunk_resize(size_t x);
GEN     newblock(size_t n);
const char * numerr_name(long errnum);
GEN     obj_check(GEN S, long K);
GEN     obj_checkbuild(GEN S, long tag, GEN (*build)(GEN));
GEN     obj_checkbuild_padicprec(GEN S, long tag, GEN (*build)(GEN,long), long prec);
GEN     obj_checkbuild_realprec(GEN S, long tag, GEN (*build)(GEN,long), long prec);
GEN     obj_checkbuild_prec(GEN S, long tag, GEN (*build)(GEN,long), long (*pr)(GEN), long prec);
void    obj_free(GEN S);
GEN     obj_init(long d, long n);
GEN     obj_insert(GEN S, long K, GEN O);
GEN     obj_insert_shallow(GEN S, long K, GEN O);
GEN     obj_reinit(GEN S);
void    (*os_signal(int sig, void (*f)(int)))(int);
void    pari_add_function(entree *ep);
void    pari_add_module(entree *ep);
void    pari_add_defaults_module(entree *ep);
void    pari_close(void);
void    pari_close_opts(ulong init_opts);
GEN     pari_compile_str(const char *lex);
int     pari_daemon(void);
void    pari_err(int numerr, ...);
int     pari_err_display(GEN err);
GEN     pari_err_last(void);
char *  pari_err2str(GEN err);
void    pari_init_opts(size_t parisize, ulong maxprime, ulong init_opts);
void    pari_init(size_t parisize, ulong maxprime);
void    pari_stackcheck_init(void *pari_stack_base);
void    pari_sighandler(int sig);
void    pari_sig_init(void (*f)(int));
void    pari_thread_alloc(struct pari_thread *t, size_t s, GEN arg);
void    pari_thread_close(void);
void    pari_thread_free(struct pari_thread *t);
void    pari_thread_init(void);
GEN     pari_thread_start(struct pari_thread *t);
void    pari_thread_valloc(struct pari_thread *t, size_t s, size_t v, GEN arg);
GEN     pari_version(void);
void    pari_warn(int numerr, ...);
void    paristack_newrsize(ulong newsize);
void    paristack_resize(ulong newsize);
void    paristack_setsize(size_t rsize, size_t vsize);
void    parivstack_resize(ulong newsize);
void    parivstack_reset(void);
void    setalldebug(long lvl);
GEN     setdebug(const char *s, long lvl);
void    shiftaddress(GEN x, long dec);
void    shiftaddress_canon(GEN x, long dec);
long    timer(void);
long    timer_delay(pari_timer *T);
long    timer_get(pari_timer *T);
void    timer_printf(pari_timer *T, const char *format, ...);
void    timer_start(pari_timer *T);
long    timer2(void);
void    traverseheap( void(*f)(GEN, void *), void *data );
void    unexportall(void);
void    walltimer_start(pari_timer *ti);
long    walltimer_delay(pari_timer *ti);
long    walltimer_get(pari_timer *ti);

/* intnum.c */

GEN     contfraceval(GEN CF, GEN t, long nlim);
GEN     contfracinit(GEN M, long lim);
GEN     intcirc(void *E, GEN (*eval) (void *, GEN), GEN a, GEN R, GEN tab, long prec);
GEN     intcirc0(GEN a, GEN R, GEN code, GEN tab, long prec);
GEN     intfuncinit(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, long m, long prec);
GEN     intfuncinit0(GEN a, GEN b, GEN code, long m, long prec);
GEN     intnum(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, GEN tab, long prec);
GEN     intnum0(GEN a, GEN b, GEN code, GEN tab, long prec);
GEN     intnumgauss(void *E, GEN (*eval)(void*, GEN), GEN a, GEN b, GEN tab, long prec);
GEN     intnumgauss0(GEN a, GEN b, GEN code, GEN tab, long prec);
GEN     intnumgaussinit(long n, long prec);
GEN     intnuminit(GEN a, GEN b, long m, long prec);
GEN     intnumosc(void *E, GEN (*f)(void*, GEN), GEN a, GEN H, long flag, GEN tab, long prec);
GEN     intnumosc0(GEN a, GEN H, GEN code, long flag, GEN tab, long prec);
GEN     intnumromb(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long flag, long prec);
GEN     intnumromb0(GEN a, GEN b, GEN code, long flag, long bit);
GEN     prodeulerrat(GEN F, GEN s, long a, long prec);
GEN     prodnumrat(GEN F, long a, long prec);
GEN     quodif(GEN M, long n);
GEN     sumeulerrat(GEN F, GEN s, long a, long prec);
GEN     sumnum(void *E, GEN (*eval)(void*, GEN), GEN a, GEN tab, long prec);
GEN     sumnum0(GEN a, GEN code, GEN tab, long prec);
GEN     sumnumap(void *E, GEN (*eval)(void*,GEN), GEN a, GEN tab, long prec);
GEN     sumnumap0(GEN a, GEN code, GEN tab, long prec);
GEN     sumnumapinit(GEN fast, long prec);
GEN     sumnuminit(GEN fast, long prec);
GEN     sumnumlagrange(void *E, GEN (*eval)(void*,GEN,long), GEN a, GEN tab, long prec);
GEN     sumnumlagrange0(GEN a, GEN code, GEN tab, long prec);
GEN     sumnumlagrangeinit(GEN al, GEN c1, long prec);
GEN     sumnummonien(void *E, GEN (*eval)(void*, GEN), GEN a, GEN tab, long prec);
GEN     sumnummonien0(GEN a, GEN code, GEN tab, long prec);
GEN     sumnummonieninit(GEN asymp, GEN w, GEN n0, long prec);
GEN     sumnumrat(GEN F, GEN a, long prec);
GEN     sumnumsidi(void *E, GEN (*f)(void*, GEN, long), GEN a, double mu, long prec);
GEN     sumnumsidi0(GEN a, GEN code, long safe, long prec);

/* ispower.c */

long    Z_isanypower(GEN x, GEN *y);
long    Z_ispow2(GEN x);
long    Z_ispowerall(GEN x, ulong k, GEN *pt);
long    Z_issquareall(GEN x, GEN *pt);
long    Zn_issquare(GEN x, GEN n);
long    Zp_issquare(GEN a, GEN p);
long    gisanypower(GEN x, GEN *pty);
GEN     gissquare(GEN x);
GEN     gissquareall(GEN x, GEN *pt);
long    ispolygonal(GEN x, GEN S, GEN *N);
long    ispower(GEN x, GEN k, GEN *pty);
long    isprimepower(GEN x, GEN *pty);
long    ispseudoprimepower(GEN n, GEN *pt);
long    issquare(GEN x);
long    issquareall(GEN x, GEN *pt);
GEN     sqrtint(GEN a);
GEN     sqrtint0(GEN a, GEN *r);
long    uisprimepower(ulong n, ulong *p);
long    uissquare(ulong A);
long    uissquareall(ulong A, ulong *sqrtA);
long    ulogintall(ulong B, ulong y, ulong *ptq);

/* krasner.c */

GEN     padicfields0(GEN p, GEN n, long flag);
GEN     padicfields(GEN p, long m, long d, long flag);

/* kummer.c */

GEN     bnrclassfield(GEN bnr, GEN subgroup, long flag, long prec);
GEN     rnfkummer(GEN bnr, GEN subgroup, long prec);

/* lfun.c */

long    is_linit(GEN data);
GEN     ldata_get_an(GEN ldata);
GEN     ldata_get_dual(GEN ldata);
GEN     ldata_get_gammavec(GEN ldata);
long    ldata_get_degree(GEN ldata);
GEN     ldata_get_k(GEN ldata);
GEN     ldata_get_k1(GEN ldata);
GEN     ldata_get_conductor(GEN ldata);
GEN     ldata_get_rootno(GEN ldata);
GEN     ldata_get_residue(GEN ldata);
long    ldata_get_type(GEN ldata);
long    ldata_isreal(GEN ldata);
long    linit_get_type(GEN linit);
GEN     linit_get_ldata(GEN linit);
GEN     linit_get_tech(GEN linit);
GEN     lfun_get_domain(GEN tech);
GEN     lfun_get_dom(GEN tech);
long    lfun_get_bitprec(GEN tech);
GEN     lfun_get_factgammavec(GEN tech);
GEN     lfun_get_step(GEN tech);
GEN     lfun_get_pol(GEN tech);
GEN     lfun_get_Residue(GEN tech);
GEN     lfun_get_k2(GEN tech);
GEN     lfun_get_w2(GEN tech);
GEN     lfun_get_expot(GEN tech);
long    lfun_get_bitprec(GEN tech);
GEN     lfun(GEN ldata, GEN s, long bitprec);
GEN     lfun0(GEN ldata, GEN s, long der, long bitprec);
GEN     lfunan(GEN ldata, long L, long prec);
long    lfuncheckfeq(GEN data, GEN t0, long bitprec);
GEN     lfunconductor(GEN data, GEN maxcond, long flag, long bitprec);
GEN     lfuncost(GEN lmisc, GEN dom, long der, long bitprec);
GEN     lfuncost0(GEN L, GEN dom, long der, long bitprec);
GEN     lfuncreate(GEN obj);
GEN     lfundual(GEN L, long bitprec);
GEN     lfuneuler(GEN ldata, GEN p, long prec);
GEN     lfunparams(GEN ldata, long prec);
GEN     lfunan(GEN ldata, long L, long prec);
GEN     lfunhardy(GEN ldata, GEN t, long bitprec);
GEN     lfuninit(GEN ldata, GEN dom, long der, long bitprec);
GEN     lfuninit0(GEN ldata, GEN dom, long der, long bitprec);
GEN     lfuninit_make(long t, GEN ldata, GEN tech, GEN domain);
GEN     lfunlambda(GEN ldata, GEN s, long bitprec);
GEN     lfunlambda0(GEN ldata, GEN s, long der, long bitprec);
GEN     lfunmisc_to_ldata(GEN ldata);
GEN     lfunmisc_to_ldata_shallow(GEN ldata);
GEN     lfunmisc_to_ldata_shallow_i(GEN ldata);
long    lfunorderzero(GEN ldata, long m, long bitprec);
GEN     lfunprod_get_fact(GEN tech);
GEN     lfunrootno(GEN data, long bitprec);
GEN     lfunrootres(GEN data, long bitprec);
GEN     lfunrtopoles(GEN r);
GEN     lfunshift(GEN ldata, GEN s, long flag, long bitprec);
GEN     lfuntwist(GEN ldata1, GEN ldata2, long bitprec);
GEN     lfuntheta(GEN data, GEN t, long m, long bitprec);
long    lfunthetacost0(GEN L, GEN tdom, long m, long bitprec);
long    lfunthetacost(GEN ldata, GEN tdom, long m, long bit, long *extrabit);
GEN     lfunthetainit(GEN ldata, GEN tdom, long m, long bitprec);
GEN     lfunthetacheckinit(GEN data, GEN tinf, long m, long bitprec);
GEN     lfunzeros(GEN ldata, GEN lim, long divz, long bitprec);
int     sdomain_isincl(double k, GEN dom, GEN dom0);
GEN     theta_get_an(GEN tdata);
GEN     theta_get_K(GEN tdata);
GEN     theta_get_R(GEN tdata);
long    theta_get_bitprec(GEN tdata);
long    theta_get_m(GEN tdata);
GEN     theta_get_tdom(GEN tdata);
GEN     theta_get_isqrtN(GEN tdata);
int     Vgaeasytheta(GEN Vga);
GEN     znchargauss(GEN G, GEN chi, GEN a, long bitprec);

/* lfunutils.c */

GEN     char_renormalize(GEN C, GEN o);
GEN     dirzetak(GEN nf, GEN b);
GEN     ellmoddegree(GEN e);
GEN     eta_ZXn(long v, long L);
GEN     eta_product_ZXn(GEN eta, long L);
long    etaquotype(GEN *eta, GEN *pN, GEN *pk, GEN *CHI, long *pv, long *sd, long *cusp);
GEN     galois_get_conj(GEN G); /* TODO move somewhere else? */
GEN     ldata_vecan(GEN ldata, long L, long prec);
GEN     ldata_newprec(GEN ldata, long prec);
GEN     lfunabelianrelinit(GEN bnr, GEN H, GEN dom, long der, long bitprec);
GEN     lfunartin(GEN N, GEN G, GEN M, long o, long bitprec);
GEN     lfundiv(GEN ldata1, GEN ldata2, long bitprec);
GEN     lfunellmfpeters(GEN E, long bitprec);
GEN     lfunetaquo(GEN eta);
GEN     lfungenus2(GEN PS);
GEN     lfunmfspec(GEN lmisc, long bitprec);
GEN     lfunmul(GEN ldata1, GEN ldata2, long bitprec);
GEN     lfunqf(GEN ldata, long prec);
GEN     lfunsympow(GEN E, ulong m);
GEN     lfunzetakinit(GEN pol, GEN dom, long der, long bitprec);
long    qfiseven(GEN M);

/* lfunquad */

GEN     lfunquadneg(long D, long k);

/* lll.c */

GEN     ZM_lll_norms(GEN x, double D, long flag, GEN *B);
GEN     kerint(GEN x);
GEN     lll(GEN x);
GEN     lllfp(GEN x, double D, long flag);
GEN     lllgen(GEN x);
GEN     lllgram(GEN x);
GEN     lllgramgen(GEN x);
GEN     lllgramint(GEN x);
GEN     lllgramkerim(GEN x);
GEN     lllgramkerimgen(GEN x);
GEN     lllint(GEN x);
GEN     lllintpartial(GEN mat);
GEN     lllintpartial_inplace(GEN mat);
GEN     lllkerim(GEN x);
GEN     lllkerimgen(GEN x);
GEN     matkerint0(GEN x,long flag);
GEN     qflll0(GEN x, long flag);
GEN     qflllgram0(GEN x, long flag);

/* map.c */

GEN     gtomap(GEN M);
void    mapdelete(GEN T, GEN a);
GEN     mapdomain(GEN T);
GEN     mapdomain_shallow(GEN T);
GEN     mapget(GEN T, GEN a);
int     mapisdefined(GEN T, GEN a, GEN *pt_z);
void    mapput(GEN T, GEN a, GEN b);
GEN     mapselect_shallow(void *E, long (*f)(void* E, GEN x), GEN T);
GEN     maptomat(GEN T);
GEN     maptomat_shallow(GEN T);
GEN     mapapply(GEN T, GEN a, GEN f, GEN u);

/* matperm.c */

GEN     matpermanent(GEN M);
GEN     zm_permanent(GEN M);
GEN     ZM_permanent(GEN M);

/* mellininv.c */

double  dbllemma526(double a, double b, double c, double B);
double  dblcoro526(double a, double c, double B);
GEN     gammamellininv(GEN Vga, GEN s, long m, long bitprec);
GEN     gammamellininvasymp(GEN Vga, long nlimmax, long m);
GEN     gammamellininvinit(GEN Vga, long m, long bitprec);
GEN     gammamellininvrt(GEN K, GEN s, long bitprec);

/* members.c */

GEN     member_a1(GEN x);
GEN     member_a2(GEN x);
GEN     member_a3(GEN x);
GEN     member_a4(GEN x);
GEN     member_a6(GEN x);
GEN     member_area(GEN x);
GEN     member_b2(GEN x);
GEN     member_b4(GEN x);
GEN     member_b6(GEN x);
GEN     member_b8(GEN x);
GEN     member_bid(GEN x);
GEN     member_bnf(GEN x);
GEN     member_c4(GEN x);
GEN     member_c6(GEN x);
GEN     member_clgp(GEN x);
GEN     member_codiff(GEN x);
GEN     member_cyc(GEN clg);
GEN     member_diff(GEN x);
GEN     member_disc(GEN x);
GEN     member_e(GEN x);
GEN     member_eta(GEN x);
GEN     member_f(GEN x);
GEN     member_fu(GEN x);
GEN     member_gen(GEN x);
GEN     member_group(GEN x);
GEN     member_index(GEN x);
GEN     member_j(GEN x);
GEN     member_mod(GEN x);
GEN     member_nf(GEN x);
GEN     member_no(GEN clg);
GEN     member_normfu(GEN x);
GEN     member_omega(GEN x);
GEN     member_orders(GEN x);
GEN     member_p(GEN x);
GEN     member_pol(GEN x);
GEN     member_polabs(GEN x);
GEN     member_reg(GEN x);
GEN     member_r1(GEN x);
GEN     member_r2(GEN x);
GEN     member_roots(GEN x);
GEN     member_sign(GEN x);
GEN     member_t2(GEN x);
GEN     member_tate(GEN x);
GEN     member_tu(GEN x);
GEN     member_zk(GEN x);
GEN     member_zkst(GEN bid);

/* mftrace.c */
enum { mf_NEW = 0, mf_CUSP, mf_OLD, mf_EISEN, mf_FULL };
enum {
/*leaves*/
  t_MF_CONST, t_MF_EISEN, t_MF_Ek, t_MF_DELTA, t_MF_ETAQUO, t_MF_ELL,
  t_MF_DIHEDRAL, t_MF_THETA, t_MF_TRACE, t_MF_NEWTRACE,
/**/
  t_MF_MUL, t_MF_POW, t_MF_DIV, t_MF_BRACKET, t_MF_LINEAR, t_MF_LINEAR_BHN,
  t_MF_SHIFT, t_MF_DERIV, t_MF_DERIVE2, t_MF_TWIST, t_MF_HECKE,
  t_MF_BD,
};

GEN     MF_get_CHI(GEN mf);
GEN     MF_get_M(GEN mf);
GEN     MF_get_Mindex(GEN mf);
GEN     MF_get_Minv(GEN mf);
long    MF_get_N(GEN mf);
GEN     MF_get_basis(GEN mf);
long    MF_get_dim(GEN mf);
GEN     MF_get_E(GEN mf);
GEN     MF_get_fields(GEN mf);
GEN     MF_get_gN(GEN mf);
GEN     MF_get_gk(GEN mf);
long    MF_get_k(GEN mf);
GEN     MF_get_newforms(GEN mf);
long    MF_get_r(GEN mf);
long    MF_get_space(GEN mf);
GEN     MF_get_S(GEN mf);
GEN     MFcusp_get_vMjd(GEN mf);
GEN     MFnew_get_vj(GEN mf);
GEN     Qab_tracerel(GEN v, long t, GEN a);
GEN     QabM_tracerel(GEN v, long t, GEN x);
GEN     QabV_tracerel(GEN v, long t, GEN x);
GEN     Qab_trace_init(long n, long m, GEN Pn, GEN Pm);
GEN     checkMF(GEN mf);
GEN     checkMF_i(GEN mf);
int     checkmf_i(GEN mf);
GEN     getcache(void);
ulong   hclassno6u(ulong d);
ulong   hclassno6u_no_cache(ulong D);
GEN     lfunmf(GEN mf, GEN F, long bitprec);
GEN     mfDelta(void);
GEN     mfEH(GEN gk);
GEN     mfEk(long k);
GEN     mfTheta(GEN psi);
GEN     mf_get_CHI(GEN F);
long    mf_get_N(GEN F);
GEN     mf_get_NK(GEN F);
GEN     mf_get_field(GEN F);
GEN     mf_get_gN(GEN F);
GEN     mf_get_gk(GEN F);
long    mf_get_k(GEN F);
long    mf_get_r(GEN F);
long    mf_get_type(GEN F);
GEN     mfatkin(GEN mfa, GEN F);
GEN     mfatkineigenvalues(GEN mf, long Q, long prec);
GEN     mfatkininit(GEN mf, long Q, long prec);
GEN     mfbasis(GEN mf, long space);
GEN     mfbd(GEN F, long d);
GEN     mfbracket(GEN F, GEN G, long m);
long    mfcharorder(GEN CHI);
long    mfcharmodulus(GEN CHI);
GEN     mfcharpol(GEN CHI);
GEN     mfcoef(GEN F, long n);
GEN     mfcoefs(GEN F, long n, long d);
long    mfconductor(GEN mf, GEN F);
GEN     mfcosets(GEN N);
long    mfcuspdim(long N, long k, GEN CHI);
long    mfcuspisregular(GEN NK, GEN cusp);
GEN     mfcusps(GEN gN);
GEN     mfcuspval(GEN mf, GEN F, GEN cusp, long bitprec);
long    mfcuspwidth(GEN gN, GEN cusp);
GEN     mfderiv(GEN F, long m);
GEN     mfderivE2(GEN F, long k);
GEN     mfdescribe(GEN F, GEN *PTU);
GEN     mfdim(GEN NK, long codespace);
GEN     mfdiv(GEN F, GEN G);
GEN     mfdiv_val(GEN F, GEN G, long vG);
GEN     mfeigenbasis(GEN mf);
GEN     mfeigensearch(GEN nklim, GEN vmod);
GEN     mfeisenstein(long k, GEN CHI1, GEN CHI2);
long    mfeisensteindim(long N, long k, GEN CHI);
GEN     mfembed(GEN E, GEN f);
GEN     mfembed0(GEN E, GEN v, long prec);
GEN     mfeval(GEN mf, GEN F, GEN vtau, long bitprec);
GEN     mffields(GEN mf);
GEN     mffromell(GEN E);
GEN     mffrometaquo(GEN eta, long flag);
GEN     mffromlfun(GEN L, long prec);
GEN     mffromqf(GEN Q, GEN P);
long    mffulldim(long N, long k, GEN CHI);
GEN     mfgaloisprojrep(GEN mf, GEN F, long prec);
GEN     mfgaloistype(GEN NK, GEN F);
GEN     mfhecke(GEN mf, GEN F, long n);
GEN     mfheckemat(GEN mf, GEN vecn);
GEN     mfinit(GEN NK, long space);
GEN     mfisCM(GEN F);
long    mfiscuspidal(GEN mf, GEN F);
long    mfisequal(GEN F, GEN G, long lim);
GEN     mfisetaquo(GEN F, long flag);
GEN     mfkohnenbasis(GEN mf);
GEN     mfkohnenbijection(GEN mf);
GEN     mfkohneneigenbasis(GEN mf, GEN bij);
GEN     mflinear(GEN vF, GEN vla);
GEN     mfmanin(GEN F, long bitprec);
GEN     mfmatembed(GEN E, GEN f);
GEN     mfmul(GEN F, GEN G);
long    mfnewdim(long N, long k, GEN CHI);
long    mfolddim(long N, long k, GEN CHI);
GEN     mfparams(GEN F);
GEN     mfperiodpol(GEN mf, GEN F, long flag, long prec);
GEN     mfperiodpolbasis(long k, long flag);
GEN     mfpetersson(GEN FS, GEN GS);
GEN     mfpow(GEN F, long n);
GEN     mfsearch(GEN nklim, GEN V, long space);
GEN     mfshift(GEN F, long sh);
GEN     mfshimura(GEN mf, GEN F, long t);
GEN     mfslashexpansion(GEN mf, GEN F, GEN gamma, long n, long flrat, GEN *param, long prec);
long    mfspace(GEN mf, GEN f);
GEN     mfsplit(GEN mf, long dimlim, long flag);
long    mfsturm(GEN A);
long    mfsturmNgk(long N, GEN k);
long    mfsturmNk(long N, long k);
long    mfsturm_mf(GEN mf);
GEN     mfsymboleval(GEN F, GEN path, GEN ga, long bitprec);
GEN     mfsymbol(GEN mf, GEN F, long bitprec);
GEN     mftaylor(GEN F, long n, long flreal, long prec);
GEN     mftobasis(GEN mf, GEN F, long flag);
GEN     mftobasisES(GEN mf, GEN F);
GEN     mftocol(GEN F, long lim, long d);
GEN     mftocoset(ulong N, GEN M, GEN listcosets);
GEN     mftonew(GEN mf, GEN F);
GEN     mftraceform(GEN NK, long coderat);
GEN     mftwist(GEN F, GEN D);
GEN     mfvecembed(GEN E, GEN v);
GEN     mfvectomat(GEN vF, long lim, long d);

/* mpker.c */

ulong   Fl_inv(ulong x, ulong p);
ulong   Fl_invsafe(ulong x, ulong p);
int     Fp_ratlift(GEN x, GEN m, GEN amax, GEN bmax, GEN *a, GEN *b);
GEN     ZM2_mul(GEN A, GEN B);
GEN     ZM2_sqr(GEN A);
int     abscmpii(GEN x, GEN y);
int     abscmprr(GEN x, GEN y);
int     absequalii(GEN x, GEN y);
GEN     addii_sign(GEN x, long sx, GEN y, long sy);
GEN     addir_sign(GEN x, long sx, GEN y, long sy);
GEN     addmulii(GEN x, GEN y, GEN z);
GEN     addmulii_inplace(GEN x, GEN y, GEN z);
GEN     addrr_sign(GEN x, long sx, GEN y, long sy);
GEN     addsi_sign(long x, GEN y, long sy);
GEN     addsr(long x, GEN y);
GEN     addui_sign(ulong x, GEN y, long sy);
GEN     addumului(ulong a, ulong b, GEN Y);
void    affir(GEN x, GEN y);
void    affrr(GEN x, GEN y);
GEN     bezout(GEN a, GEN b, GEN *u, GEN *v);
long    cbezout(long a,long b,long *uu,long *vv);
long    cgcd(long a,long b);
long    clcm(long a,long b);
int     cmpii(GEN x, GEN y);
int     cmprr(GEN x, GEN y);
long    dblexpo(double x);
ulong   dblmantissa(double x);
GEN     dbltor(double x);
GEN     diviiexact(GEN x, GEN y);
GEN     divir(GEN x, GEN y);
GEN     divis(GEN y, long x);
GEN     divis_rem(GEN x, long y, long *rem);
GEN     absdiviu_rem(GEN y, ulong x, ulong *rem);
GEN     diviuuexact(GEN x, ulong y, ulong z);
GEN     diviuexact(GEN x, ulong y);
GEN     divri(GEN x, GEN y);
GEN     divrr(GEN x, GEN y);
GEN     divrs(GEN x, long y);
GEN     divru(GEN x, ulong y);
GEN     divsi(long x, GEN y);
GEN     divsr(long x, GEN y);
GEN     divur(ulong x, GEN y);
GEN     dvmdii(GEN x, GEN y, GEN *z);
int     equalii(GEN x, GEN y);
int     equalrr(GEN x, GEN y);
GEN     floorr(GEN x);
GEN     gcdii(GEN x, GEN y);
GEN     halfgcdii(GEN x, GEN y);
GEN     int2n(long n);
GEN     int2u(ulong n);
GEN     int2um1(ulong n);
GEN     int_normalize(GEN x, long known_zero_words);
int     invmod(GEN a, GEN b, GEN *res);
ulong   invmod2BIL(ulong b);
GEN     invr(GEN b);
GEN     mantissa_real(GEN x, long *e);
GEN     modii(GEN x, GEN y);
GEN     mulii(GEN x, GEN y);
GEN     mulir(GEN x, GEN y);
GEN     mulrr(GEN x, GEN y);
GEN     mulsi(long x, GEN y);
GEN     mulsr(long x, GEN y);
GEN     mulss(long x, long y);
GEN     mului(ulong x, GEN y);
GEN     mulur(ulong x, GEN y);
GEN     muluu(ulong x, ulong y);
GEN     muluui(ulong x, ulong y, GEN z);
void    pari_kernel_close(void);
void    pari_kernel_init(void);
const char * pari_kernel_version(void);
GEN     remi2n(GEN x, long n);
double  rtodbl(GEN x);
GEN     shifti(GEN x, long n);
GEN     sqri(GEN x);
GEN     sqrr(GEN x);
GEN     sqrs(long x);
GEN     sqrtr_abs(GEN x);
GEN     sqrtremi(GEN S, GEN *R);
GEN     sqru(ulong x);
GEN     subsr(long x, GEN y);
GEN     truedvmdii(GEN x, GEN y, GEN *z);
GEN     truedvmdis(GEN x, long y, GEN *z);
GEN     truedvmdsi(long x, GEN y, GEN *z);
GEN     trunc2nr(GEN x, long n);
GEN     mantissa2nr(GEN x, long n);
GEN     truncr(GEN x);
ulong   ugcd(ulong a,ulong b);
ulong   ulcm(ulong a, ulong b);
ulong   umodiu(GEN y, ulong x);
long    vals(ulong x);

/* nffactor.c */

GEN     FpC_ratlift(GEN P, GEN mod, GEN amax, GEN bmax, GEN denom);
GEN     FpM_ratlift(GEN M, GEN mod, GEN amax, GEN bmax, GEN denom);
GEN     FpX_ratlift(GEN P, GEN mod, GEN amax, GEN bmax, GEN denom);
GEN     QXQX_gcd(GEN P, GEN Q, GEN T);
GEN     ZXQX_gcd(GEN P, GEN Q, GEN T);
GEN     nffactor(GEN nf,GEN x);
GEN     nffactormod(GEN nf,GEN pol,GEN pr);
GEN     nfgcd(GEN P, GEN Q, GEN nf, GEN den);
GEN     nfgcd_all(GEN P, GEN Q, GEN T, GEN den, GEN *Pnew);
int     nfissquarefree(GEN nf, GEN x);
GEN     nfroots(GEN nf,GEN pol);
GEN     nfroots_if_split(GEN *pnf, GEN pol);
GEN     nfrootsof1(GEN x);
GEN     polfnf(GEN a, GEN t);
GEN     rnfabelianconjgen(GEN nf, GEN P);
long    rnfisabelian(GEN nf, GEN pol);

/* paricfg.c */

extern const char *paricfg_datadir;
extern const char *paricfg_version;
extern const char *paricfg_buildinfo;
extern const long  paricfg_version_code;
extern const char *paricfg_vcsversion;
extern const char *paricfg_compiledate;
extern const char *paricfg_mt_engine;
extern const char *paricfg_gphelp;

/* part.c */

void    forpart(void *E, long call(void*,GEN), long k, GEN nbound, GEN abound);
void    forpart_init(forpart_t *T, long k, GEN abound, GEN nbound);
GEN     forpart_next(forpart_t *T);
GEN     forpart_prev(forpart_t *T);
void    forpart0(GEN k, GEN code, GEN nbound, GEN abound);
GEN     numbpart(GEN x);
GEN     partitions(long k, GEN nbound, GEN abound);

/* forperm.c */

void    forperm(void *E, long call(void *, GEN), GEN k);
void    forperm_init(forperm_t *T, GEN k);
GEN     forperm_next(forperm_t *T);
void    forperm0(GEN k, GEN code);

/* forsubset.c */

void    forallsubset_init(forsubset_t *T, long n);
void    forksubset_init(forsubset_t *T, long n, long k);
GEN     forsubset_next(forsubset_t *T);
void    forsubset_init(forsubset_t *T, GEN nk);
void    forsubset0(GEN nk, GEN code);

/* lambert.c */

double  dbllambertW0(double a);
double  dbllambertW_1(double a);
GEN     glambertW(GEN y, long branch, long prec);
GEN     mplambertW(GEN y, long prec);
GEN     mplambertX(GEN y, long bit);
GEN     mplambertx_logx(GEN a, GEN b, long bit);
GEN     mplambertxlogx_x(GEN a, GEN b, long bit);

/* perm.c */

GEN     Z_to_perm(long n, GEN x);
GEN     abelian_group(GEN G);
GEN     conjclasses_repr(GEN conj, long nb);
GEN     cyc_pow(GEN cyc, long exp);
GEN     cyc_pow_perm(GEN cyc, long exp);
GEN     cyclicgroup(GEN g, long s);
GEN     dicyclicgroup(GEN g1, GEN g2, long s1, long s2);
GEN     group_abelianHNF(GEN G, GEN L);
GEN     group_abelianSNF(GEN G, GEN L);
long    group_domain(GEN G);
GEN     group_elts(GEN G, long n);
GEN     group_export(GEN G, long format);
GEN     group_export_GAP(GEN G);
GEN     group_export_MAGMA(GEN G);
long    group_isA4S4(GEN G);
long    group_isabelian(GEN G);
GEN     group_leftcoset(GEN G, GEN g);
long    group_order(GEN G);
long    group_perm_normalize(GEN N, GEN g);
GEN     group_quotient(GEN G, GEN H);
GEN     group_rightcoset(GEN G, GEN g);
GEN     group_set(GEN G, long n);
int     group_subgroup_is_faithful(GEN G, GEN H);
long    group_subgroup_isnormal(GEN G, GEN H);
GEN     group_subgroups(GEN G);
GEN     groupelts_solvablesubgroups(GEN G);
GEN     group_to_cc(GEN G);
GEN     groupelts_abelian_group(GEN S);
GEN     groupelts_center(GEN S);
GEN     groupelts_conj_set(GEN elts, GEN p);
GEN     groupelts_conjclasses(GEN elts, long *nbcl);
long    groupelts_exponent(GEN G);
GEN     groupelts_quotient(GEN G, GEN H);
GEN     groupelts_set(GEN G, long n);
GEN     groupelts_to_group(GEN G);
GEN     numtoperm(long n, GEN x);
int     perm_commute(GEN p, GEN q);
GEN     perm_cycles(GEN v);
GEN     perm_order(GEN perm);
ulong   perm_orderu(GEN perm);
GEN     perm_pow(GEN perm, GEN exp);
GEN     perm_powu(GEN perm, ulong exp);
long    perm_sign(GEN perm);
GEN     perm_to_GAP(GEN v);
GEN     perm_to_Z(GEN v);
GEN     permcycles(GEN perm);
GEN     permorder(GEN perm);
long    permsign(GEN perm);
GEN     permtonum(GEN x);
GEN     quotient_group(GEN C, GEN G);
GEN     quotient_groupelts(GEN C);
GEN     quotient_perm(GEN C, GEN p);
GEN     quotient_subgroup_lift(GEN C, GEN H, GEN S);
GEN     subgroups_tableset(GEN S, long n);
long    tableset_find_index(GEN tbl, GEN set);
GEN     trivialgroup(void);
GEN     vec_insert(GEN v, long n, GEN x);
int     vec_is1to1(GEN v);
int     vec_isconst(GEN v);
GEN     vecperm_orbits(GEN v, long n);
long    vecsmall_duplicate(GEN x);
long    vecsmall_duplicate_sorted(GEN x);
GEN     vecsmall_indexsort(GEN V);
int     vecsmall_is1to1(GEN v);
int     vecsmall_isconst(GEN v);
void    vecsmall_sort(GEN V);
GEN     vecsmall_uniq(GEN V);
GEN     vecsmall_uniq_sorted(GEN V);
GEN     vecsmall_counting_indexsort(GEN v, long M);
void    vecsmall_counting_sort(GEN v, long M);
GEN     vecsmall_counting_uniq(GEN v, long M);
GEN     vecvecsmall_indexsort(GEN x);
long    vecvecsmall_max(GEN x);
long    vecvecsmall_search(GEN x, GEN y);
GEN     vecvecsmall_sort(GEN x);
void    vecvecsmall_sort_inplace(GEN x, GEN *perm);
GEN     vecvecsmall_sort_shallow(GEN x);
GEN     vecvecsmall_sort_uniq(GEN x);

/* mt.c */

void    mt_broadcast(GEN code);
long    mt_nbthreads(void);
void    mt_queue_end(struct pari_mt *pt);
GEN     mt_queue_get(struct pari_mt *pt, long *jobid, long *pending);
void    mt_queue_start(struct pari_mt *pt, GEN worker);
void    mt_queue_start_lim(struct pari_mt *pt, GEN worker, long lim);
void    mt_queue_submit(struct pari_mt *pt, long jobid, GEN work);
void    mt_sigint_block(void);
void    mt_sigint_unblock(void);
void    pari_mt_init(void);
void    pari_mt_close(void);

/* pclgp.c */

GEN     subcyclopclgp(GEN fH, GEN p, long flag);
GEN     subcycloiwasawa(GEN fH, GEN p, long n);
GEN     subcyclohminus(GEN fH, GEN p);

/* plotport.c */

void    color_to_rgb(GEN c, int *r, int *g, int *b);
void    colorname_to_rgb(const char *s, int *r, int *g, int *b);
void    long_to_rgb(long c, int *r, int *g, int *b);
void    pari_plot_by_file(const char *env, const char *suf, const char *img);
void    pari_set_plot_engine(void (*plot)(PARI_plot *));
void    pari_kill_plot_engine(void);
GEN     parploth(GEN a, GEN b, GEN code, long flags,long n, long prec);
GEN     parplothexport(GEN fmt, GEN a, GEN b, GEN code, long flags, long n, long prec);
void    plotarc(long ne, GEN gx2, GEN gy2, long fl);
void    plotbox(long ne, GEN gx2, GEN gy2, long fl);
void    plotclip(long rect);
GEN     plotcolor(long ne, GEN c);
void    plotcopy(long source, long dest, GEN xoff, GEN yoff, long flag);
GEN     plotcursor(long ne);
void    plotdraw(GEN list, long flag);
GEN     plotexport(GEN fmt, GEN wxy, long flag);
GEN     ploth(void *E, GEN(*f)(void*,GEN), GEN a, GEN b, long flags,long n, long prec);
GEN     ploth0(GEN a, GEN b, GEN code, long flag, long n, long prec);
GEN     plothexport(GEN fmt, void *E, GEN(*f)(void*,GEN), GEN a,GEN b, long flags, long n, long prec);
GEN     plothexport0(GEN fmt, GEN a, GEN b, GEN code, long flags, long n, long prec);
GEN     plothraw(GEN listx, GEN listy, long flag);
GEN     plothrawexport(GEN fmt, GEN X, GEN Y, long flags);
GEN     plothsizes(long flag);
void    plotinit(long ne, GEN x, GEN y, long flag);
void    plotkill(long ne);
void    plotline(long ne, GEN gx2, GEN gy2);
void    plotlines(long ne, GEN listx, GEN listy, long flag);
void    plotlinetype(long ne, long t);
void    plotmove(long ne, GEN x, GEN y);
void    plotpoints(long ne, GEN listx, GEN listy);
void    plotpointsize(long ne, GEN size);
void    plotpointtype(long ne, long t);
void    plotrbox(long ne, GEN x2, GEN y2, long fl);
GEN     plotrecth(void *E, GEN(*f)(void*,GEN), long ne, GEN a,GEN b, long flags,long n, long prec);
GEN     plotrecth0(long ne,GEN a,GEN b,GEN code, long flags,long n,long prec);
GEN     plotrecthraw(long ne, GEN data, long flags);
void    plotrline(long ne, GEN x2, GEN y2);
void    plotrmove(long ne, GEN x, GEN y);
void    plotrpoint(long ne, GEN x, GEN y);
void    plotscale(long ne, GEN x1, GEN x2, GEN y1, GEN y2);
void    plotstring(long ne, const char *x, long dir);
void    psdraw(GEN list, long flag);
GEN     psploth(void *E, GEN(*f)(void*,GEN), GEN a, GEN b, long flags, long n, long prec);
GEN     psploth0(GEN a,GEN b,GEN code,long flag,long n,long prec);
GEN     psplothraw(GEN listx, GEN listy, long flag);
char*   rect2ps(GEN w, GEN x, GEN y, PARI_plot *T);
char*   rect2ps_i(GEN w, GEN x, GEN y, PARI_plot *T, int plotps);
char*   rect2svg(GEN w, GEN x, GEN y, PARI_plot *T);

/* plottty.c */

void    pariplot(void* E, GEN (*fun)(void *E, GEN x), GEN a, GEN b, GEN ysmlu,GEN ybigu, long prec);
void    pariplot0(GEN a, GEN b, GEN code, GEN ysmlu, GEN ybigu, long prec);

/* polarit1.c */

GEN     ZX_Zp_root(GEN f, GEN a, GEN p, long prec);
GEN     Zp_appr(GEN f, GEN a);
int     cmp_padic(GEN x, GEN y);
GEN     factorpadic(GEN x, GEN p, long r);
GEN     gdeuc(GEN x, GEN y);
GEN     grem(GEN x, GEN y);
GEN     padicappr(GEN f, GEN a);
GEN     poldivrem(GEN x, GEN y, GEN *pr);
GEN     polrootspadic(GEN f, GEN p, long r);

/* polarit2.c */

ulong   Flv_factorback(GEN L, GEN e, ulong p);
GEN     FlxqV_factorback(GEN L, GEN e, GEN Tp, ulong p);
GEN     FpV_factorback(GEN L, GEN e, GEN p);
GEN     FqV_factorback(GEN L, GEN e, GEN Tp, GEN p);
GEN     Q_content(GEN x);
GEN     Q_content_safe(GEN x);
GEN     Q_denom(GEN x);
GEN     Q_denom_safe(GEN x);
GEN     Q_div_to_int(GEN x, GEN c);
GEN     Q_gcd(GEN x, GEN y);
GEN     Q_mul_to_int(GEN x, GEN c);
GEN     Q_muli_to_int(GEN x, GEN d);
GEN     Q_primitive_part(GEN x, GEN *ptc);
GEN     Q_primpart(GEN x);
GEN     Q_remove_denom(GEN x, GEN *ptd);
GEN     Q_factor(GEN x);
GEN     Q_factor_limit(GEN x, ulong lim);
long    Rg_type(GEN x, GEN *ptp, GEN *ptpol, long *ptpa);
long    RgM_RgC_type(GEN x, GEN y, GEN *p, GEN *pol, long *pa);
GEN     RgM_rescale_to_int(GEN x);
long    RgM_type(GEN x, GEN *p, GEN *pol, long *pa);
long    RgM_type2(GEN x, GEN y, GEN *p, GEN *pol, long *pa);
long    RgV_type(GEN x, GEN *p, GEN *pol, long *pa);
long    RgV_type2(GEN x, GEN y, GEN *p, GEN *pol, long *pa);
long    RgX_Rg_type(GEN x, GEN y, GEN *p, GEN *pol, long *pa);
GEN     RgX_chinese_coprime(GEN x, GEN y, GEN Tx, GEN Ty, GEN Tz);
GEN     RgX_disc(GEN x);
GEN     RgX_extgcd(GEN x, GEN y, GEN *U, GEN *V);
GEN     RgX_extgcd_simple(GEN a, GEN b, GEN *pu, GEN *pv);
GEN     RgX_gcd(GEN x, GEN y);
GEN     RgX_gcd_simple(GEN x, GEN y);
GEN     RgX_halfgcd(GEN x, GEN y);
GEN     RgX_halfgcd_all(GEN x, GEN y, GEN *a, GEN *b);
GEN     RgX_rescale_to_int(GEN x);
GEN     RgX_resultant_all(GEN P, GEN Q, GEN *sol);
long    RgX_sturmpart(GEN x, GEN ab);
GEN     RgX_sylvestermatrix(GEN x, GEN y);
long    RgX_type(GEN x, GEN *ptp, GEN *ptpol, long *ptpa);
long    RgX_type2(GEN x, GEN y, GEN *ptp, GEN *ptpol, long *ptpa);
long    RgX_type3(GEN x, GEN y, GEN z, GEN *ptp, GEN *ptpol, long *ptpa);
void    RgX_type_decode(long x, long *t1, long *t2);
int     RgX_type_is_composite(long t);
GEN     RgXQ_charpoly(GEN x, GEN T, long v);
GEN     RgXQ_inv(GEN x, GEN y);
GEN     RgXQ_minpoly(GEN x, GEN T, long v);
GEN     RgXQ_mul(GEN x, GEN y, GEN T);
int     RgXQ_ratlift(GEN y, GEN x, long amax, long bmax, GEN *P, GEN *Q);
GEN     RgXQ_sqr(GEN x, GEN y);
GEN     Z_content(GEN x);
GEN     ZX_content(GEN x);
GEN     centermod(GEN x, GEN p);
GEN     centermod_i(GEN x, GEN p, GEN ps2);
GEN     centermodii(GEN x, GEN p, GEN po2);
GEN     content(GEN x);
GEN     content0(GEN x, GEN D);
GEN     deg1_from_roots(GEN L, long v);
GEN     factor(GEN x);
GEN     factor0(GEN x, GEN flag);
GEN     factorback(GEN fa);
GEN     factorback2(GEN fa,GEN e);
GEN     gbezout(GEN x, GEN y, GEN *u, GEN *v);
GEN     gdivexact(GEN x, GEN y);
GEN     gen_factorback(GEN L, GEN e, void *E, GEN (*_mul)(void*,GEN,GEN),
                                              GEN (*_pow)(void*,GEN,GEN),
                                              GEN (*_one)(void*));
GEN     ggcd(GEN x, GEN y);
GEN     ggcd0(GEN x, GEN y);
GEN     ghalfgcd(GEN x, GEN y);
GEN     ginvmod(GEN x, GEN y);
GEN     glcm(GEN x, GEN y);
GEN     glcm0(GEN x, GEN y);
GEN     newtonpoly(GEN x, GEN p);
GEN     nfrootsQ(GEN x);
GEN     poldisc0(GEN x, long v);
GEN     polfromroots(GEN a, long v);
long    polisirreducible(GEN x);
GEN     polresultant0(GEN x, GEN y,long v,long flag);
GEN     polsym(GEN x, long n);
GEN     primitive_part(GEN x, GEN *c);
GEN     primpart(GEN x);
GEN     reduceddiscsmith(GEN pol);
GEN     resultant2(GEN x, GEN y);
GEN     resultant(GEN u, GEN v);
GEN     rnfcharpoly(GEN nf, GEN T, GEN alpha, long v);
GEN     roots_from_deg1(GEN x);
GEN     roots_to_pol(GEN a, long v);
GEN     roots_to_pol_r1(GEN a, long v, long r1);
long    sturmpart(GEN x, GEN a, GEN b);
GEN     subresext(GEN x, GEN y, GEN *U, GEN *V);
GEN     sylvestermatrix(GEN x,GEN y);
GEN     trivial_fact(void);
GEN     gcdext0(GEN x, GEN y);
GEN     polresultantext0(GEN x, GEN y, long v);
GEN     polresultantext(GEN x, GEN y);
GEN     prime_fact(GEN x);
GEN     row_Q_primpart(GEN M);
GEN     vec_Q_primpart(GEN M);
GEN     vecprod(GEN v);
GEN     ZV_lcm(GEN x);

/* polarit3.c */

GEN     Flx_FlxY_resultant(GEN a, GEN b, ulong p);
GEN     FlxX_resultant(GEN u, GEN v, ulong p, long sx);
GEN     FlxX_resultant_pre(GEN a, GEN b, ulong p, ulong pi, long sx);
GEN     FpX_Fp_translate(GEN P, GEN c, GEN p);
GEN     FpX_FpXY_resultant(GEN a, GEN b0, GEN p);
GEN     FpXQX_FpXQ_translate(GEN P, GEN c, GEN T, GEN p);
GEN     FpXQX_normalize(GEN z, GEN T, GEN p);
GEN     FpXV_FpC_mul(GEN V, GEN W, GEN p);
GEN     FpXY_FpXQ_evaly(GEN Q, GEN y, GEN T, GEN p, long vx);
GEN     FpXC_center(GEN C, GEN p, GEN pov2);
GEN     FpXM_center(GEN M, GEN p, GEN pov2);
GEN     Fq_Fp_mul(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_add(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     Fq_div(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_halve(GEN x, GEN T/*unused*/, GEN p);
GEN     Fq_inv(GEN x, GEN T, GEN p);
GEN     Fq_invsafe(GEN x, GEN T, GEN p);
GEN     Fq_mul(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_mulu(GEN x, ulong y, /*unused*/GEN T, GEN p);
GEN     Fq_neg(GEN x, GEN T, GEN p);
GEN     Fq_neg_inv(GEN x, GEN T, GEN p);
GEN     Fq_pow(GEN x, GEN n, GEN T, GEN p);
GEN     Fq_powu(GEN x, ulong n, GEN pol, GEN p);
GEN     Fq_sqr(GEN x, GEN T, GEN p);
GEN     Fq_sqrt(GEN x, GEN T, GEN p);
GEN     Fq_sqrtn(GEN x, GEN n, GEN T, GEN p, GEN *zeta);
GEN     Fq_sub(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     FqC_Fq_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FqC_FqV_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FqC_add(GEN x, GEN y, GEN T, GEN p);
GEN     FqC_red(GEN x, GEN T, GEN p);
GEN     FqC_sub(GEN x, GEN y, GEN T, GEN p);
GEN     FqC_to_FlxqC(GEN x, GEN T, ulong p);
GEN     FqM_red(GEN x, GEN T, GEN p);
GEN     FqM_add(GEN x, GEN y, GEN T, GEN p);
GEN     FqM_sub(GEN x, GEN y, GEN T, GEN p);
GEN     FqM_to_FlxqM(GEN x, GEN T, ulong p);
GEN     FqV_red(GEN x, GEN T, GEN p);
GEN     FqV_roots_to_pol(GEN V, GEN T, GEN p, long v);
GEN     FqX_Fq_add(GEN y, GEN x, GEN T, GEN p);
GEN     FqX_Fq_mul_to_monic(GEN P, GEN U, GEN T, GEN p);
GEN     FqX_Fq_sub(GEN y, GEN x, GEN T, GEN p);
GEN     FqX_eval(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_Fq_translate(GEN P, GEN c, GEN T, GEN p);
GEN     FqXQ_matrix_pow(GEN y, long n, long m, GEN S, GEN T, GEN p);
GEN     FqXQ_powers(GEN x, long l, GEN S, GEN T, GEN p);
GEN     FqXY_eval(GEN Q, GEN y, GEN x, GEN T, GEN p);
GEN     FqXY_evalx(GEN Q, GEN x, GEN T, GEN p);
GEN     QX_disc(GEN x);
GEN     QX_gcd(GEN a,GEN b);
GEN     QX_resultant(GEN A, GEN B);
GEN     QXQ_div(GEN A, GEN B, GEN C);
GEN     QXQ_intnorm(GEN A, GEN B);
GEN     QXQ_inv(GEN A, GEN B);
GEN     QXQ_mul(GEN A, GEN B, GEN T);
GEN     QXQ_norm(GEN A, GEN B);
GEN     QXQ_sqr(GEN A, GEN B);
int     Rg_is_Fp(GEN x, GEN *p);
int     Rg_is_FpXQ(GEN x, GEN *pT, GEN *pp);
GEN     Rg_to_Fp(GEN x, GEN p);
GEN     Rg_to_FpXQ(GEN x, GEN T, GEN p);
GEN     RgC_to_FpC(GEN x, GEN p);
GEN     RgC_to_FqC(GEN x, GEN T, GEN p);
int     RgM_is_FpM(GEN x, GEN *p);
GEN     RgM_to_Flm(GEN x, ulong p);
GEN     RgM_to_FpM(GEN x, GEN p);
GEN     RgM_to_FqM(GEN x, GEN T, GEN p);
int     RgV_is_FpV(GEN x, GEN *p);
GEN     RgV_to_Flv(GEN x, ulong p);
GEN     RgV_to_FpV(GEN x, GEN p);
int     RgX_is_FpX(GEN x, GEN *p);
GEN     RgX_to_FpX(GEN x, GEN p);
int     RgX_is_FpXQX(GEN x, GEN *pT, GEN *pp);
GEN     RgX_to_FpXQX(GEN x, GEN T, GEN p);
GEN     RgX_to_FqX(GEN x, GEN T, GEN p);
int     RgX_is_ZXX(GEN x, long *v);
int     Z_incremental_CRT(GEN *H, ulong Hp, GEN *q, ulong p);
GEN     Z_init_CRT(ulong Hp, ulong p);
int     ZM_incremental_CRT(GEN *H, GEN Hp, GEN *q, ulong p);
GEN     ZM_init_CRT(GEN Hp, ulong p);
GEN     ZX_ZXY_resultant(GEN a, GEN b);
GEN     ZX_ZXY_rnfequation(GEN A, GEN B, long *lambda);
GEN     ZX_disc(GEN x);
int     ZX_incremental_CRT(GEN *ptH, GEN Hp, GEN *q, ulong p);
GEN     ZX_init_CRT(GEN Hp, ulong p, long v);
int     ZX_is_squarefree(GEN x);
GEN     ZX_radical(GEN A);
GEN     ZX_resultant(GEN A, GEN B);
int     ZXM_incremental_CRT(GEN *pH, GEN Hp, GEN *ptq, ulong p);
GEN     ZXM_init_CRT(GEN Hp, long deg, ulong p);
GEN     ZXQ_minpoly(GEN A, GEN T, long d, ulong b);
GEN     ZXQ_charpoly(GEN A, GEN T, long v);
GEN     ZXX_resultant(GEN a, GEN b, long v);
GEN     characteristic(GEN x);
GEN     ffinit(GEN p, long n, long v);
GEN     ffnbirred(GEN p, long n);
GEN     ffnbirred0(GEN p, long n, long flag);
GEN     ffsumnbirred(GEN p, long n);
const struct bb_field *get_Fq_field(void **E, GEN T, GEN p);
GEN     init_Flxq(ulong p, long n, long v);
GEN     init_Fq(GEN p, long n, long v);
GEN     nfX_disc(GEN nf, GEN x);
GEN     nfX_resultant(GEN nf, GEN x, GEN y);
GEN     pol_x_powers(long N, long v);
GEN     residual_characteristic(GEN x);

/* polclass.c */

GEN     polclass(GEN D, long inv, long vx);

/* polmodular.c */

GEN     Fp_modinv_to_j(GEN x, long inv, GEN p);
GEN     Fp_polmodular_evalx(long L, long inv, GEN J, GEN P, long v, int compute_derivs);
void    check_modinv(long inv);
long    disc_best_modinv(long D);
long    modinv_height_factor(long inv);
int     modinv_good_disc(long inv, long D);
int     modinv_good_prime(long inv, long p);
int     modinv_is_Weber(long inv);
int     modinv_is_double_eta(long inv);
GEN     polmodular(long L, long inv, GEN x, long vy, long compute_derivs);
GEN     polmodular_ZM(long L, long inv);
GEN     polmodular_ZXX(long L, long inv, long vx, long vy);

/* prime.c */

long    BPSW_isprime(GEN x);
long    BPSW_psp(GEN N);
GEN     addprimes(GEN primes);
long    check_ecppcert(GEN c);
GEN     gisprime(GEN x, long flag);
GEN     gispseudoprime(GEN x, long flag);
GEN     gprimepi_upper_bound(GEN x);
GEN     gprimepi_lower_bound(GEN x);
long    isprime(GEN x);
long    ispseudoprime(GEN x, long flag);
long    millerrabin(GEN n, long k);
GEN     prime(long n);
long    PRIMES_search(ulong x);
GEN     primecert(GEN x, long flag);
GEN     primecert0(GEN x, long flag, long stopat);
GEN     primecertexport(GEN cert, long flag);
long    primecertisvalid(GEN x);
GEN     primepi(GEN x);
double  primepi_upper_bound(double x);
double  primepi_lower_bound(double x);
GEN     primes(long n);
GEN     primes_interval(GEN a, GEN b);
GEN     primes_interval_zv(ulong a, ulong b);
GEN     primes_upto_zv(ulong b);
GEN     primes0(GEN n);
GEN     primes_zv(long m);
GEN     randomprime(GEN N);
GEN     randomprime0(GEN N, GEN q);
GEN     removeprimes(GEN primes);
int     uis2psp(ulong n);
int     uispsp(ulong a, ulong n);
int     uislucaspsp(ulong n);
int     uisprime(ulong n);
int     uisprime_101(ulong n);
int     uisprime_661(ulong n);
ulong   uprime(long n);
ulong   uprimepi(ulong n);

/* qfisom.c */

GEN     qfauto(GEN g, GEN flags);
GEN     qfauto0(GEN g, GEN flags);
GEN     qfautoexport(GEN g, long flag);
GEN     qfisom(GEN g, GEN h, GEN flags, GEN G);
GEN     qfisom0(GEN g, GEN h, GEN flags, GEN G);
GEN     qfisominit(GEN g, GEN flags, GEN minvec);
GEN     qfisominit0(GEN g, GEN flags, GEN minvec);
GEN     qforbits(GEN G, GEN V);

/* qfparam.c */

GEN     qfminimize(GEN G);
GEN     qfparam(GEN G, GEN sol, long fl);
GEN     qfsolve(GEN G);

/* quad.c */

long    Z_isfundamental(GEN x);
GEN     classno(GEN x);
GEN     classno2(GEN x);
GEN     hclassnoF_fact(GEN P, GEN E, GEN D);
GEN     hclassno(GEN x);
GEN     hclassno6(GEN x);
long    isfundamental(GEN x);
int     qfb_equal1(GEN f);
GEN     qfbclassno0(GEN x,long flag);
GEN     qfi_Shanks(GEN a, GEN g, long n);
GEN     qfi_log(GEN a, GEN g, GEN o);
GEN     qfi_order(GEN q, GEN o);
GEN     quadclassnoF(GEN x, GEN *pD);
GEN     quadclassnoF_fact(GEN D, GEN P, GEN E);
GEN     quaddisc(GEN x);
GEN     quadregulator(GEN x, long prec);
GEN     quadunit(GEN x);
GEN     quadunit0(GEN x, long v);
GEN     quadunitindex(GEN x, GEN N);
long    quadunitnorm(GEN x);
long    sisfundamental(long x);
long    uhclassnoF_fact(GEN faF, long D);
long    unegisfundamental(ulong x);
ulong   unegquadclassnoF(ulong x, ulong *pD);
long    uposisfundamental(ulong x);
ulong   uposquadclassnoF(ulong x, ulong *pD);
ulong   uquadclassnoF_fact(ulong d, long s, GEN P, GEN E);
GEN     Zn_quad_roots(GEN N, GEN B, GEN C);
GEN     Zn_sqrtall(GEN D, GEN  fa);

/* random.c */

GEN     genrand(GEN N);
GEN     getrand(void);
ulong   pari_rand(void);
GEN     randomi(GEN x);
GEN     randomr(long prec);
GEN     random_F2x(long d, long vs);
ulong   random_Fl(ulong n);
long    random_bits(long k);
GEN     random_zv(long n);
void    setrand(GEN seed);

/* ratpoints.c */

GEN     ellratpoints(GEN E, GEN h, long flag);
GEN     hyperellratpoints(GEN P, GEN h, long flag);

/* rootpol.c */

GEN     QX_complex_roots(GEN p, long l);
GEN     FFT(GEN W, GEN x);
GEN     FFTinv(GEN W, GEN x);
GEN     cleanroots(GEN x,long l);
double  dbllog2(GEN z);
double  fujiwara_bound(GEN p);
double  fujiwara_bound_real(GEN p, long sign);
int     isrealappr(GEN x, long l);
GEN     polgraeffe(GEN p);
GEN     polmod_to_embed(GEN x, long prec);
GEN     polrootsbound(GEN p, GEN tau);
GEN     roots(GEN x,long l);
GEN     realroots(GEN P, GEN ab, long prec);
GEN     ZX_graeffe(GEN p);
GEN     ZX_realroots_irred(GEN P, long prec);
long    ZX_sturm(GEN P);
long    ZX_sturm_irred(GEN P);
long    ZX_sturmpart(GEN P, GEN ab);
GEN     ZX_Uspensky(GEN P, GEN ab, long flag, long prec);

/* subcyclo.c */

GEN     factor_Aurifeuille(GEN p, long n);
GEN     factor_Aurifeuille_prime(GEN p, long n);
GEN     galoissubcyclo(GEN N, GEN sg, long flag, long v);
GEN     polsubcyclo(long n, long d, long v);
GEN     polsubcyclofast(GEN n, long ell, long s, long fli);
GEN     znsubgroupgenerators(GEN H, long flag);

/* subfield.c */

GEN     nfsubfields(GEN nf, long d);
GEN     nfsubfields0(GEN nf, long d, long flag);
GEN     nfsubfieldscm(GEN nf, long flag);
GEN     nfsubfieldsmax(GEN nf, long flag);

/* nflist.c */
GEN     nflist(GEN GP, GEN V, long s, GEN field);
GEN     nfresolvent(GEN pol, long flag);

/* subgroup.c */

GEN     subgrouplist(GEN cyc, GEN bound);
void    forsubgroup(void *E, long fun(void*,GEN), GEN cyc, GEN B);
void    forsubgroup0(GEN cyc, GEN bound, GEN code);

/* stark.c */

GEN     abmap_kernel(GEN S);
GEN     abmap_subgroup_image(GEN S, GEN H);
GEN     bnrL1(GEN bnr, GEN sbgrp, long flag, long prec);
GEN     bnrrootnumber(GEN bnr, GEN chi, long flag, long prec);
GEN     bnrstark(GEN bnr, GEN subgroup, long prec);
GEN     bnrstarkunit(GEN bnr, GEN subgroup);
GEN     cyc2elts(GEN cyc);
GEN     qfbforms(GEN D);
GEN     quadhilbert(GEN D, long prec);
GEN     quadray(GEN bnf, GEN f, long prec);

/* str.c */

GEN     chartoGENstr(char c);
GEN     pari_base64(const char *s);
char*   pari_strdup(const char *s);
char*   pari_strndup(const char *s, long n);
GEN     pari_strchr(GEN g);
char*   stack_strcat(const char *s, const char *t);
char*   stack_strdup(const char *s);
GEN     strjoin(GEN v, GEN p);
GEN     strntoGENstr(const char *s, long n0);
GEN     strsplit(GEN x, GEN p);
GEN     strtoGENstr(const char *s);
const char* type_name(long t);
GEN     type0(GEN x);

/* sumiter.c */

GEN     asympnum(void *E, GEN (*f)(void *,GEN,long), GEN alpha, long prec);
GEN     asympnum0(GEN u, GEN alpha, long prec);
GEN     asympnumraw(void *E, GEN (*f)(void *,GEN,long), long LIM, GEN alpha, long prec);
GEN     asympnumraw0(GEN u, long LIM, GEN alpha, long prec);
GEN     derivnum(void *E, GEN (*eval)(void *, GEN, long prec), GEN x, long prec);
GEN     derivnum0(GEN a, GEN code, GEN ind, long prec);
GEN     derivnumk(void *E, GEN (*eval)(void *, GEN, long), GEN x, GEN ind0, long prec);
GEN     derivfun(void *E, GEN (*eval)(void *, GEN, long prec), GEN x, long prec);
GEN     derivfunk(void *E, GEN (*eval)(void *, GEN, long), GEN x, GEN ind0, long prec);
GEN     direuler0(GEN a, GEN b, GEN code, GEN c);
void    fordiv(GEN a, GEN code);
void    fordivfactored(GEN a, GEN code);
void    foreachpari(GEN a, GEN code);
void    forfactored(GEN a, GEN b, GEN code);
void    forpari(GEN a, GEN b, GEN code);
void    forsquarefree(GEN a, GEN b, GEN code);
void    forstep(GEN a, GEN b, GEN s, GEN code);
void    forvec(GEN x, GEN code, long flag);
int     forvec_init(forvec_t *T, GEN x, long flag);
GEN     forvec_next(forvec_t *T);
GEN     iferrpari(GEN a, GEN b, GEN c);
GEN     laurentseries(void *E, GEN (*f)(void*,GEN x, long), long M, long v, long prec);
GEN     laurentseries0(GEN f, long M, long v, long prec);
GEN     limitnum(void *E, GEN (*f)(void *,GEN,long), GEN alpha, long prec);
GEN     limitnum0(GEN u, GEN alpha, long prec);
GEN     matrice(GEN nlig, GEN ncol, GEN code);
GEN     polzag(long n, long m);
GEN     prodeuler(void *E, GEN (*eval)(void *, GEN), GEN ga, GEN gb, long prec);
GEN     prodeuler0(GEN a, GEN b, GEN code, long prec);
GEN     prodinf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     prodinf0(GEN a, GEN code, long flag, long prec);
GEN     prodinf1(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     produit(GEN a, GEN b, GEN code, GEN x);
GEN     solvestep(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, GEN step, long flag, long prec);
GEN     solvestep0(GEN a, GEN b, GEN step, GEN code, long flag, long prec);
GEN     somme(GEN a, GEN b, GEN code, GEN x);
GEN     sumalt(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumalt0(GEN a, GEN code, long flag, long prec);
GEN     sumalt2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumdivexpr(GEN num, GEN code);
GEN     sumdivmultexpr(void *D, GEN (*fun)(void*, GEN), GEN num);
GEN     sumdivmultexpr0(GEN num, GEN code);
GEN     suminf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     suminf0(GEN a, GEN code, long bit);
GEN     sumpos(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumpos0(GEN a, GEN code, long flag, long prec);
GEN     sumpos2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
void    untilpari(GEN a, GEN b);
GEN     vecteursmall(GEN nmax, GEN code);
GEN     vecteur(GEN nmax, GEN n);
GEN     vvecteur(GEN nmax, GEN n);
void    whilepari(GEN a, GEN b);
GEN     zbrent(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long prec);
GEN     zbrent0(GEN a, GEN b, GEN code, long prec);

/* thue.c */

GEN     bnfisintnorm(GEN x, GEN y);
GEN     bnfisintnorm0(GEN x, GEN y, long flag);
GEN     bnfisintnormabs(GEN bnf, GEN a);
GEN     bnfisintnormabs0(GEN bnf, GEN a, long flag);
GEN     ideals_by_norm(GEN nf, GEN a);
GEN     thue(GEN thueres, GEN rhs, GEN ne);
GEN     thueinit(GEN pol, long flag, long prec);

/* trans1.c */

GEN     Pi2n(long n, long prec);
GEN     PiI2(long prec);
GEN     PiI2n(long n, long prec);
GEN     Qp_exp(GEN x);
long    Qp_exp_prec(GEN x);
GEN     Qp_log(GEN x);
GEN     Qp_sqrt(GEN x);
GEN     Qp_sqrtn(GEN x, GEN n, GEN *zetan);
GEN     Zn_sqrt(GEN x, GEN n);
GEN     Zp_teichmuller(GEN x, GEN p, long n, GEN q);
GEN     agm(GEN x, GEN y, long prec);
GEN     constcatalan(long prec);
GEN     consteuler(long prec);
GEN     constlog2(long prec);
GEN     constpi(long prec);
GEN     cxexpm1(GEN z, long prec);
GEN     ellE(GEN k, long prec);
GEN     ellK(GEN k, long prec);
GEN     expIr(GEN x);
GEN     exp1r_abs(GEN x);
GEN     gcos(GEN x, long prec);
GEN     gcotan(GEN x, long prec);
GEN     gcotanh(GEN x, long prec);
GEN     gexp(GEN x, long prec);
GEN     gexpm1(GEN x, long prec);
GEN     glog(GEN x, long prec);
GEN     glog1p(GEN x, long prec);
GEN     gpow(GEN x, GEN n, long prec);
GEN     gpowers(GEN x, long n);
GEN     gpowers0(GEN x, long n, GEN x0);
GEN     gpowgs(GEN x, long n);
GEN     grootsof1(long N, long prec);
GEN     gsin(GEN x, long prec);
GEN     gsinc(GEN x, long prec);
void    gsincos(GEN x, GEN *s, GEN *c, long prec);
GEN     gsqrpowers(GEN q, long n);
GEN     gsqrt(GEN x, long prec);
GEN     gsqrtn(GEN x, GEN n, GEN *zetan, long prec);
GEN     gtan(GEN x, long prec);
GEN     logr_abs(GEN x);
GEN     mpcos(GEN x);
GEN     mpeuler(long prec);
GEN     mpcatalan(long prec);
void    mpsincosm1(GEN x, GEN *s, GEN *c);
GEN     mpexp(GEN x);
GEN     mpexpm1(GEN x);
GEN     mplog(GEN x);
GEN     mplog2(long prec);
GEN     mppi(long prec);
GEN     mpsin(GEN x);
void    mpsincos(GEN x, GEN *s, GEN *c);
GEN     pow2Pis(GEN s, long prec);
GEN     powPis(GEN s, long prec);
GEN     powcx(GEN x, GEN logx, GEN n, long prec);
long    powcx_prec(long ex, GEN n, long prec);
GEN     powersr(GEN a, long n);
GEN     powis(GEN x, long n);
GEN     powiu(GEN p, ulong k);
GEN     powrfrac(GEN x, long n, long d);
GEN     powrs(GEN x, long n);
GEN     powrshalf(GEN x, long s);
GEN     powru(GEN x, ulong n);
GEN     powruhalf(GEN x, ulong s);
GEN     powuu(ulong p, ulong k);
GEN     powgi(GEN x, GEN n);
GEN     rootsof1_cx(GEN d, long prec);
GEN     rootsof1u_cx(ulong d, long prec);
GEN     rootsof1q_cx(long a, long b, long prec);
GEN     rootsof1powinit(long a, long b, long prec);
GEN     rootsof1pow(GEN T, long c);
GEN     serchop(GEN s, long n);
GEN     serchop_i(GEN s, long n);
GEN     serchop0(GEN s);
GEN     sqrtnint(GEN a, long n);
GEN     sqrtnr_abs(GEN x, long n);
GEN     teich(GEN x);
GEN     teichmullerinit(long p, long n);
GEN     teichmuller(GEN x, GEN tab);
GEN     trans_eval(const char *fun, GEN (*f) (GEN, long), GEN x, long prec);
GEN     trans_evalgen(const char *fun, void *E, GEN (*f) (void*,GEN,long), GEN x, long prec);
ulong   upowuu(ulong p, ulong k);
GEN     upowers(ulong x, long n);
ulong   usqrtn(ulong a, ulong n);
ulong   usqrt(ulong a);

/* trans2.c */

GEN     Qp_gamma(GEN x);
GEN     Qp_psi(GEN x, long k);
GEN     atanhuu(ulong u, ulong v, long prec);
GEN     atanhui(ulong u, GEN v, long prec);
double  dblcabs(double s, double t);
double  dblcarg(double s, double t);
void    dblclog(double s, double t, double *a, double *b);
double  dblcnorm(double s, double t);
GEN     gacosh(GEN x, long prec);
GEN     gacos(GEN x, long prec);
GEN     garg(GEN x, long prec);
GEN     gasinh(GEN x, long prec);
GEN     gasin(GEN x, long prec);
GEN     gatan(GEN x, long prec);
GEN     gatanh(GEN x, long prec);
GEN     gcosh(GEN x, long prec);
GEN     ggammah(GEN x, long prec);
GEN     ggamma(GEN x, long prec);
GEN     ggamma1m1(GEN x, long prec);
GEN     glngamma(GEN x, long prec);
GEN     gpsi(GEN x, long prec);
GEN     gpsi_der(GEN x, long k, long prec);
GEN     gsinh(GEN x, long prec);
GEN     gtanh(GEN x, long prec);
GEN     mpfactr(long n, long prec);
void    mpsinhcosh(GEN x, GEN *s, GEN *c);
GEN     psi1series(long n, long v, long prec);
GEN     sumformal(GEN T, long v);

/* trans3.c */
int     RgV_is_arithprog(GEN v, GEN *a, GEN *b);
GEN     besseljzero(GEN nu, long n, long b);
GEN     besselyzero(GEN nu, long n, long b);
GEN     constzeta(long n, long prec);
double  dblmodulus(GEN x);
GEN     dilog(GEN x, long prec);
GEN     eint1(GEN x, long prec);
GEN     gerfc(GEN x, long prec);
GEN     gpolylog(long m, GEN x, long prec);
GEN     gzeta(GEN x, long prec);
GEN     hbessel1(GEN n, GEN z, long prec);
GEN     hbessel2(GEN n, GEN z, long prec);
GEN     hyperu(GEN a, GEN b, GEN gx, long prec);
GEN     ibessel(GEN n, GEN z, long prec);
GEN     incgam(GEN a, GEN x, long prec);
GEN     incgam0(GEN a, GEN x, GEN z,long prec);
GEN     incgamc(GEN a, GEN x, long prec);
GEN     jbessel(GEN n, GEN z, long prec);
GEN     jbesselh(GEN n, GEN z, long prec);
GEN     kbessel(GEN nu, GEN gx, long prec);
GEN     mpeint1(GEN x, GEN expx);
GEN     mpveceint1(GEN C, GEN eC, long n);
GEN     polylog0(long m, GEN x, long flag, long prec);
GEN     szeta(long x, long prec);
GEN     veceint1(GEN nmax, GEN C, long prec);
GEN     veczeta(GEN a, GEN b, long N, long prec);
GEN     ybessel(GEN n, GEN z, long prec);

/* modsym.c */
GEN     SL2_inv_shallow(GEN M);
GEN     Qevproj_apply(GEN T, GEN pro);
GEN     Qevproj_apply_vecei(GEN T, GEN pro, long k);
GEN     Qevproj_down(GEN T, GEN pro);
GEN     Qevproj_init(GEN M);
GEN     RgX_act_Gl2Q(GEN g, long k);
GEN     RgX_act_ZGl2Q(GEN z, long k);
void    checkms(GEN W);
void    checkmspadic(GEN W);
GEN     ellpadiclambdamu(GEN E, long p, long D, long R);
GEN     mfnumcusps(GEN n);
GEN     mfnumcusps_fact(GEN fa);
ulong   mfnumcuspsu_fact(GEN fa);
ulong   mfnumcuspsu(ulong n);
GEN     msfromcusp(GEN W, GEN c);
GEN     msfromell(GEN E, long signe);
GEN     msfromhecke(GEN W, GEN v, GEN H);
long    msdim(GEN W);
GEN     mseval2_ooQ(GEN W, GEN xpm, GEN c);
long    msgetlevel(GEN W);
long    msgetsign(GEN W);
long    msgetweight(GEN W);
GEN     msatkinlehner(GEN W, long Q, GEN);
GEN     mscuspidal(GEN W, long flag);
GEN     mseisenstein(GEN W);
GEN     mseval(GEN W, GEN s, GEN p);
GEN     mshecke(GEN W, long p, GEN H);
GEN     msinit(GEN N, GEN k, long sign);
GEN     msissymbol(GEN W, GEN s);
GEN     mslattice(GEN M, GEN F);
GEN     msomseval(GEN W, GEN phi, GEN path);
void    mspadic_parse_chi(GEN s, GEN *s1, GEN *s2);
GEN     mspadic_unit_eigenvalue(GEN ap, long k, GEN p, long n);
GEN     mspadicinit(GEN W, long p, long n, long flag);
GEN     mspadicL(GEN oms, GEN s, long r);
GEN     mspadicmoments(GEN W, GEN phi, long D);
GEN     mspadicseries(GEN M, long teichi);
GEN     mspathgens(GEN W);
GEN     mspathlog(GEN W, GEN path);
GEN     msnew(GEN W);
GEN     mspetersson(GEN W, GEN F1, GEN F2);
GEN     mspolygon(GEN M, long flag);
GEN     msstar(GEN W, GEN);
GEN     msqexpansion(GEN W, GEN proV, long B);
GEN     mssplit(GEN W, GEN H, long deglim);
GEN     mstooms(GEN W, GEN phi);

/* mscosets.c */

GEN     mscosets0(GEN V, GEN code);
GEN     mscosets(GEN V, void *E, long (*in)(void *, GEN));
GEN     msfarey(GEN F, void *E, long (*in)(void *, GEN), GEN *pCM);
GEN     msfarey0(GEN F, GEN code, GEN *pCM);
int     checkfarey_i(GEN F);

/* zetamult.c */

GEN     polylogmult(GEN avec, GEN zvec, long prec);
GEN     polylogmult_interpolate(GEN avec, GEN zvec, GEN t, long prec);
GEN     zetamult(GEN avec, long prec);
GEN     zetamultdual(GEN s);
GEN     zetamult_interpolate(GEN avec, GEN t, long prec);
GEN     zetamultall(long k, long flag, long prec);
GEN     zetamultconvert(GEN a, long fl);

/* level1.h */

INLINE ulong  Fl_add(ulong a, ulong b, ulong p);
INLINE ulong  Fl_addmul_pre(ulong x0, ulong x1, ulong y0, ulong p, ulong pi);
INLINE ulong  Fl_addmulmul_pre(ulong x0, ulong y0, ulong x1, ulong y1, ulong p, ulong pi);
INLINE long   Fl_center(ulong u, ulong p, ulong ps2);
INLINE ulong  Fl_div(ulong a, ulong b, ulong p);
INLINE ulong  Fl_double(ulong a, ulong p);
INLINE ulong  Fl_ellj_pre(ulong a4, ulong a6, ulong p, ulong pi);
INLINE ulong  Fl_halve(ulong y, ulong p);
INLINE ulong  Fl_mul(ulong a, ulong b, ulong p);
INLINE ulong  Fl_mul_pre(ulong a, ulong b, ulong p, ulong pi);
INLINE ulong  Fl_neg(ulong x, ulong p);
INLINE ulong  Fl_sqr(ulong a, ulong p);
INLINE ulong  Fl_sqr_pre(ulong a, ulong p, ulong pi);
INLINE ulong  Fl_sub(ulong a, ulong b, ulong p);
INLINE ulong  Fl_triple(ulong a, ulong p);
INLINE ulong  Mod2(GEN x);
INLINE ulong  Mod4(GEN x);
INLINE ulong  Mod8(GEN x);
INLINE ulong  Mod16(GEN x);
INLINE ulong  Mod32(GEN x);
INLINE ulong  Mod64(GEN x);
INLINE int    abscmpiu(GEN x, ulong y);
INLINE int    abscmpui(ulong x, GEN y);
INLINE int    absequaliu(GEN x, ulong y);
INLINE GEN    absi(GEN x);
INLINE GEN    absi_shallow(GEN x);
INLINE GEN    absr(GEN x);
INLINE int    absrnz_equal1(GEN x);
INLINE int    absrnz_equal2n(GEN x);
INLINE GEN    addii(GEN x, GEN y);
INLINE GEN    addir(GEN x, GEN y);
INLINE GEN    addis(GEN x, long s);
INLINE GEN    addri(GEN x, GEN y);
INLINE GEN    addrr(GEN x, GEN y);
INLINE GEN    addrs(GEN x, long s);
INLINE GEN    addsi(long x, GEN y);
INLINE GEN    addss(long x, long y);
INLINE GEN    adduu(ulong x, ulong y);
INLINE void   affgr(GEN x, GEN y);
INLINE void   affii(GEN x, GEN y);
INLINE void   affrr_fixlg(GEN y, GEN z);
INLINE void   affsi(long s, GEN x);
INLINE void   affsr(long s, GEN x);
INLINE void   affui(ulong s, GEN x);
INLINE void   affur(ulong s, GEN x);
INLINE GEN    cgetg(long x, long y);
INLINE GEN    cgetg_block(long x, long y);
INLINE GEN    cgetg_copy(GEN x, long *plx);
INLINE GEN    cgeti(long x);
INLINE GEN    cgetineg(long x);
INLINE GEN    cgetipos(long x);
INLINE GEN    cgetr(long x);
INLINE GEN    cgetr_block(long prec);
INLINE int    cmpir(GEN x, GEN y);
INLINE int    cmpis(GEN x, long y);
INLINE int    cmpiu(GEN x, ulong y);
INLINE int    cmpri(GEN x, GEN y);
INLINE int    cmprs(GEN x, long y);
INLINE int    cmpsi(long x, GEN y);
INLINE int    cmpsr(long x, GEN y);
INLINE int    cmpss(long a, long b);
INLINE int    cmpui(ulong x, GEN y);
INLINE int    cmpuu(ulong a, ulong b);
INLINE GEN    cxtofp(GEN x, long prec);
INLINE GEN    divii(GEN a, GEN b);
INLINE GEN    divsi_rem(long x, GEN y, long *rem);
INLINE GEN    divss(long x, long y);
INLINE GEN    divss_rem(long x, long y, long *rem);
INLINE int    dvdii(GEN x, GEN y);
INLINE int    dvdis(GEN x, long y);
INLINE int    dvdiu(GEN x, ulong y);
INLINE int    dvdsi(long x, GEN y);
INLINE int    dvdui(ulong x, GEN y);
INLINE GEN    dvmdis(GEN x, long y, GEN *z);
INLINE long   dvmdsBIL(long n, long *r);
INLINE GEN    dvmdsi(long x, GEN y, GEN *z);
INLINE GEN    dvmdss(long x, long y, GEN *z);
INLINE ulong  dvmduBIL(ulong n, ulong *r);
INLINE int    equalis(GEN x, long y);
INLINE int    equalsi(long x, GEN y);
INLINE int    equalui(ulong x, GEN y);
INLINE int    equaliu(GEN x, ulong y);
INLINE int    absequalui(ulong x, GEN y);
INLINE ulong  ceildivuu(ulong a, ulong b);
INLINE long   evalexpo(long x);
INLINE long   evallg(long x);
INLINE long   evalprecp(long x);
INLINE long   evalvalp(long x);
INLINE long   evalvalser(long x);
INLINE long   expi(GEN x);
INLINE long   expu(ulong x);
INLINE void   fixlg(GEN z, long ly);
INLINE GEN    fractor(GEN x, long prec);
INLINE int    gc_bool(pari_sp av, int s);
INLINE GEN    gc_const(pari_sp av, GEN x);
INLINE double gc_double(pari_sp av, double d);
INLINE int    gc_int(pari_sp av, int s);
INLINE long   gc_long(pari_sp av, long s);
INLINE GEN    gc_stoi(pari_sp av, long x);
INLINE ulong  gc_ulong(pari_sp av, ulong s);
INLINE GEN    gc_utoi(pari_sp av, ulong x);
INLINE GEN    gc_utoipos(pari_sp av, ulong x);
INLINE GEN    gc_NULL(pari_sp av);
INLINE long   hammingu(ulong x);
INLINE GEN    icopy(GEN x);
INLINE GEN    icopyspec(GEN x, long nx);
INLINE GEN    icopy_avma(GEN x, pari_sp av);
INLINE ulong  int_bit(GEN x, long n);
INLINE GEN    itor(GEN x, long prec);
INLINE long   itos(GEN x);
INLINE long   itos_or_0(GEN x);
INLINE ulong  itou(GEN x);
INLINE ulong  itou_or_0(GEN x);
INLINE GEN    leafcopy(GEN x);
INLINE GEN    leafcopy_avma(GEN x, pari_sp av);
INLINE long   lg2prec(long x);
INLINE double maxdd(double x, double y);
INLINE long   maxss(long x, long y);
INLINE long   maxuu(ulong x, ulong y);
INLINE double mindd(double x, double y);
INLINE long   minss(long x, long y);
INLINE long   minuu(ulong x, ulong y);
INLINE long   mod16(GEN x);
INLINE long   mod2(GEN x);
INLINE ulong  mod2BIL(GEN x);
INLINE long   mod32(GEN x);
INLINE long   mod4(GEN x);
INLINE long   mod64(GEN x);
INLINE long   mod8(GEN x);
INLINE GEN    modis(GEN x, long y);
INLINE GEN    modsi(long x, GEN y);
INLINE GEN    modss(long x, long y);
INLINE GEN    mpabs(GEN x);
INLINE GEN    mpabs_shallow(GEN x);
INLINE GEN    mpadd(GEN x, GEN y);
INLINE GEN    mpceil(GEN x);
INLINE int    mpcmp(GEN x, GEN y);
INLINE GEN    mpcopy(GEN x);
INLINE GEN    mpdiv(GEN x, GEN y);
INLINE long   mpexpo(GEN x);
INLINE GEN    mpfloor(GEN x);
INLINE GEN    mpmul(GEN x, GEN y);
INLINE GEN    mpneg(GEN x);
INLINE int    mpodd(GEN x);
INLINE GEN    mpround(GEN x);
INLINE GEN    mpshift(GEN x,long s);
INLINE GEN    mpsqr(GEN x);
INLINE GEN    mpsub(GEN x, GEN y);
INLINE GEN    mptrunc(GEN x);
INLINE GEN    mulis(GEN x, long s);
INLINE GEN    muliu(GEN x, ulong s);
INLINE GEN    mulri(GEN x, GEN s);
INLINE GEN    mulrs(GEN x, long s);
INLINE GEN    mulru(GEN x, ulong s);
INLINE long   nbits2lg(long x);
INLINE GEN    negi(GEN x);
INLINE GEN    negr(GEN x);
INLINE GEN    new_chunk(size_t x);
INLINE GEN    rcopy(GEN x);
INLINE GEN    rdivii(GEN x, GEN y, long prec);
INLINE void   rdiviiz(GEN x, GEN y, GEN z);
INLINE GEN    rdivis(GEN x, long y, long prec);
INLINE GEN    rdivsi(long x, GEN y, long prec);
INLINE GEN    rdivss(long x, long y, long prec);
INLINE GEN    real2n(long n, long prec);
INLINE GEN    real_m2n(long n, long prec);
INLINE GEN    real_0(long prec);
INLINE GEN    real_0_bit(long bitprec);
INLINE GEN    real_1(long prec);
INLINE GEN    real_1_bit(long bit);
INLINE GEN    real_m1(long prec);
INLINE GEN    remii(GEN a, GEN b);
INLINE GEN    remis(GEN x, long y);
INLINE ulong  remlll_pre(ulong u2, ulong u1, ulong u0, ulong p, ulong pi);
INLINE GEN    remsi(long x, GEN y);
INLINE GEN    remss(long x, long y);
INLINE GEN    rtor(GEN x, long prec);
INLINE long   sdivsi(long x, GEN y);
INLINE long   sdivsi_rem(long x, GEN y, long *rem);
INLINE long   sdivss_rem(long x, long y, long *rem);
INLINE ulong  get_avma(void);
INLINE void   set_avma(ulong av);
INLINE ulong  uabsdiviu_rem(GEN n, ulong d, ulong *r);
INLINE ulong  udivuu_rem(ulong x, ulong y, ulong *r);
INLINE ulong  umodi2n(GEN x, long n);
INLINE void   setabssign(GEN x);
INLINE void   shift_left(GEN z2, GEN z1, long min, long M, ulong f,  ulong sh);
INLINE void   shift_right(GEN z2, GEN z1, long min, long M, ulong f, ulong sh);
INLINE ulong  shiftl(ulong x, ulong y);
INLINE ulong  shiftlr(ulong x, ulong y);
INLINE GEN    shiftr(GEN x, long n);
INLINE void   shiftr_inplace(GEN z, long d);
INLINE long   smodis(GEN x, long y);
INLINE long   smodss(long x, long y);
INLINE void   stackdummy(pari_sp av, pari_sp ltop);
INLINE char  *stack_malloc(size_t N);
INLINE char  *stack_malloc_align(size_t N, long k);
INLINE char  *stack_calloc(size_t N);
INLINE char  *stack_calloc_align(size_t N, long k);
INLINE GEN    stoi(long x);
INLINE GEN    stor(long x, long prec);
INLINE GEN    subii(GEN x, GEN y);
INLINE GEN    subir(GEN x, GEN y);
INLINE GEN    subis(GEN x, long y);
INLINE GEN    subri(GEN x, GEN y);
INLINE GEN    subrr(GEN x, GEN y);
INLINE GEN    subrs(GEN x, long y);
INLINE GEN    subsi(long x, GEN y);
INLINE GEN    subss(long x, long y);
INLINE GEN    subuu(ulong x, ulong y);
INLINE ulong  thuemorseu(ulong c);
INLINE void   togglesign(GEN x);
INLINE void   togglesign_safe(GEN *px);
INLINE void   affectsign(GEN x, GEN y);
INLINE void   affectsign_safe(GEN x, GEN *py);
INLINE GEN    truedivii(GEN a,GEN b);
INLINE GEN    truedivis(GEN a, long b);
INLINE GEN    truedivsi(long a, GEN b);
INLINE ulong  uabsdivui_rem(ulong x, GEN y, ulong *rem);
INLINE ulong  umodsu(long x, ulong y);
INLINE ulong  umodui(ulong x, GEN y);
INLINE ulong  ugcdiu(GEN x, ulong y);
INLINE ulong  ugcdui(ulong y, GEN x);
INLINE ulong  umuluu_le(ulong x, ulong y, ulong n);
INLINE ulong  umuluu_or_0(ulong x, ulong y);
INLINE GEN    utoi(ulong x);
INLINE GEN    utoineg(ulong x);
INLINE GEN    utoipos(ulong x);
INLINE GEN    utor(ulong s, long prec);
INLINE GEN    uutoi(ulong x, ulong y);
INLINE GEN    uutoineg(ulong x, ulong y);
INLINE long   vali(GEN x);
INLINE int    varncmp(long x, long y);
INLINE long   varnmax(long x, long y);
INLINE long   varnmin(long x, long y);

/* pariinl.h */
INLINE GEN    ZM_ZV_mod(GEN x, GEN y);
INLINE GEN    ZV_ZV_mod(GEN x, GEN y);
INLINE GEN    abgrp_get_cyc(GEN x);
INLINE GEN    abgrp_get_gen(GEN x);
INLINE GEN    abgrp_get_no(GEN x);
INLINE GEN    bid_get_MOD(GEN bid);
INLINE GEN    bid_get_U(GEN bid);
INLINE GEN    bid_get_arch(GEN bid);
INLINE GEN    bid_get_archp(GEN bid);
INLINE GEN    bid_get_cyc(GEN bid);
INLINE GEN    bid_get_fact(GEN bid);
INLINE GEN    bid_get_fact2(GEN bid);
INLINE GEN    bid_get_gen(GEN bid);
INLINE GEN    bid_get_gen_nocheck(GEN bid);
INLINE GEN    bid_get_grp(GEN bid);
INLINE GEN    bid_get_ideal(GEN bid);
INLINE GEN    bid_get_mod(GEN bid);
INLINE GEN    bid_get_no(GEN bid);
INLINE GEN    bid_get_sarch(GEN bid);
INLINE GEN    bid_get_sprk(GEN bid);
INLINE GEN    bnf_get_clgp(GEN bnf);
INLINE GEN    bnf_get_cyc(GEN bnf);
INLINE GEN    bnf_get_fu(GEN bnf);
INLINE GEN    bnf_get_fu_nocheck(GEN bnf);
INLINE GEN    bnf_get_gen(GEN bnf);
INLINE GEN    bnf_get_logfu(GEN bnf);
INLINE GEN    bnf_get_nf(GEN bnf);
INLINE GEN    bnf_get_no(GEN bnf);
INLINE GEN    bnf_get_reg(GEN bnf);
INLINE GEN    bnf_get_sunits(GEN bnf);
INLINE GEN    bnf_get_tuU(GEN bnf);
INLINE GEN    bnr_get_bid(GEN bnr);
INLINE GEN    bnr_get_bnf(GEN bnr);
INLINE GEN    bnr_get_clgp(GEN bnr);
INLINE GEN    bnr_get_cyc(GEN bnr);
INLINE GEN    bnr_get_gen(GEN bnr);
INLINE GEN    bnr_get_gen_nocheck(GEN bnr);
INLINE GEN    bnr_get_mod(GEN bnr);
INLINE GEN    bnr_get_nf(GEN bnr);
INLINE GEN    bnr_get_no(GEN bnr);
INLINE GEN    cyc_get_expo(GEN c);
INLINE GEN    ellQp_get_p(GEN E);
INLINE GEN    ellQp_get_zero(GEN x);
INLINE GEN    ell_get_a1(GEN e);
INLINE GEN    ell_get_a2(GEN e);
INLINE GEN    ell_get_a3(GEN e);
INLINE GEN    ell_get_a4(GEN e);
INLINE GEN    ell_get_a6(GEN e);
INLINE GEN    ell_get_b2(GEN e);
INLINE GEN    ell_get_b4(GEN e);
INLINE GEN    ell_get_b6(GEN e);
INLINE GEN    ell_get_b8(GEN e);
INLINE GEN    ell_get_c4(GEN e);
INLINE GEN    ell_get_c6(GEN e);
INLINE GEN    ell_get_disc(GEN e);
INLINE GEN    ell_get_j(GEN e);
INLINE GEN    ellff_get_a4a6(GEN x);
INLINE GEN    ellff_get_field(GEN x);
INLINE GEN    ellinf(void);
INLINE GEN    ellnf_get_bnf(GEN x);
INLINE GEN    ellnf_get_nf(GEN x);
INLINE GEN    gal_get_den(GEN gal);
INLINE GEN    gal_get_e(GEN gal);
INLINE GEN    gal_get_gen(GEN gal);
INLINE GEN    gal_get_group(GEN gal);
INLINE GEN    gal_get_invvdm(GEN gal);
INLINE GEN    gal_get_mod(GEN gal);
INLINE GEN    gal_get_orders(GEN gal);
INLINE GEN    gal_get_p(GEN gal);
INLINE GEN    gal_get_pol(GEN gal);
INLINE GEN    gal_get_roots(GEN gal);
INLINE GEN    idealchineseinit(GEN nf, GEN x);
INLINE GEN    idealred(GEN nf, GEN id);
INLINE GEN    modpr_get_T(GEN x);
INLINE GEN    modpr_get_p(GEN x);
INLINE GEN    modpr_get_pr(GEN x);
INLINE GEN    nfV_to_scalar_or_alg(GEN nf, GEN x);
INLINE GEN    nf_get_G(GEN nf);
INLINE GEN    nf_get_M(GEN nf);
INLINE GEN    nf_get_Tr(GEN nf);
INLINE GEN    nf_get_diff(GEN nf);
INLINE GEN    nf_get_disc(GEN nf);
INLINE GEN    nf_get_index(GEN nf);
INLINE GEN    nf_get_invzk(GEN nf);
INLINE GEN    nf_get_pol(GEN nf);
INLINE GEN    nf_get_ramified_primes(GEN nf);
INLINE GEN    nf_get_roots(GEN nf);
INLINE GEN    nf_get_roundG(GEN nf);
INLINE GEN    nf_get_zk(GEN nf);
INLINE GEN    nf_get_zkden(GEN nf);
INLINE GEN    nf_get_zkprimpart(GEN nf);
INLINE GEN    pr_get_gen(GEN pr);
INLINE GEN    pr_get_p(GEN pr);
INLINE GEN    pr_get_tau(GEN pr);
INLINE GEN    pr_norm(GEN pr);
INLINE GEN    rnf_get_alpha(GEN rnf);
INLINE GEN    rnf_get_disc(GEN rnf);
INLINE GEN    rnf_get_idealdisc(GEN rnf);
INLINE GEN    rnf_get_index(GEN rnf);
INLINE GEN    rnf_get_invzk(GEN rnf);
INLINE GEN    rnf_get_k(GEN rnf);
INLINE GEN    rnf_get_map(GEN rnf);
INLINE GEN    rnf_get_nf(GEN rnf);
INLINE GEN    rnf_get_nfpol(GEN rnf);
INLINE GEN    rnf_get_nfzk(GEN rnf);
INLINE GEN    rnf_get_pol(GEN rnf);
INLINE GEN    rnf_get_polabs(GEN rnf);
INLINE GEN    rnf_get_ramified_primes(GEN rnf);
INLINE GEN    rnf_get_zk(GEN nf);
INLINE GEN    vecmodii(GEN a, GEN b);
INLINE GEN    vecmoduu(GEN a, GEN b);
INLINE GEN    znstar_get_N(GEN G);
INLINE GEN    znstar_get_U(GEN G);
INLINE GEN    znstar_get_Ui(GEN G);
INLINE GEN    znstar_get_conreycyc(GEN G);
INLINE GEN    znstar_get_conreygen(GEN G);
INLINE GEN    znstar_get_cyc(GEN G);
INLINE GEN    znstar_get_faN(GEN G);
INLINE GEN    znstar_get_gen(GEN G);
INLINE GEN    znstar_get_no(GEN G);
INLINE GEN    znstar_get_pe(GEN G);
INLINE int    checkell_i(GEN e);
INLINE int    ell_is_inf(GEN z);
INLINE int    pr_is_inert(GEN P);
INLINE long   bnf_get_tuN(GEN bnf);
INLINE long   ellQp_get_prec(GEN E);
INLINE long   ellR_get_prec(GEN x);
INLINE long   ellR_get_sign(GEN x);
INLINE long   ell_get_type(GEN e);
INLINE long   logint(GEN B, GEN y);
INLINE long   nf_get_degree(GEN nf);
INLINE long   nf_get_r1(GEN nf);
INLINE long   nf_get_r2(GEN nf);
INLINE long   nf_get_varn(GEN nf);
INLINE long   pr_get_e(GEN pr);
INLINE long   pr_get_f(GEN pr);
INLINE long   rnf_get_absdegree(GEN rnf);
INLINE long   rnf_get_degree(GEN rnf);
INLINE long   rnf_get_nfdegree(GEN rnf);
INLINE long   rnf_get_nfvarn(GEN rnf);
INLINE long   rnf_get_varn(GEN rnf);
INLINE ulong  hash_str(const char *str);
INLINE ulong  hash_str_len(const char *s, long len);
INLINE ulong  ulogint(ulong B, ulong y);
INLINE ulong  upr_norm(GEN pr);
INLINE void   nf_get_sign(GEN nf, long *r1, long *r2);

INLINE long   closure_arity(GEN C);
INLINE const char * closure_codestr(GEN C);
INLINE GEN    closure_get_code(GEN C);
INLINE GEN    closure_get_oper(GEN C);
INLINE GEN    closure_get_data(GEN C);
INLINE GEN    closure_get_dbg(GEN C);
INLINE GEN    closure_get_text(GEN C);
INLINE GEN    closure_get_frame(GEN C);
INLINE long   closure_is_variadic(GEN C);

INLINE GEN    addmuliu(GEN x, GEN y, ulong u);
INLINE GEN    addmuliu_inplace(GEN x, GEN y, ulong u);
INLINE GEN    lincombii(GEN u, GEN v, GEN x, GEN y);
INLINE GEN    mulsubii(GEN y, GEN z, GEN x);
INLINE GEN    submulii(GEN x, GEN y, GEN z);
INLINE GEN    submuliu(GEN x, GEN y, ulong u);
INLINE GEN    submuliu_inplace(GEN x, GEN y, ulong u);

INLINE GEN    FpXQ_add(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    FpXQ_sub(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    Flxq_add(GEN x,GEN y,GEN T,ulong p);
INLINE GEN    Flxq_sub(GEN x,GEN y,GEN T,ulong p);

INLINE GEN    FpXQX_div(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FlxqX_div(GEN x, GEN y, GEN T, ulong p);
INLINE GEN    FlxqX_div_pre(GEN x, GEN y, GEN T, ulong p, ulong pi);
INLINE GEN    F2xqX_div(GEN x, GEN y, GEN T);

INLINE GEN    Rg_to_Fq(GEN x, GEN T, GEN p);
INLINE GEN    Fq_red(GEN x, GEN T, GEN p);
INLINE GEN    Fq_to_FpXQ(GEN x, GEN T, GEN p);
INLINE GEN    gener_Fq_local(GEN T, GEN p, GEN L);
INLINE GEN    random_Fq(GEN T, GEN p);

INLINE GEN    FpXY_Fq_evaly(GEN Q, GEN y, GEN T, GEN p, long vx);
INLINE GEN    FqX_Fp_mul(GEN P, GEN U, GEN T, GEN p);
INLINE GEN    FqX_Fq_mul(GEN P, GEN U, GEN T, GEN p);
INLINE GEN    FqX_add(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    FqX_ddf(GEN f, GEN T, GEN p);
INLINE GEN    FqX_degfact(GEN f, GEN T, GEN p);
INLINE GEN    FqX_deriv(GEN f, GEN T, GEN p);
INLINE GEN    FqX_div(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_div_by_X_x(GEN x, GEN y, GEN T, GEN p, GEN *z);
INLINE GEN    FqX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *z);
INLINE GEN    FqX_extgcd(GEN P,GEN Q,GEN T,GEN p, GEN *U, GEN *V);
INLINE GEN    FqX_factor(GEN f, GEN T, GEN p);
INLINE GEN    FqX_factor_squarefree(GEN f, GEN T, GEN p);
INLINE GEN    FqX_gcd(GEN P, GEN Q, GEN T, GEN p);
INLINE GEN    FqX_get_red(GEN S, GEN T, GEN p);
INLINE GEN    FqX_halfgcd(GEN P,GEN Q,GEN T,GEN p);
INLINE GEN    FqX_halve(GEN x, GEN T, GEN p);
INLINE GEN    FqX_integ(GEN f, GEN T, GEN p);
INLINE long   FqX_is_squarefree(GEN P, GEN T, GEN p);
INLINE GEN    FqX_mul(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_mulu(GEN x, ulong y, GEN T, GEN p);
INLINE GEN    FqX_neg(GEN x, GEN T, GEN p);
INLINE GEN    FqX_normalize(GEN z, GEN T, GEN p);
INLINE GEN    FqX_powu(GEN x, ulong n, GEN T, GEN p);
INLINE GEN    FqX_red(GEN z, GEN T, GEN p);
INLINE GEN    FqX_rem(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_roots(GEN f, GEN T, GEN p);
INLINE GEN    FqX_sqr(GEN x, GEN T, GEN p);
INLINE GEN    FqX_sub(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    FqX_to_mod(GEN f, GEN T, GEN p);

INLINE GEN    FqXQ_add(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_div(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_inv(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_invsafe(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_sqr(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_sub(GEN x, GEN y, GEN S, GEN T, GEN p);

INLINE GEN    FqXn_exp(GEN x, long n, GEN T, GEN p);
INLINE GEN    FqXn_expint(GEN x, long n, GEN T, GEN p);
INLINE GEN    FqXn_inv(GEN x, long n, GEN T, GEN p);
INLINE GEN    FqXn_mul(GEN x, GEN y, long n, GEN T, GEN p);
INLINE GEN    FqXn_sqr(GEN x, long n, GEN T, GEN p);

INLINE long   get_F2x_degree(GEN T);
INLINE GEN    get_F2x_mod(GEN T);
INLINE long   get_F2x_var(GEN T);
INLINE long   get_F2xqX_degree(GEN T);
INLINE GEN    get_F2xqX_mod(GEN T);
INLINE long   get_F2xqX_var(GEN T);
INLINE long   get_Flx_degree(GEN T);
INLINE GEN    get_Flx_mod(GEN T);
INLINE long   get_Flx_var(GEN T);
INLINE long   get_FlxqX_degree(GEN T);
INLINE GEN    get_FlxqX_mod(GEN T);
INLINE long   get_FlxqX_var(GEN T);
INLINE long   get_FpX_degree(GEN T);
INLINE GEN    get_FpX_mod(GEN T);
INLINE long   get_FpX_var(GEN T);
INLINE long   get_FpXQX_degree(GEN T);
INLINE GEN    get_FpXQX_mod(GEN T);
INLINE long   get_FpXQX_var(GEN T);

INLINE ulong  F2m_coeff(GEN x, long a, long b);
INLINE void   F2m_clear(GEN x, long a, long b);
INLINE void   F2m_flip(GEN x, long a, long b);
INLINE void   F2m_set(GEN x, long a, long b);
INLINE void   F2v_clear(GEN x,long v);
INLINE ulong  F2v_coeff(GEN x,long v);
INLINE void   F2v_flip(GEN x,long v);
INLINE GEN    F2v_to_F2x(GEN x, long sv);
INLINE void   F2v_set(GEN x,long v);
INLINE void   F2x_clear(GEN x,long v);
INLINE ulong  F2x_coeff(GEN x,long v);
INLINE void   F2x_flip(GEN x,long v);
INLINE void   F2x_set(GEN x,long v);
INLINE int    F2x_equal1(GEN x);
INLINE int    F2x_equal(GEN V, GEN W);
INLINE GEN    F2x_div(GEN x, GEN y);
INLINE GEN    F2x_renormalize(GEN x, long lx);
INLINE GEN    F2m_copy(GEN x);
INLINE GEN    F2v_copy(GEN x);
INLINE GEN    F2x_copy(GEN x);
INLINE GEN    F2v_ei(long n, long i);
INLINE GEN    F2xX_shift(GEN a, long n, long vs);
INLINE ulong  F3m_coeff(GEN x, long a, long b);
INLINE void   F3m_set(GEN x, long a, long b, ulong c);
INLINE GEN    F3m_copy(GEN x);
INLINE GEN    Flm_copy(GEN x);
INLINE GEN    Flv_copy(GEN x);
INLINE int    Flx_equal1(GEN x);
INLINE ulong  Flx_constant(GEN x);
INLINE GEN    Flx_copy(GEN x);
INLINE GEN    Flx_div(GEN x, GEN y, ulong p);
INLINE GEN    Flx_div_pre(GEN x, GEN y, ulong p, ulong pi);
INLINE ulong  Flx_lead(GEN x);
INLINE GEN    Flx_mulu(GEN x, ulong a, ulong p);
INLINE GEN    Fp_divu(GEN x, ulong a, GEN p);
INLINE GEN    FpV_FpC_mul(GEN x, GEN y, GEN p);
INLINE GEN    FpXQX_renormalize(GEN x, long lx);
INLINE GEN    FpXX_renormalize(GEN x, long lx);
INLINE GEN    FpX_div(GEN x, GEN y, GEN p);
INLINE GEN    FpX_renormalize(GEN x, long lx);
INLINE GEN    Fp_add(GEN a, GEN b, GEN m);
INLINE GEN    Fp_addmul(GEN x, GEN y, GEN z, GEN p);
INLINE GEN    Fp_center(GEN u, GEN p, GEN ps2);
INLINE GEN    Fp_center_i(GEN u, GEN p, GEN ps2);
INLINE GEN    Fp_div(GEN a, GEN b, GEN m);
INLINE GEN    Fp_double(GEN x, GEN N);
INLINE GEN    Fp_halve(GEN y, GEN p);
INLINE GEN    Fp_inv(GEN a, GEN m);
INLINE GEN    Fp_invsafe(GEN a, GEN m);
INLINE GEN    Fp_mul(GEN a, GEN b, GEN m);
INLINE GEN    Fp_muls(GEN a, long b, GEN m);
INLINE GEN    Fp_mulu(GEN a, ulong b, GEN m);
INLINE GEN    Fp_neg(GEN b, GEN m);
INLINE GEN    Fp_red(GEN x, GEN p);
INLINE GEN    Fp_sqr(GEN a, GEN m);
INLINE GEN    Fp_sub(GEN a, GEN b, GEN m);
INLINE GEN    GENbinbase(GENbin *p);
INLINE GEN    Q_abs(GEN x);
INLINE GEN    Q_abs_shallow(GEN x);
INLINE int    QV_isscalar(GEN x);
INLINE void   Qtoss(GEN q, long *n, long *d);
INLINE GEN    R_abs(GEN x);
INLINE GEN    R_abs_shallow(GEN x);
INLINE GEN    RgC_fpnorml2(GEN x, long prec);
INLINE GEN    RgC_gtofp(GEN x, long prec);
INLINE GEN    RgC_gtomp(GEN x, long prec);
INLINE void   RgM_dimensions(GEN x, long *m, long *n);
INLINE GEN    RgM_fpnorml2(GEN x, long prec);
INLINE GEN    RgM_gtofp(GEN x, long prec);
INLINE GEN    RgM_gtomp(GEN x, long prec);
INLINE GEN    RgM_minor(GEN a, long i, long j);
INLINE GEN    RgM_shallowcopy(GEN x);
INLINE GEN    RgV_gtofp(GEN x, long prec);
INLINE int    RgV_isscalar(GEN x);
INLINE long   RgV_isin(GEN v, GEN x);
INLINE long   RgV_isin_i(GEN v, GEN x, long n);
INLINE int    RgV_is_ZV(GEN x);
INLINE int    RgV_is_QV(GEN x);
INLINE long   RgX_equal_var(GEN x, GEN y);
INLINE int    RgX_is_monomial(GEN x);
INLINE int    RgX_is_rational(GEN x);
INLINE int    RgX_is_QX(GEN x);
INLINE int    RgX_is_ZX(GEN x);
INLINE int    RgX_isscalar(GEN x);
INLINE GEN    RgX_shift_inplace(GEN x, long v);
INLINE void   RgX_shift_inplace_init(long v);
INLINE GEN    RgX_to_RgV(GEN x, long N);
INLINE GEN    RgXQX_div(GEN x, GEN y, GEN T);
INLINE GEN    RgXQX_rem(GEN x, GEN y, GEN T);
INLINE GEN    RgX_coeff(GEN x, long n);
INLINE GEN    RgX_copy(GEN x);
INLINE GEN    RgX_div(GEN x, GEN y);
INLINE GEN    RgX_fpnorml2(GEN x, long prec);
INLINE GEN    RgX_gtofp(GEN x, long prec);
INLINE GEN    RgX_renormalize(GEN x);
INLINE GEN    Rg_col_ei(GEN x, long n, long i);
INLINE GEN    ZC_hnfrem(GEN x, GEN y);
INLINE GEN    ZM_hnfrem(GEN x, GEN y);
INLINE GEN    ZM_lll(GEN x, double D, long f);
INLINE int    ZV_dvd(GEN x, GEN y);
INLINE int    ZV_isscalar(GEN x);
INLINE GEN    ZV_to_zv(GEN x);
INLINE int    ZX_equal1(GEN x);
INLINE int    ZX_is_monic(GEN x);
INLINE GEN    ZX_renormalize(GEN x, long lx);
INLINE GEN    ZXQ_mul(GEN x,GEN y,GEN T);
INLINE GEN    ZXQ_sqr(GEN x,GEN T);
INLINE long   Z_ispower(GEN x, ulong k);
INLINE long   Z_issquare(GEN x);
INLINE GEN    absfrac(GEN x);
INLINE GEN    absfrac_shallow(GEN x);
INLINE GEN    affc_fixlg(GEN x, GEN res);
INLINE GEN    bin_copy(GENbin *p);
INLINE long   bit_accuracy(long x);
INLINE double bit_accuracy_mul(long x, double y);
INLINE long   bit_prec(GEN x);
INLINE int    both_odd(long x, long y);
INLINE GEN    cbrtr(GEN x);
INLINE GEN    cbrtr_abs(GEN x);
INLINE GEN    cgetc(long x);
INLINE GEN    cgetalloc(size_t l, long t);
INLINE void   cgiv(GEN x);
INLINE GEN    col_ei(long n, long i);
INLINE GEN    const_col(long n, GEN x);
INLINE GEN    const_vec(long n, GEN x);
INLINE GEN    const_vecsmall(long n, long c);
INLINE GEN    constant_coeff(GEN x);
INLINE GEN    cxcompotor(GEN z, long prec);
INLINE GEN    cxnorm(GEN x);
INLINE GEN    cxtoreal(GEN q);
INLINE GEN    cyclic_perm(long l, long d);
INLINE double dbllog2r(GEN x);
INLINE long   degpol(GEN x);
INLINE long   divsBIL(long n);
INLINE GEN    gaddgs(GEN y, long s);
INLINE GEN    gc_all(pari_sp av, int n, ...);
INLINE GEN    gc_GEN(pari_sp av, GEN x);
INLINE int    gcmpgs(GEN y, long s);
INLINE GEN    gdivsg(long s, GEN y);
INLINE GEN    gen_I(void);
INLINE void   gc_slice(pari_sp av, GEN x, int n);
INLINE int    gequalgs(GEN y, long s);
INLINE GEN    gc_upto(pari_sp av, GEN q);
INLINE GEN    gc_INT(pari_sp av, GEN q);
INLINE void   gc_INT_affii(pari_sp av, GEN x, GEN *y);
INLINE GEN    gc_leaf(pari_sp av, GEN q);
INLINE int    gisdouble(GEN x, double *g);
INLINE GEN    gmax_shallow(GEN x, GEN y);
INLINE GEN    gmaxsg(long s, GEN y);
INLINE GEN    gmin_shallow(GEN x, GEN y);
INLINE GEN    gminsg(long s, GEN y);
INLINE GEN    gmulgs(GEN y, long s);
INLINE GEN    gmulgu(GEN y, ulong s);
INLINE GEN    gsubgs(GEN y, long s);
INLINE double gtodouble(GEN x);
INLINE GEN    gtofp(GEN z, long prec);
INLINE GEN    gtomp(GEN z, long prec);
INLINE long   gtos(GEN x);
INLINE ulong  gtou(GEN x);
INLINE void   guncloneNULL(GEN x);
INLINE void   guncloneNULL_deep(GEN x);
INLINE long   gval(GEN x, long v);
INLINE GEN    identity_perm(long l);
INLINE GEN    identity_zv(long n);
INLINE GEN    identity_ZV(long n);
INLINE int    equali1(GEN n);
INLINE int    equalim1(GEN n);
INLINE long   inf_get_sign(GEN x);
INLINE GEN    inv_content(GEN c);
INLINE int    is_bigint(GEN n);
INLINE int    is_const_t(long t);
INLINE int    is_extscalar_t(long t);
INLINE int    is_intreal_t(long t);
INLINE int    is_matvec_t(long t);
INLINE int    is_noncalc_t(long tx);
INLINE int    is_pm1(GEN n);
INLINE int    is_qfb_t(long t);
INLINE int    is_rational_t(long t);
INLINE int    is_real_t(long t);
INLINE int    is_recursive_t(long t);
INLINE int    is_scalar_t(long t);
INLINE int    is_universal_constant(GEN x);
INLINE int    is_vec_t(long t);
INLINE int    isint1(GEN x);
INLINE int    isintm1(GEN x);
INLINE int    isintzero(GEN x);
INLINE int    ismpzero(GEN x);
INLINE int    isonstack(GEN x);
INLINE void   killblock(GEN x);
INLINE GEN    leading_coeff(GEN x);
INLINE void   lg_increase(GEN x);
INLINE long   lgcols(GEN x);
INLINE long   lgpol(GEN x);
INLINE GEN    div_content(GEN cx, GEN cy);
INLINE GEN    matpascal(long n);
INLINE GEN    matslice(GEN A, long x1, long x2, long y1, long y2);
INLINE GEN    mkcol(GEN x);
INLINE GEN    mkcol2(GEN x, GEN y);
INLINE GEN    mkcol2s(long x, long y);
INLINE GEN    mkcol3(GEN x, GEN y, GEN z);
INLINE GEN    mkcol3s(long x, long y, long z);
INLINE GEN    mkcol4(GEN x, GEN y, GEN z, GEN t);
INLINE GEN    mkcol4s(long x, long y, long z, long t);
INLINE GEN    mkcol5(GEN x, GEN y, GEN z, GEN t, GEN u);
INLINE GEN    mkcol6(GEN x, GEN y, GEN z, GEN t, GEN u, GEN v);
INLINE GEN    mkcolcopy(GEN x);
INLINE GEN    mkcols(long x);
INLINE GEN    mkcomplex(GEN x, GEN y);
INLINE GEN    mkerr(long n);
INLINE GEN    mkmoo(void);
INLINE GEN    mkoo(void);
INLINE GEN    mkfrac(GEN x, GEN y);
INLINE GEN    mkfracss(long x, long y);
INLINE GEN    mkfraccopy(GEN x, GEN y);
INLINE GEN    mkintmod(GEN x, GEN y);
INLINE GEN    mkintmodu(ulong x, ulong y);
INLINE GEN    mkmat(GEN x);
INLINE GEN    mkmat2(GEN x, GEN y);
INLINE GEN    mkmat22(GEN a, GEN b, GEN c, GEN d);
INLINE GEN    mkmat22s(long a, long b, long c, long d);
INLINE GEN    mkmat3(GEN x, GEN y, GEN z);
INLINE GEN    mkmat4(GEN x, GEN y, GEN z, GEN t);
INLINE GEN    mkmat5(GEN x, GEN y, GEN z, GEN t, GEN u);
INLINE GEN    mkmatcopy(GEN x);
INLINE GEN    mkpadic(GEN x, GEN p, GEN pd, long e, long d);
INLINE GEN    mkpolmod(GEN x, GEN y);
INLINE GEN    mkqfb(GEN x, GEN y, GEN z, GEN d);
INLINE GEN    mkquad(GEN n, GEN x, GEN y);
INLINE GEN    mkrfrac(GEN x, GEN y);
INLINE GEN    mkrfraccopy(GEN x, GEN y);
INLINE GEN    mkvec(GEN x);
INLINE GEN    mkvec2(GEN x, GEN y);
INLINE GEN    mkvec2copy(GEN x, GEN y);
INLINE GEN    mkvec2s(long x, long y);
INLINE GEN    mkvec3(GEN x, GEN y, GEN z);
INLINE GEN    mkvec3s(long x, long y, long z);
INLINE GEN    mkvec4(GEN x, GEN y, GEN z, GEN t);
INLINE GEN    mkvec4s(long x, long y, long z, long t);
INLINE GEN    mkvec5(GEN x, GEN y, GEN z, GEN t, GEN u);
INLINE GEN    mkvec5s(long x, long y, long z, long t, long u);
INLINE GEN    mkvec6(GEN x, GEN y, GEN z, GEN t, GEN u, GEN v);
INLINE GEN    mkvec6s(long x, long y, long z, long t, long u, long v);
INLINE GEN    mkveccopy(GEN x);
INLINE GEN    mkvecs(long x);
INLINE GEN    mkvecsmall(long x);
INLINE GEN    mkvecsmall2(long x,long y);
INLINE GEN    mkvecsmall3(long x,long y,long z);
INLINE GEN    mkvecsmall4(long x,long y,long z,long t);
INLINE GEN    mkvecsmall5(long x,long y,long z,long t,long u);
INLINE GEN    mul_content(GEN cx, GEN cy);
INLINE GEN    mul_denom(GEN cx, GEN cy);
INLINE long   nbits2nlong(long x);
INLINE long   nbits2extraprec(long x);
INLINE long   nbits2ndec(long x);
INLINE long   nbits2prec(long x);
INLINE long   nbrows(GEN x);
INLINE long   nchar2nlong(long x);
INLINE long   ndec2nbits(long x);
INLINE long   ndec2nlong(long x);
INLINE long   ndec2prec(long x);
INLINE void   normalize_frac(GEN z);
INLINE int    odd(long x);
INLINE void   pari_free(void *pointer);
INLINE void*  pari_calloc(size_t size);
INLINE void*  pari_malloc(size_t bytes);
INLINE void*  pari_realloc(void *pointer,size_t size);
INLINE void   pari_realloc_ip(void **pointer,size_t size);
INLINE GEN    perm_conj(GEN s, GEN t);
INLINE GEN    perm_inv(GEN x);
INLINE GEN    perm_mul(GEN s, GEN t);
INLINE GEN    perm_sqr(GEN s);
INLINE GEN    pol_0(long v);
INLINE GEN    pol_1(long v);
INLINE GEN    pol_x(long v);
INLINE GEN    pol_xn(long n, long v);
INLINE GEN    pol_xnall(long n, long v);
INLINE GEN    pol0_F2x(long sv);
INLINE GEN    pol0_Flx(long sv);
INLINE GEN    pol1_F2x(long sv);
INLINE GEN    pol1_Flx(long sv);
INLINE GEN    polx_Flx(long sv);
INLINE GEN    polx_F2x(long sv);
INLINE GEN    polx_zx(long sv);
INLINE GEN    polxn_Flx(long n, long sv);
INLINE GEN    powii(GEN x, GEN n);
INLINE GEN    powIs(long n);
INLINE long   prec2lg(long x);
INLINE long   prec2nbits(long x);
INLINE double prec2nbits_mul(long x, double y);
INLINE long   prec2ndec(long x);
INLINE long   precdbl(long x);
INLINE GEN    quad_disc(GEN x);
INLINE GEN    qfb_disc(GEN x);
INLINE GEN    qfb_disc3(GEN x, GEN y, GEN z);
INLINE GEN    quadnorm(GEN q);
INLINE long   remsBIL(long n);
INLINE GEN    row(GEN A, long x1);
INLINE GEN    Flm_row(GEN A, long x0);
INLINE GEN    row_i(GEN A, long x0, long x1, long x2);
INLINE GEN    zm_row(GEN x, long i);
INLINE GEN    rowcopy(GEN A, long x0);
INLINE GEN    rowpermute(GEN A, GEN p);
INLINE GEN    rowslice(GEN A, long x1, long x2);
INLINE GEN    rowslicepermute(GEN A, GEN p, long x1, long x2);
INLINE GEN    rowsplice(GEN a, long j);
INLINE int    ser_isexactzero(GEN x);
INLINE GEN    shallowcopy(GEN x);
INLINE GEN    sqrfrac(GEN x);
INLINE GEN    sqrti(GEN x);
INLINE GEN    sqrtnr(GEN x, long n);
INLINE GEN    sqrtr(GEN x);
INLINE GEN    sstoQ(long n, long d);
INLINE GEN    uutoQ(ulong n, ulong d);
INLINE void   pari_stack_alloc(pari_stack *s, long nb);
INLINE void** pari_stack_base(pari_stack *s);
INLINE void   pari_stack_delete(pari_stack *s);
INLINE void   pari_stack_init(pari_stack *s, size_t size, void **data);
INLINE long   pari_stack_new(pari_stack *s);
INLINE void   pari_stack_pushp(pari_stack *s, void *u);
INLINE long   sturm(GEN x);
INLINE GEN    truecoef(GEN x, long n);
INLINE GEN    trunc_safe(GEN x);
INLINE GEN    vec_ei(long n, long i);
INLINE GEN    vec_append(GEN v, GEN s);
INLINE GEN    vec_lengthen(GEN v, long n);
INLINE GEN    vec_prepend(GEN v, GEN s);
INLINE GEN    vec_setconst(GEN v, GEN x);
INLINE GEN    vec_shorten(GEN v, long n);
INLINE GEN    vec_to_vecsmall(GEN z);
INLINE GEN    veclast(GEN A);
INLINE GEN    vecpermute(GEN A, GEN p);
INLINE GEN    vecreverse(GEN A);
INLINE void   vecreverse_inplace(GEN y);
INLINE GEN    vecsmallpermute(GEN A, GEN p);
INLINE GEN    vecslice(GEN A, long y1, long y2);
INLINE GEN    vecslicepermute(GEN A, GEN p, long y1, long y2);
INLINE GEN    vecsplice(GEN a, long j);
INLINE GEN    vecsmall_append(GEN V, long s);
INLINE long   vecsmall_coincidence(GEN u, GEN v);
INLINE GEN    vecsmall_concat(GEN u, GEN v);
INLINE GEN    vecsmall_copy(GEN x);
INLINE GEN    vecsmall_ei(long n, long i);
INLINE long   vecsmall_indexmax(GEN x);
INLINE long   vecsmall_indexmin(GEN x);
INLINE long   vecsmall_isin(GEN v, long x);
INLINE GEN    vecsmall_lengthen(GEN v, long n);
INLINE int    vecsmall_lexcmp(GEN x, GEN y);
INLINE long   vecsmall_max(GEN v);
INLINE long   vecsmall_min(GEN v);
INLINE long   vecsmall_pack(GEN V, long base, long mod);
INLINE int    vecsmall_prefixcmp(GEN x, GEN y);
INLINE GEN    vecsmall_prepend(GEN V, long s);
INLINE GEN    vecsmall_reverse(GEN A);
INLINE GEN    vecsmall_shorten(GEN v, long n);
INLINE GEN    vecsmall_to_col(GEN z);
INLINE GEN    vecsmall_to_vec(GEN z);
INLINE GEN    vecsmall_to_vec_inplace(GEN z);
INLINE void   vecsmalltrunc_append(GEN x, long t);
INLINE GEN    vecsmalltrunc_init(long l);
INLINE void   vectrunc_append(GEN x, GEN t);
INLINE void   vectrunc_append_batch(GEN x, GEN y);
INLINE GEN    vectrunc_init(long l);
INLINE GEN    coltrunc_init(long l);
INLINE GEN    zc_to_ZC(GEN x);
INLINE GEN    zero_F2m(long n, long m);
INLINE GEN    zero_F2m_copy(long n, long m);
INLINE GEN    zero_F2v(long m);
INLINE GEN    zero_F2x(long sv);
INLINE GEN    zero_Flm(long m, long n);
INLINE GEN    zero_Flm_copy(long m, long n);
INLINE GEN    zero_Flv(long n);
INLINE GEN    zero_Flx(long sv);
INLINE GEN    zero_zm(long x, long y);
INLINE GEN    zero_zv(long x);
INLINE GEN    zero_zx(long sv);
INLINE GEN    zerocol(long n);
INLINE GEN    zeromat(long m, long n);
INLINE GEN    zeromatcopy(long m, long n);
INLINE GEN    zeropadic(GEN p, long e);
INLINE GEN    zeropadic_shallow(GEN p, long e);
INLINE GEN    zeropol(long v);
INLINE GEN    zeroser(long v, long e);
INLINE GEN    zerovec(long n);
INLINE GEN    zerovec_block(long len);
INLINE GEN    zm_copy(GEN x);
INLINE GEN    zm_to_zxV(GEN x, long sv);
INLINE GEN    zm_transpose(GEN x);
INLINE GEN    zv_copy(GEN x);
INLINE GEN    zv_to_ZV(GEN x);
INLINE GEN    zv_to_zx(GEN x, long sv);
INLINE GEN    zx_renormalize(GEN x, long l);
INLINE GEN    zx_shift(GEN x, long n);
INLINE GEN    zx_to_zv(GEN x, long N);

INLINE GEN     err_get_compo(GEN e, long i);
INLINE long    err_get_num(GEN e);
INLINE void    pari_err_BUG(const char *f);
INLINE void    pari_err_COMPONENT(const char *f, const char *op, GEN l, GEN x);
INLINE void    pari_err_CONSTPOL(const char *f);
INLINE void    pari_err_COPRIME(const char *f, GEN x, GEN y);
INLINE void    pari_err_DIM(const char *f);
INLINE void    pari_err_DOMAIN(const char *f, const char *v, const char *op, GEN l, GEN x);
INLINE void    pari_err_FILE(const char *f, const char *g);
INLINE void    pari_err_FILEDESC(const char *f, long n);
INLINE void    pari_err_FLAG(const char *f);
INLINE void    pari_err_IMPL(const char *f);
INLINE void    pari_err_INV(const char *f, GEN x);
INLINE void    pari_err_IRREDPOL(const char *f, GEN x);
INLINE void    pari_err_MAXPRIME(ulong c);
INLINE void    pari_err_MODULUS(const char *f, GEN x, GEN y);
INLINE void    pari_err_OP(const char *f, GEN x, GEN y);
INLINE void    pari_err_OVERFLOW(const char *f);
INLINE void    pari_err_PACKAGE(const char *f);
INLINE void    pari_err_PREC(const char *f);
INLINE void    pari_err_PRIME(const char *f, GEN x);
INLINE void    pari_err_PRIORITY(const char *f, GEN x, const char *op, long v);
INLINE void    pari_err_SQRTN(const char *f, GEN x);
INLINE void    pari_err_TYPE(const char *f, GEN x);
INLINE void    pari_err_TYPE2(const char *f, GEN x, GEN y);
INLINE void    pari_err_VAR(const char *f, GEN x, GEN y);
INLINE void    pari_err_ROOTS0(const char *f);
